#include <ansi_c.h>
#include <windows.h>
#include <utility.h>

#include "buffer.h"

#define ADC_MAX_CODE		8192
/*    */
#define ADC_OFFSET_A		(-ADC_MAX_CODE - 39)
#define ADC_OFFSET_B		(-ADC_MAX_CODE + 32)

#define N_CHANNELS	2

/* ,         */
static long buffer_size;	/*      */
static long n_buffers;		/*   */

static HANDLE hMemMapFile;	/*     */

/*         */
static unsigned char  *memPtr;
static unsigned int   *memPtrUI;
static unsigned short *memPtrUS;

static long get_milliseconds(void)
{
	FILETIME ftime;
	ULARGE_INTEGER rtime;

	GetSystemTimeAsFileTime(&ftime);
	rtime.LowPart = ftime.dwLowDateTime;
	rtime.HighPart = ftime.dwHighDateTime;

	return (long)(rtime.QuadPart / 10000);
}

/*        */
static char *prio2text(int pri_class)
{
	char *prio = "unknown";

	switch(pri_class) {
	case 0x00008000:
		prio = "ABOVE_NORMAL_PRIORITY_CLASS";
		break;
	case 0x00004000:
		prio = "BELOW_NORMAL_PRIORITY_CLASS";
		break;
	case 0x00000080:
		prio = "HIGH_PRIORITY_CLASS";
		break;
	case 0x00000040:
		prio = "IDLE_PRIORITY_CLASS";
		break;
	case 0x00000020:
		prio = "NORMAL_PRIORITY_CLASS";
		break;
	case 0x00100000:
		prio = "PROCESS_MODE_BACKGROUND_BEGIN";
		break;
	case 0x00200000:
		prio = "PROCESS_MODE_BACKGROUND_END";
		break;
	case 0x00000100:
		prio = "REALTIME_PRIORITY_CLASS";
		break;
	default:
		break;
	}
	return prio;
}

static int start_server(void)
{
	unsigned long i, j, k, ulStreamSize;
	int g_exeHandle;
	DWORD dwPriClass;
	char *prio;

	SetPriorityClass(GetCurrentProcess(), REALTIME_PRIORITY_CLASS);
	dwPriClass = GetPriorityClass(GetCurrentProcess());

	printf("Client priority: %s\n", prio2text(dwPriClass));
	if (LaunchExecutableEx("ADC1402_server.exe", LE_HIDE, &g_exeHandle)) {
		printf("Cannot start ADC1402_server.exe\n");
		return 1;
	}
	Delay(2.0);

	hMemMapFile = OpenFileMapping(FILE_MAP_ALL_ACCESS, FALSE, "AEshareMem");
	if (!hMemMapFile) {
		printf("Device not found\n");
		return 2;
	}
	memPtr = (LPSTR)MapViewOfFile(hMemMapFile, FILE_MAP_ALL_ACCESS, 0, 0, 0);
	if (!memPtr) {
		printf("MapViewOfFile falled\n");
		return 3;
	}
	/*     */
	memPtrUI = (unsigned int *)memPtr;
	memPtrUS = (unsigned short *)&memPtr[OUT_BUFFER];
	buffer_size = memPtrUI[BUFFER_SIZE];
	n_buffers = memPtrUI[N_BUFFERS];

	printf("Server priority: %s\n", prio2text(memPtrUI[SERVER_PRIOR]));
	printf("Device: %s, %s\n", &memPtr[DESCRIPTOR], &memPtr[S_N]);
	printf("%d buffers of %dK\n", n_buffers, buffer_size / 1024);

	/*    */
	memPtrUI[SERVER_CYCLE] = SERVER_CYCLE_READ;

	return 0;
}

static long get_data(unsigned short **data)
{
	long bytes, inp_ind;

	while (!memPtrUI[BUFFER_READY])
		Sleep(1);

	inp_ind = memPtrUI[BUFFER_IDX];
	bytes = memPtrUI[BYTE_COUNTS + inp_ind];
	*data = &memPtrUS[(buffer_size * inp_ind) / sizeof(short)];
	memPtrUI[BUFFER_READY] = 0;

	return bytes;
}

int main(int argc, char *argv[])
{
	long count = 0, bytes, samples, ms, new_ms, start_ms, time_ms;
	double tmp, rms[2];
	int i, itmp, chan, ret;
	unsigned short *data;

	i = 0;
	if (argc == 2)
		i = atoi(argv[1]);	/*     */
	if (!i)
		i = 5;			/*   5  */
	time_ms = i * 1000;

	/*    */
	ret = start_server();
	if (ret)
		return ret;	/*  */

	ms = get_milliseconds();
	start_ms = ms;
	rms[0] = 0.0;
	rms[1] = 0.0;
	for (;;) {
		/*       */
		bytes = get_data(&data);
		samples = bytes / (int)sizeof(short);
		count += samples / N_CHANNELS;	/*     */
		/*    -  RMS */
		for (i = 0; i < samples; i++) {
			chan = i & 1;
			itmp = data[i] + (chan ? ADC_OFFSET_A : ADC_OFFSET_B);
			tmp = (double)itmp / ADC_MAX_CODE;	/* ,  */
			rms[chan] += tmp * tmp;
		}
		new_ms = get_milliseconds();
		if (new_ms - ms < 1000)
			continue;
		/*    RMS  1000  */
		rms[0] = sqrt(rms[0] / count);
		rms[1] = sqrt(rms[1] / count);
		printf("RMS: ch.1 %8.6f, ch.2 %8.6f\n", rms[1], rms[0]);
		if (new_ms - start_ms >= time_ms)
			break;
		ms = new_ms;
		count = 0;
		rms[0] = 0.0;
		rms[1] = 0.0;
	}
	/*    */
	memPtrUI[SERVER_CYCLE] = 0;
	Delay(0.3);
	memPtrUI[SERVER_EXIT] = 1;
	Delay(0.3);
	UnmapViewOfFile(memPtr);
	CloseHandle(hMemMapFile);

	return 0;
}
