#include <ansi_c.h>
#include <windows.h>
#include <utility.h>

#include "buffer.h"

#define ADC_MAX_CODE		8192
/*    */
#define ADC_OFFSET_A		(-ADC_MAX_CODE - 39)
#define ADC_OFFSET_B		(-ADC_MAX_CODE + 32)

#define N_CHANNELS	2

/*   8    */
#define N_SAMPLES		(8 * 1024 * 1024)
#define BUF_SIZE_S		(N_SAMPLES * N_CHANNELS)
static unsigned short data_buf[BUF_SIZE_S];
/*     */
#define BUF_SIZE		(BUF_SIZE_S * (int)sizeof(short))

/* ,         */
static long inp_ind_old = 0;	/*     */
static long buffer_size;	/*      */
static long n_buffers;		/*   */

static HANDLE hMemMapFile;	/*     */

/*         */
static unsigned char  *memPtr;
static unsigned int   *memPtrUI;
static unsigned short *memPtrUS;

/*        */
static char *prio2text(int pri_class)
{
	char *prio = "unknown";

	switch(pri_class) {
	case 0x00008000:
		prio = "ABOVE_NORMAL_PRIORITY_CLASS";
		break;
	case 0x00004000:
		prio = "BELOW_NORMAL_PRIORITY_CLASS";
		break;
	case 0x00000080:
		prio = "HIGH_PRIORITY_CLASS";
		break;
	case 0x00000040:
		prio = "IDLE_PRIORITY_CLASS";
		break;
	case 0x00000020:
		prio = "NORMAL_PRIORITY_CLASS";
		break;
	case 0x00100000:
		prio = "PROCESS_MODE_BACKGROUND_BEGIN";
		break;
	case 0x00200000:
		prio = "PROCESS_MODE_BACKGROUND_END";
		break;
	case 0x00000100:
		prio = "REALTIME_PRIORITY_CLASS";
		break;
	default:
		break;
	}
	return prio;
}

static int start_server(void)
{
	unsigned long i, j, k, ulStreamSize;
	int g_exeHandle;
	DWORD dwPriClass;
	char *prio;

	SetPriorityClass(GetCurrentProcess(), REALTIME_PRIORITY_CLASS);
	dwPriClass = GetPriorityClass(GetCurrentProcess());

	printf("Client priority: %s\n", prio2text(dwPriClass));
	if (LaunchExecutableEx("ADC1402_server.exe", LE_HIDE, &g_exeHandle)) {
		printf("Cannot start ADC1402_server.exe\n");
		return 1;
	}
	Delay(1.0);

	hMemMapFile = OpenFileMapping(FILE_MAP_ALL_ACCESS, FALSE, "AEshareMem");
	if (!hMemMapFile) {
		printf("Device not found\n");
		return 2;
	}
	memPtr = (LPSTR)MapViewOfFile(hMemMapFile, FILE_MAP_ALL_ACCESS, 0, 0, 0);
	if (!memPtr) {
		printf("MapViewOfFile falled\n");
		return 3;
	}
	/*     */
	memPtrUI = (unsigned int *)memPtr;
	memPtrUS = (unsigned short *)&memPtr[OUT_BUFFER];
	buffer_size = memPtrUI[BUFFER_SIZE];
	n_buffers = memPtrUI[N_BUFFERS];

	printf("Server priority: %s\n", prio2text(memPtrUI[SERVER_PRIOR]));
	printf("Device: %s, s/n %s\n", &memPtr[DESCRIPTOR], &memPtr[S_N]);

	/*    */
	memPtrUI[SERVER_CYCLE] = SERVER_CYCLE_READ;

	return 0;
}

static void fill_buf(long *byte_count)
{
	unsigned short *dataUS;
	long inp_ind, bytes, cnt = *byte_count;

	if (!memPtrUI[BUFFER_READY]) {
		Sleep(1);
		return;
	}
	for (inp_ind = inp_ind_old; inp_ind != memPtrUI[BUFFER_IDX];) {
		/*     */
		dataUS = &memPtrUS[(buffer_size * inp_ind) / sizeof(short)];
		/*     */
		bytes = memPtrUI[BYTE_COUNTS + inp_ind];
		if (cnt + bytes > BUF_SIZE)
			bytes = BUF_SIZE - cnt;
		memcpy(&data_buf[cnt / sizeof(short)], dataUS, bytes);
		cnt += bytes;
		if (++inp_ind >= n_buffers)
			inp_ind = 0;
		if (cnt >= BUF_SIZE)
			break;	/*   */
	}
	*byte_count = cnt;
	inp_ind_old = inp_ind;
	memPtrUI[BUFFER_READY] = 0;
}

int main(int argc, char *argv[])
{
	long count = 0;
	double tmp, rms[2];
	int i, itmp, chan, ret;

	/*    */
	ret = start_server();
	if (ret)
		return ret;	/*  */

	/*   */
	while(count < BUF_SIZE) {
		fill_buf(&count);
	}
	/*  RMS */
	rms[0] = 0.0;
	rms[1] = 0.0;
	for (i = 0; i < BUF_SIZE_S; i++) {
		chan = i & 1;
		itmp = data_buf[i] + (chan ? ADC_OFFSET_A : ADC_OFFSET_B);
		tmp = (double)itmp / ADC_MAX_CODE;
		rms[chan] += tmp * tmp;
	}
	rms[0] = sqrt(rms[0] / N_SAMPLES);
	rms[1] = sqrt(rms[1] / N_SAMPLES);
	printf("RMS: ch.1 %8.6f, ch.2 %8.6f\n", rms[1], rms[0]);

	/*    */
	memPtrUI[SERVER_CYCLE] = 0;
	Delay(0.3);
	memPtrUI[SERVER_EXIT] = 1;
	Delay(0.3);
	UnmapViewOfFile(memPtr);
	CloseHandle(hMemMapFile);

	return 0;
}
