//******************************************************************************
//     USB3000
//     Rtusbapi.dll 
//******************************************************************************
#include <stdio.h>
#include <conio.h>
#include "LoadDll.h"				//   
#include "Rtusbapi.h"			//   USB3000

//    
void TerminateApplication(char *ErrorString, bool TerminationFlag = true);

//      DLL
TLoadDll *pLoadDll;

//    Rtusbapi.dll
DWORD DllVersion;
//    
IRTUSB3000 *pModule;
//  
char ModuleName[10];
//    USB
BYTE UsbSpeed;
//   
char ModuleSerialNumber[9];
//   AVR
char AvrVersion[5];
// ,      DSP
RTUSB3000::DSP_INFO di;
//     
RTUSB3000::FLASH fi;
//    
RTUSB3000::INPUT_PARS ip;

const WORD MaxVirtualSoltsQuantity = 127;
//    
const double ReadRate = 3000.0;

//------------------------------------------------------------------------
//  
//------------------------------------------------------------------------
void main(void)
{
	WORD i;

	//   	
	system("cls");

	printf(" *************************************************\n");
	printf(" Console example for Rtusbapi.dll dynamic loading \n");
	printf(" *************************************************\n");

	//    Rtusbapi.dll
	pLoadDll = new TLoadDll("Rtusbapi.dll");
	if(!pLoadDll) { printf(" Can't alloc 'TLoadDll' object!!!\n"); exit(1); }
	//      
	if(!pLoadDll->GetDllHinstance()) { printf(" Rtusbapi.dll Dynamic Loading --> Bad!!!\n"); exit(1); }
	else printf(" Rtusbapi.dll Dynamic Loading --> OK\n");

	//      Rtusbapi.dll
	pRtGetDllVersion RtGetDllVersion = (pRtGetDllVersion)pLoadDll->GetProcAddress("RtGetDllVersion");
	if(!RtGetDllVersion) TerminateApplication(" Address of RtGetDllVersion() --> Bad!!!\n"); 
	else printf(" Address of RtGetDllVersion() --> OK\n");

	//     Rtusbapi.dll
	if((DllVersion = RtGetDllVersion()) != CURRENT_VERSION_RTUSBAPI) 
	{	
		char String[128];
		sprintf(String, " Rtusbapi.dll Version Error!!!\n   Current: %1u.%1u. Required: %1u.%1u",
											DllVersion >> 0x10, DllVersion & 0xFFFF,
											CURRENT_VERSION_RTUSBAPI >> 0x10, CURRENT_VERSION_RTUSBAPI & 0xFFFF);
		
		TerminateApplication(String);
	}		
	else printf(" Rtusbapi.dll Version --> OK\n");

	//       USB3000
	pRtCreateInstance RtCreateInstance = (pRtCreateInstance)pLoadDll->GetProcAddress("RtCreateInstance");
	if(!RtCreateInstance) TerminateApplication(" Address of RtCreateInstance() --> Bad!!!\n"); 
	else printf(" Address of RtCreateInstance() --> OK\n");

	//       USB3000
	pModule = static_cast<IRTUSB3000 *>(RtCreateInstance("usb3000"));
	if(!pModule)  TerminateApplication(" Module Interface --> Bad\n"); 
	else printf(" Module Interface --> OK\n");

	//    USB3000   127  
	for(i = 0x0; i < MaxVirtualSoltsQuantity; i++) if(pModule->OpenDevice(i)) break;
	// - ?
	if(i == MaxVirtualSoltsQuantity) TerminateApplication(" Can't find module USB3000 in first 127 virtual slots!\n");
	else printf(" OpenDevice(%u) --> OK\n", i);

	//    
	if(!pModule->GetModuleName(ModuleName)) TerminateApplication(" GetModuleName() --> Bad\n");
	else printf(" GetModuleName() --> OK\n");
	// ,   'USB3000'
	if(strcmp(ModuleName, "USB3000")) TerminateApplication(" The module is not 'USB3000'\n");
	else printf(" The module is 'USB3000'\n");

	//      USB20
	if(!pModule->GetUsbSpeed(&UsbSpeed)) { printf(" GetUsbSpeed() --> Bad\n"); exit(1); }
	else printf(" GetUsbSpeed() --> OK\n");
	//     AVR
	printf(" USB Speed is %s\n", UsbSpeed ? "HIGH (480 Mbit/s)" : "FULL (12 Mbit/s)");

	//    
	if(!pModule->GetModuleSerialNumber(ModuleSerialNumber)) TerminateApplication(" GetModuleSerialNumber() --> Bad\n");
	else printf(" GetModuleSerialNumber() --> OK\n");
	//     
	printf(" Module Serial Number is %s\n", ModuleSerialNumber);

	//    AVR
	if(!pModule->GetAvrVersion(AvrVersion)) TerminateApplication(" GetAvrVersion() --> Bad\n");
	else printf(" GetAvrVersion() --> OK\n");
	//     AVR
	printf(" Avr Driver Version is %s\n", AvrVersion);

	//   DSP      DLL 
	if(!pModule->LOAD_DSP()) TerminateApplication(" LOAD_DSP() --> Bad\n");
	else printf(" LOAD_DSP() --> OK\n");

	//   
 	if(!pModule->MODULE_TEST()) TerminateApplication(" MODULE_TEST() --> Bad\n");
	else printf(" MODULE_TEST() --> OK\n");

	//     DSP
	if(!pModule->GET_DSP_INFO(&di)) TerminateApplication(" GET_DSP_INFO() --> Bad\n");
	else printf(" GET_DSP_INFO() --> OK\n");
	//      DSP
	printf(" DSP Driver version is %1u.%1u\n", di.DspMajor, di.DspMinor);

	//    size  RTUSB3000::FLASH
	fi.size = sizeof(RTUSB3000::FLASH);
	//     
	if(!pModule->GET_FLASH(&fi)) TerminateApplication(" GET_FLASH() --> Bad\n");
	else printf(" GET_FLASH() --> OK\n");

	//    size  RTUSB3000::INPUT_PARS
	ip.size = sizeof(RTUSB3000::INPUT_PARS);
	//     
	if(!pModule->GET_INPUT_PARS(&ip)) TerminateApplication(" GET_INPUT_PARS() --> Bad\n");
	else printf(" GET_INPUT_PARS() --> OK\n");

	//    
	ip.CorrectionEnabled = true;					//    
	ip.InputClockSource = RTUSB3000::INTERNAL_INPUT_CLOCK;	//        
//	ip.InputClockSource = RTUSB3000::EXTERNAL_INPUT_CLOCK;	//        
	ip.SynchroType = RTUSB3000::NO_SYNCHRO;	//          
//	ip.SynchroType = RTUSB3000::TTL_START_SYNCHRO;	//          
	ip.ChannelsQuantity = 0x4;						//   
	for(i = 0x0; i < ip.ChannelsQuantity; i++) ip.ControlTable[i] = (WORD)(i);
	ip.InputRate = ReadRate;						//     
	ip.InterKadrDelay = 0.0;						//   -     0.0
	ip.InputFifoBaseAddress = 0x0;  				//   FIFO  
	ip.InputFifoLength = 0x3000;	 				//  FIFO  
	//     ,     
	for(i = 0x0; i < 0x8; i++) { ip.AdcOffsetCoef[i] = fi.AdcOffsetCoef[i]; ip.AdcScaleCoef[i] = fi.AdcScaleCoef[i]; }
	//       
	if(!pModule->SET_INPUT_PARS(&ip)) TerminateApplication(" SET_INPUT_PARS() --> Bad\n");
	else printf(" SET_INPUT_PARS() --> OK\n");

	//        USB3000
	printf(" \n");
	printf(" Module USB3000 (S/N %s) is ready ... \n", ModuleSerialNumber);
	printf(" Adc parameters:\n");
	printf("   InputClockSource is %s\n", ip.InputClockSource ? "EXTERNAL" : "INTERNAL");
	printf("   SynchroType is %s\n", ip.SynchroType ? "TTL_START_SYNCHRO" : "NO_SYNCHRO");
	printf("   ChannelsQuantity = %2d\n", ip.ChannelsQuantity);
	printf("   AdcRate = %8.3f kHz\n", ip.InputRate);
	printf("   InterKadrDelay = %2.4f ms\n", ip.InterKadrDelay);
	printf("   ChannelRate = %8.3f kHz\n", ip.ChannelRate);

	//   
	TerminateApplication("\n The program was completed successfully!!!\n", false);
}

//------------------------------------------------------------------------
//   ,  ,    
//------------------------------------------------------------------------
void TerminateApplication(char *ErrorString, bool TerminationFlag)
{
	//   
	if(pModule) 
	{ 
		//   
		if(!pModule->ReleaseInstance()) printf("\n ReleaseInstance() --> Bad\n"); 
		else printf("\n ReleaseInstance() --> OK\n");
		//     
		pModule = NULL; 
	}
	//   
	if(pLoadDll) { delete pLoadDll; pLoadDll = NULL; }
	
	//   
	if(ErrorString) printf(ErrorString);

	//   -   
	if(TerminationFlag) exit(1);
	else return;
}
