VERSION 5.00
Begin VB.Form MainForm 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "    USB3000"
   ClientHeight    =   6876
   ClientLeft      =   3396
   ClientTop       =   3852
   ClientWidth     =   8880
   BeginProperty Font 
      Name            =   "Fixedsys"
      Size            =   10.8
      Charset         =   204
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6876
   ScaleWidth      =   8880
   StartUpPosition =   2  'CenterScreen
   Begin VB.Timer Timer 
      Enabled         =   0   'False
      Left            =   5592
      Top             =   6324
   End
   Begin VB.PictureBox Scope 
      BackColor       =   &H00000000&
      FillColor       =   &H00C0C0FF&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   7.8
         Charset         =   204
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H0000FF00&
      Height          =   3396
      Left            =   0
      ScaleHeight     =   3348
      ScaleWidth      =   8832
      TabIndex        =   3
      Top             =   -36
      Width           =   8880
   End
   Begin VB.CommandButton CommandStart 
      Caption         =   ""
      Height          =   612
      Left            =   792
      Style           =   1  'Graphical
      TabIndex        =   0
      Top             =   6084
      Width           =   2172
   End
   Begin VB.CommandButton CommandStop 
      Caption         =   ""
      Height          =   612
      Left            =   3432
      Style           =   1  'Graphical
      TabIndex        =   1
      Top             =   6084
      Width           =   2052
   End
   Begin VB.CommandButton CommandExit 
      Cancel          =   -1  'True
      Caption         =   ""
      Height          =   612
      Left            =   5952
      Style           =   1  'Graphical
      TabIndex        =   2
      Top             =   6084
      Width           =   1932
   End
   Begin VB.Frame WorkingParsFrame 
      Caption         =   " "
      Height          =   2208
      Left            =   4104
      TabIndex        =   4
      Top             =   3408
      Width           =   4776
      Begin VB.Label TotalPointsQuantityLabel 
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "-----"
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1049
            SubFormatType   =   1
         EndProperty
         Height          =   312
         Left            =   3288
         TabIndex        =   26
         Top             =   852
         Width           =   1332
      End
      Begin VB.Label Label9 
         Alignment       =   1  'Right Justify
         Caption         =   " - "
         Height          =   252
         Left            =   108
         TabIndex        =   25
         Top             =   900
         Width           =   3036
      End
      Begin VB.Label ChannelQuantityLabel 
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "-----"
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1049
            SubFormatType   =   1
         EndProperty
         Height          =   312
         Left            =   3288
         TabIndex        =   22
         Top             =   228
         Width           =   1332
      End
      Begin VB.Label Label12 
         Alignment       =   1  'Right Justify
         Caption         =   "-  "
         Height          =   252
         Left            =   120
         TabIndex        =   21
         Top             =   252
         Width           =   3036
      End
      Begin VB.Label Label4 
         Alignment       =   1  'Right Justify
         Caption         =   "-   "
         Height          =   252
         Left            =   96
         TabIndex        =   10
         Top             =   588
         Width           =   3036
      End
      Begin VB.Label Label3 
         Alignment       =   1  'Right Justify
         Caption         =   " ()"
         Enabled         =   0   'False
         Height          =   252
         Index           =   1
         Left            =   108
         TabIndex        =   9
         Top             =   1500
         Width           =   3036
      End
      Begin VB.Label Label2 
         Alignment       =   1  'Right Justify
         Caption         =   "   ()"
         Height          =   252
         Left            =   108
         TabIndex        =   8
         Top             =   1200
         Width           =   3036
      End
      Begin VB.Label InputRateLabel 
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "-----"
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0,000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1049
            SubFormatType   =   1
         EndProperty
         Height          =   288
         Left            =   3288
         TabIndex        =   7
         Top             =   1164
         Width           =   1332
      End
      Begin VB.Label InterKadrDelayLabel 
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "-----"
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0,000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1049
            SubFormatType   =   1
         EndProperty
         Enabled         =   0   'False
         Height          =   312
         Left            =   3288
         TabIndex        =   6
         Top             =   1452
         Width           =   1332
      End
      Begin VB.Label ChannelPointsLabel 
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "-----"
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1049
            SubFormatType   =   1
         EndProperty
         Height          =   312
         Left            =   3288
         TabIndex        =   5
         Top             =   540
         Width           =   1332
      End
   End
   Begin VB.Frame LoadingFrame 
      Caption         =   " "
      Height          =   2208
      Left            =   0
      TabIndex        =   11
      Top             =   3408
      Width           =   4104
      Begin VB.Label SlotNumberLabel 
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "-----"
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1049
            SubFormatType   =   1
         EndProperty
         Height          =   312
         Left            =   3132
         TabIndex        =   24
         Top             =   612
         Width           =   828
      End
      Begin VB.Label Label1 
         Caption         =   "  "
         Height          =   252
         Left            =   168
         TabIndex        =   23
         Top             =   636
         Width           =   2880
      End
      Begin VB.Label Label11 
         Caption         =   " "
         Height          =   252
         Left            =   144
         TabIndex        =   20
         Top             =   1884
         Width           =   2340
      End
      Begin VB.Label SerialNumberLabel 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "?????"
         BeginProperty DataFormat 
            Type            =   0
            Format          =   "0,000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1049
            SubFormatType   =   0
         EndProperty
         Height          =   312
         Left            =   2508
         TabIndex        =   19
         Top             =   1848
         Width           =   1452
      End
      Begin VB.Label UsbSpeedLabel 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "?????"
         BeginProperty DataFormat 
            Type            =   0
            Format          =   "0,000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1049
            SubFormatType   =   0
         EndProperty
         Height          =   312
         Left            =   1644
         TabIndex        =   18
         Top             =   924
         Width           =   2316
      End
      Begin VB.Label DspVersionLabel 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "?????"
         BeginProperty DataFormat 
            Type            =   0
            Format          =   "0,000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1049
            SubFormatType   =   0
         EndProperty
         Height          =   312
         Left            =   2508
         TabIndex        =   17
         Top             =   1548
         Width           =   1452
      End
      Begin VB.Label AvrVersionLabel 
         Alignment       =   2  'Center
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "?????"
         BeginProperty DataFormat 
            Type            =   0
            Format          =   "0,000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1049
            SubFormatType   =   0
         EndProperty
         Height          =   312
         Left            =   2508
         TabIndex        =   16
         Top             =   1236
         Width           =   1452
      End
      Begin VB.Label Label8 
         Alignment       =   1  'Right Justify
         Caption         =   " USB"
         Height          =   252
         Left            =   120
         TabIndex        =   15
         Top             =   960
         Width           =   1476
      End
      Begin VB.Label Label7 
         Caption         =   "  DSP"
         Height          =   252
         Left            =   144
         TabIndex        =   14
         Top             =   1584
         Width           =   2340
      End
      Begin VB.Label Label5 
         Caption         =   "  AVR"
         Height          =   252
         Left            =   144
         TabIndex        =   13
         Top             =   1272
         Width           =   2340
      End
      Begin VB.Shape StatusLedShape 
         BackStyle       =   1  'Opaque
         FillColor       =   &H8000000F&
         FillStyle       =   0  'Solid
         Height          =   324
         Left            =   444
         Shape           =   3  'Circle
         Top             =   264
         Width           =   348
      End
      Begin VB.Label Label6 
         Alignment       =   2  'Center
         Caption         =   "  "
         Height          =   252
         Left            =   828
         TabIndex        =   12
         Top             =   312
         Width           =   2772
      End
   End
End
Attribute VB_Name = "MainForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' 
Private Const VirtualSlot As Long = 0
Private Const ChannelQuantity As Long = 4
Private Const ChannelPoints As Integer = 4 * 1024
Private Const InputRate As Double = 1251.5
Private Const InterKadrDelay As Double = 0
Private Const MaxAdcCode As Integer = 8192
Private Const FileName = "usb3000.rtd"
Private Status As Long
Private LoadingError As Long
Private DllVersion As Long
Private pModule As Long
Private UsbSpeed As Byte
Private ModuleName As String * 10
Private ModuleSerialNumber As String * 10
Private AvrVersion As String * 5
Private Temp As Long
Private PointsToRead As Long
Private InputBuffer() As Integer
Private YAxis() As Integer
Private XAxis() As Integer
Private GraphColorArray(0 To (ChannelQuantity - 1)) As Long
Private DspInfo As DSP_INFO_USB3000
Private FlashInfo As FLASH_USB3000
Private InputPars As INPUT_PARS_USB3000
Private dx As Double, dy As Double
Private YCenter As Double
Private ReadEvent As Long
Private ReadOv As OVERLAPPED
Private NumberOfBytesRead As Long
Private TimeOut As Long
Private RetVal


'===============================================================
'   ''
'===============================================================
Private Sub CommandExit_Click()
   Unload Me
End Sub

'===============================================================
'   
'===============================================================
Private Sub CommandStart_Click()
   '    1000 
   Timer.Interval = 500
   '   
   Timer.Enabled = True
End Sub

'===============================================================
'   
'===============================================================
Private Sub CommandStop_Click()
   '   
   Timer.Enabled = False
End Sub

'===============================================================
'   
'===============================================================
Private Sub Form_Load()
   ' 
   Me.WindowState = 0
   
   '        
   If App.PrevInstance = True Then
      RetVal = MsgBox("    !", vbOKOnly, "!!!")
      Unload Me
      Exit Sub
   End If

   '     
   Call ModuleLoading
   '   ?
   If LoadingError = 1 Then
      Unload Me
      Exit Sub
   End If

   '  
   dx = Scope.Width / ChannelPoints
   dy = Scope.Height / (2# * MaxAdcCode)
   YCenter = Scope.Height / 2#

   '    
   SlotNumberLabel.Caption = Str(VirtualSlot)
   ChannelQuantityLabel.Caption = Str(InputPars.ChannelsQuantity)
   ChannelPointsLabel.Caption = Str(ChannelPoints)
   PointsToRead = ChannelPoints * InputPars.ChannelsQuantity
   TotalPointsQuantityLabel.Caption = Str(PointsToRead)
   Temp = InputPars.InputRate * 1000#
   InputRateLabel.Caption = Str(Temp / 1000#)
   Temp = InputPars.InterKadrDelay * 1000000#
   InterKadrDelayLabel.Caption = " 0" + LTrim(Str(Temp / 1000000#))

   '  
   ReadEvent = CreateEvent(ByVal 0&, False, False, ByVal 0&)
   If ReadEvent = 0 Then
      RetVal = MsgBox("   !", vbOKOnly, "!!!")
      Unload Me
      Exit Sub
   End If

   '     OVERLAPPED
   ReadOv.Internal = 0
   ReadOv.InternalHigh = 0
   ReadOv.offset = 0
   ReadOv.OffsetHigh = 0
   ReadOv.hEvent = ReadEvent
   '         
   TimeOut = ChannelPoints / InputPars.ChannelRate + 1000#

   '      
   ReDim InputBuffer(PointsToRead - 1)
   '     X 
   ReDim XAxis(ChannelPoints - 1)
   '     Y 
   ReDim YAxis(ChannelPoints - 1)

   '   
   GraphColorArray(0) = &HFF&
   GraphColorArray(1) = &HFF00&
   GraphColorArray(2) = &HFFFF&
   GraphColorArray(3) = &HFF8080

End Sub

'===============================================================
'      USB3000
'          
'===============================================================
Private Sub ModuleLoading()

   '  
   Dim i As Integer
   Dim ErrorString As String

   '     
   LoadingError = 0

   '    Rtusbapi.dll
   DllVersion = GetDllVersion_Rtusbapi()
   If DllVersion <> CURRENT_VERSION_RTUSBAPI Then
      LoadingError = 1
      ErrorString = "   Rtusbapi! " + _
         ": " + Str(DllVersion \ &H10000) + "." + Str(DllVersion And &HFFFF&) + _
         "; : " + Str(VERMAJOR_RTUSBAPI) + "." + Str(VERMINOR_RTUSBAPI)
      RetVal = MsgBox(ErrorString, vbOKOnly, "!!!")
      Exit Sub
   End If

   '    
   pModule = CreateInstance_Rtusbapi("usb3000")
   If pModule = 0 Then
      LoadingError = 1
      RetVal = MsgBox("     'USB3000'!", vbOKOnly, "!!!")
      Exit Sub
   End If

   '       
   Status = OpenDevice_Usb3000(pModule, VirtualSlot)
   If Status = 0 Then
      LoadingError = 1
      RetVal = MsgBox("    'USB3000'    !", vbOKOnly, "!!!")
      Exit Sub
   End If

   '      USB
   Status = GetUsbSpeed_Usb3000(pModule, UsbSpeed)
   If Status = 0 Then
      LoadingError = 1
      RetVal = MsgBox("    USB!", vbOKOnly, "!!!")
      Exit Sub
   End If

   '        USB
   If UsbSpeed = 0 Then
      UsbSpeedLabel.Caption = "FULL (12 /)"
   ElseIf UsbSpeed = 1 Then
      UsbSpeedLabel.Caption = "HIGH (480 /)"
   End If

   '   
   ModuleName = Space$(10)
   Status = GetModuleName_Usb3000(pModule, ModuleName)
   If Status = 0 Then
      LoadingError = 1
      RetVal = MsgBox("    !", vbOKOnly, "!!!")
      Exit Sub
   End If

   '    
   ModuleSerialNumber = Space$(10)
   Status = GetModuleSerialNumber_Usb3000(pModule, ModuleSerialNumber)
   If Status = 0 Then
      LoadingError = 1
      RetVal = MsgBox("     !", vbOKOnly, "!!!")
      Exit Sub
   Else: SerialNumberLabel.Caption = ModuleSerialNumber
   End If

   '    AVR
   AvrVersion = Space$(5)
   Status = GetAvrVersion_Usb3000(pModule, AvrVersion)
   If Status = 0 Then
      LoadingError = 1
      RetVal = MsgBox("     AVR !", vbOKOnly, "!!!")
      Exit Sub
   Else: AvrVersionLabel.Caption = AvrVersion
   End If

   '    DSP   
   Status = LOAD_DSP_Usb3000(pModule)
     '     DSP   "Usb3000.rtd"
     'Status = LOAD_DSP_Usb3000(pModule, FileName)
   If Status = 0 Then
      LoadingError = 1
      RetVal = MsgBox("    DSP!", vbOKOnly, "!!!")
      Exit Sub
   End If

   '    DSP  
   Status = MODULE_TEST_Usb3000(pModule)
   If Status = 0 Then
      LoadingError = 1
      RetVal = MsgBox(" USB3000  !", vbOKOnly, "!!!")
      Exit Sub
   End If

   '     DSP
   Status = GET_DSP_INFO_Usb3000(pModule, DspInfo)
   If Status = 0 Then
      LoadingError = 1
      RetVal = MsgBox("      DSP!", vbOKOnly, "!!!")
      Exit Sub
   Else: DspVersionLabel.Caption = Str(DspInfo.DspMajor) + "." + LTrim(Str(DspInfo.DspMinor))
   End If

   '   ,    
   '        
   StatusLedShape.FillColor = &HFF00&

   '    
   FlashInfo.Size = LenB(FlashInfo)
   Status = GET_FLASH_Usb3000(pModule, FlashInfo)
   If Status = 0 Then
      LoadingError = 1
      RetVal = MsgBox("    GET_FLASH_Usb3000()!", vbOKOnly, "!!!")
      Exit Sub
   End If

   '     
   InputPars.Size = LenB(InputPars)
   Status = GET_INPUT_PARS_Usb3000(pModule, InputPars)
   If Status = 0 Then
      LoadingError = 1
      RetVal = MsgBox("    GET_INPUT_PARS_Usb3000()!", vbOKOnly, "!!!")
      Exit Sub
   End If

   '--------      ---------
   InputPars.CorrectionEnabled = &H1      '   
   InputPars.InputClockSource = INTERNAL_INPUT_CLOCK_USB3000 '        
   InputPars.ChannelsQuantity = 4         ' -  
   For i = 1 To InputPars.ChannelsQuantity
      InputPars.ControlTable(i) = i - 1
   Next i
   InputPars.InputRate = InputRate        '    
   InputPars.InterKadrDelay = 0
   InputPars.InputFifoBaseAddress = &H0   '  FIFO  
   InputPars.InputFifoLength = &H3000     ' FIFO  
   '     ,     
   For i = 1 To 8
      InputPars.AdcOffsetCoef(i) = FlashInfo.AdcOffsetCoef(i)
      InputPars.AdcScaleCoef(i) = FlashInfo.AdcScaleCoef(i)
   Next i
   '-------------------------------------------------------------

   '     
   Status = SET_INPUT_PARS_Usb3000(pModule, InputPars)
   If Status = 0 Then
      LoadingError = 1
      RetVal = MsgBox("    SET_INPUT_PARS_Usb3000()!", vbOKOnly, "!!!")
      Exit Sub
   End If

   '      
   '   bulk USB
   Status = STOP_READ_Usb3000(pModule)
   If Status = 0 Then
      LoadingError = 1
      RetVal = MsgBox("    STOP_READ_Usb3000()!", vbOKOnly, "!!!")
      Exit Sub
   End If

End Sub

'===============================================================
'   (  )
'===============================================================
Private Sub Form_Unload(Cancel As Integer)
   '     
   If ReadEvent <> 0 Then
      '    
      Status = CloseHandle(ReadEvent)
      If Status = 0 Then
         RetVal = MsgBox("   !", vbOKOnly, "!!!")
      End If
   End If


   '      
   If pModule = 0 Then Exit Sub
   '     
   Status = ReleaseInstance_Usb3000(pModule)
   If Status = 0 Then
      RetVal = MsgBox("     !", vbOKOnly, "!!!")
   End If

End Sub

'===============================================================
'
'===============================================================
Private Sub Timer_Timer()

   '  
   Dim i As Integer, j As Integer

   '        
   Status = ReadData_Usb3000(pModule, InputBuffer(0), _
                             PointsToRead, _
                             NumberOfBytesRead, _
                             ReadOv)
   '    
   If Status = 0 Then
      '   -   ,   
      ' .  WinApi  ReadFile()
      If Err.LastDllError <> ERROR_IO_PENDING Then
         '   
         Timer.Enabled = False
         '   
         RetVal = MsgBox("    ReadData_Usb3000()!", vbOKOnly, "!!!")
         Exit Sub
      End If
   End If

   '   
   Status = START_READ_Usb3000(pModule)
   If Status = 0 Then
      '   
      Timer.Enabled = False
      '   
      RetVal = MsgBox("    START_READ_Usb3000()!", vbOKOnly, "!!!")
      Exit Sub
   End If

   '    
   Status = WaitForSingleObject(ReadEvent, TimeOut)
   If Status = WAIT_TIMEOUT Then
      '   
      Timer.Enabled = False
      '   
      RetVal = MsgBox("    !", vbOKOnly, "!!!")
      Exit Sub
   End If

   '      
   '   bulk USB
   Status = STOP_READ_Usb3000(pModule)
   If Status = 0 Then
      '   
      Timer.Enabled = False
      '   
      RetVal = MsgBox("    STOP_READ_Usb3000()!", vbOKOnly, "!!!")
      Exit Sub
   End If

   '  
   Scope.Cls

   '     
   For i = 0 To InputPars.ChannelsQuantity - 1
      '    
      For j = 0 To ChannelPoints - 1
         XAxis(j) = j * dx
         YAxis(j) = InputBuffer(i + j * InputPars.ChannelsQuantity) * dy + YCenter
      Next
      '    
      Scope.ForeColor = GraphColorArray(i)
      '   
      For j = 0 To ChannelPoints - 2
         Scope.Line (XAxis(j), YAxis(j))-(XAxis(j + 1), YAxis(j + 1))
      Next
   Next

End Sub
