//******************************************************************************
//           USB3000
//  - wrRtusbapi.dll
//******************************************************************************
#include <ansi_c.h>
#include "wrRtusbapi.h"
#include <utility.h>

//   
void TerminateApplication(char *ErrorString, BOOL TerminationFlag);
//  
void ShowThreadErrorMessage(void);
// 
WORD Round(double Data);

//        
DWORD WINAPI ServiceWriteThread(PVOID /*Context*/);
//   
HANDLE hWriteThread;
DWORD WriteTid;

//    Rtusbapi.dll
DWORD DllVersion;
//    
LPVOID pModule;
//   
HANDLE hModule;
//  
char ModuleName[10];
//    USB
BYTE UsbSpeed;
//   
char ModuleSerialNumber[9];
//   AVR
char AvrVersion[5];
//     
FLASH_USB3000 fi;
// ,      DSP
DSP_INFO_USB3000 di;
// ,    
OUTPUT_PARS_USB3000 dp;
//   
const WORD DacNumber = 0x0;

// -    . WriteData()
DWORD DataStep = 64*1024;
//     
DWORD WritePoints;
//      
SHORT	*WriteBuffer;
//    
SHORT DacSample;

//  
const double Pi = 3.14159265358979323846;
//      
const double DacRate = 100.0;
//   -  
const WORD MaxVirtualSoltsQuantity = 127;

//   
double CurrentTime = 0.0; 			  				//  
const double SignalFrequency = 1.0; 	  		//  
const double SignalAmplitude = 2000.0;			//   

//  -
DWORD Counter = 0x0, OldCounter = 0xFFFFFFFF;

//       
WORD ThreadErrorNumber;
//     
BOOL IsThreadComplete = FALSE;

//------------------------------------------------------------------------
//  
//------------------------------------------------------------------------
void main(void)
{
	char String[128];
	WORD i;

	//        
	WriteBuffer = NULL;
	//     - 
	hWriteThread = NULL;
	//      
	ThreadErrorNumber = 0x0;

	//   	
	Cls();

	printf(" *******************************************\n");
	printf(" Console example of Data Writing to USB3000 \n");
	printf(" *******************************************\n\n");

	//     Rtusbapi.dll
	if((DllVersion = GetDllVersion_Rtusbapi()) != CURRENT_VERSION_RTUSBAPI) 
	{	
		sprintf(String, " Rtusbapi.dll Version Error!!!\n   Current: %1u.%1u. Required: %1u.%1u",
											DllVersion >> 0x10, DllVersion & 0xFFFF,
											CURRENT_VERSION_RTUSBAPI >> 0x10, CURRENT_VERSION_RTUSBAPI & 0xFFFF);
		
		TerminateApplication(String, TRUE);
	}		
	else printf(" Dll Version --> OK\n");

	//      USB3000
	pModule = (LPVOID *)CreateInstance_Rtusbapi("usb3000");
	if(!pModule) TerminateApplication(" Module Interface --> Bad\n", TRUE);
	else printf(" Module Interface --> OK\n");

	//    USB3000   127  
	for(i = 0x0; i < MaxVirtualSoltsQuantity; i++) if(OpenDevice_Usb3000(pModule, i)) break;
	// - ?
	if(i == MaxVirtualSoltsQuantity) TerminateApplication(" Can't find module USB3000 in first 127 virtual slots!\n", TRUE);
	else printf(" OpenDevice_Usb3000(%u) --> OK\n", i);

	//    (handle) 
	hModule = GetModuleHandle_Usb3000(pModule);
	if(hModule == INVALID_HANDLE_VALUE) TerminateApplication(" GetModuleHandle_Usb3000() --> Bad\n", TRUE);
	else printf(" GetModuleHandle_Usb3000() --> OK\n");

	//       
	if(!GetModuleName_Usb3000(pModule, ModuleName)) TerminateApplication(" GetModuleName_Usb3000() --> Bad\n", TRUE);
	else printf(" GetModuleName_Usb3000() --> OK\n");
	// ,   'USB3000'
	if(strcmp(ModuleName, "USB3000")) TerminateApplication(" The module is not 'USB3000'\n", TRUE);
	else printf(" The module is 'USB3000'\n");

	//      USB20
	if(!GetUsbSpeed_Usb3000(pModule, &UsbSpeed)) TerminateApplication(" GetUsbSpeed_Usb3000() --> Bad\n", TRUE);
	else printf(" GetUsbSpeed_Usb3000() --> OK\n");
	//     AVR
	printf(" USB Speed is %s\n", UsbSpeed ? "HIGH (480 Mbit/s)" : "FULL (12 Mbit/s)");

	//    
	if(!GetModuleSerialNumber_Usb3000(pModule, ModuleSerialNumber)) TerminateApplication(" GetModuleSerialNumber_Usb3000() --> Bad\n", TRUE);
	else printf(" GetModuleSerialNumber_Usb3000() --> OK\n");
	//     
	printf(" Module Serial Number is %s\n", ModuleSerialNumber);

	//    AVR
	if(!GetAvrVersion_Usb3000(pModule, AvrVersion)) TerminateApplication(" GetAvrVersion_Usb3000() --> Bad\n", TRUE);
	else printf(" GetAvrVersion_Usb3000() --> OK\n");
	//     AVR
	printf(" Avr Driver Version is %s\n", AvrVersion);

	//   DSP      DLL 
	if(!LOAD_DSP_Usb3000(pModule, NULL)) TerminateApplication(" LOAD_DSP_Usb3000() --> Bad\n", TRUE);
	else printf(" LOAD_DSP_Usb3000() --> OK\n");

	//   
 	if(!MODULE_TEST_Usb3000(pModule)) TerminateApplication(" MODULE_TEST_Usb3000() --> Bad\n", TRUE);
	else printf(" MODULE_TEST_Usb3000() --> OK\n");

	//     DSP
	if(!GET_DSP_INFO_Usb3000(pModule, &di)) TerminateApplication(" GET_DSP_INFO_Usb3000() --> Bad\n", TRUE);
	else printf(" GET_DSP_INFO_Usb3000() --> OK\n");
	//      DSP
	printf(" DSP Driver version is %1u.%1u\n", di.DspMajor, di.DspMinor);

	//    size  RTUSB3000::FLASH
	fi.size = sizeof(FLASH_USB3000);
	//     
	if(!GET_FLASH_Usb3000(pModule, &fi)) TerminateApplication(" GET_FLASH_Usb3000() --> Bad\n", TRUE);
	else printf(" GET_FLASH_Usb3000() --> OK\n");

	//       
	DacSample = 0x0;
	//     
	DacSample = Round((DacSample + fi.DacOffsetCoef[0])*fi.DacScaleCoef[0]);
	if(!WRITE_SAMPLE_Usb3000(pModule, 0x0, &DacSample)) TerminateApplication(" WRITE_SAMPLE_Usb3000(0) --> Bad\n", TRUE);
	else printf(" WRITE_SAMPLE_Usb3000(0) --> OK\n");

	//        
	DacSample = 0x0;
	//     
	DacSample = Round((DacSample + fi.DacOffsetCoef[1])*fi.DacScaleCoef[1]);
	if(!WRITE_SAMPLE_Usb3000(pModule, 0x1, &DacSample)) TerminateApplication(" WRITE_SAMPLE_Usb3000(1) --> Bad\n", TRUE);
	else printf(" WRITE_SAMPLE_Usb3000(1) --> OK\n");

	//     
	dp.size = sizeof(OUTPUT_PARS_USB3000);
	if(!GET_OUTPUT_PARS_Usb3000(pModule, &dp)) TerminateApplication(" GET_OUTPUT_PARS_Usb3000() --> Bad\n", TRUE);
	else printf(" GET_OUTPUT_PARS_Usb3000() --> OK\n");

	//        USB3000
	dp.OutputRate = DacRate;		  			//     
	dp.OutputFifoBaseAddress = 0x3000;   	//   FIFO  
	dp.OutputFifoLength = 0xF80;				//  FIFO  

	//     
	if(!SET_OUTPUT_PARS_Usb3000(pModule, &dp)) TerminateApplication(" SET_OUTPUT_PARS_Usb3000() --> Bad\n", TRUE);
	else printf(" SET_OUTPUT_PARS_Usb3000() --> OK\n");

	//           
	printf(" \n");
	printf(" Module USB3000 (S/N %s) is ready ... \n", ModuleSerialNumber);
	printf("  Ouput parameters:\n");
	printf("    OutputRate = %6.1f kHz\n", dp.OutputRate);
	printf("  Signal parameters:\n");
	printf("    SignalFrequency  = %2.2f kHz\n", SignalFrequency);
	printf("    SignalAmplitude  = %1.3f V\n", SignalAmplitude*5.0/2000.0);

	//       
	ThreadErrorNumber = 0x0;

	// -      
	WritePoints = 2*DataStep;
	//          
	WriteBuffer = malloc(WritePoints * sizeof(SHORT));
	if(!WriteBuffer) TerminateApplication(" Cannot allocate memory for data buffer \n", TRUE);

	//          
	hWriteThread = CreateThread(0, 0x2000, ServiceWriteThread, 0x0, 0x0, &WriteTid);
	if(!hWriteThread) TerminateApplication("Cann't start output data thread!", TRUE);

	//     
	printf("\n   Now SINUS signal is on the %s DAC channel\n", DacNumber ? "second" : "first");
	printf(" (you can press any key to terminate the program)\n");
	while(!IsThreadComplete)
	{
		if(OldCounter != Counter) { printf(" Counter %3u\r", Counter); OldCounter = Counter; }
		else Sleep(20);
	}

	//      
	WaitForSingleObject(hWriteThread, INFINITE);
	//   
	printf("\n\n");
	
	//    -   
	if(ThreadErrorNumber) { TerminateApplication(NULL, FALSE); ShowThreadErrorMessage(); }
	else { printf("\n"); TerminateApplication("\n The program was completed successfully!!!\n", FALSE); }
}

//------------------------------------------------------------------------
//          
//------------------------------------------------------------------------
#pragma argsused
DWORD WINAPI ServiceWriteThread(PVOID Context)
{
	WORD RequestNumber;
	DWORD i;
	DWORD BaseIndex;
	//     
	HANDLE WriteEvent[2];
	//  OVERLAPPED    
	OVERLAPPED WriteOv[2];
	DWORD BytesTransferred[2];
	DWORD TimeOut;

	//     FIFO    DSP  ( )
	for(i = 0x0; i < (DWORD)dp.OutputFifoLength; i++)
	{
   	WriteBuffer[i] = Round((2047.0 + SignalAmplitude*sin(2.0*Pi*SignalFrequency*CurrentTime) + fi.DacOffsetCoef[DacNumber])*fi.DacScaleCoef[DacNumber]);
		WriteBuffer[i] &= (WORD)(0xFFF);
		WriteBuffer[i] |= (WORD)(DacNumber << 15) | (WORD)(0x1 << 14);
		CurrentTime += 1.0/dp.OutputRate;
	}
	//   FIFO    DSP 
	if(!PUT_DM_ARRAY_Usb3000(pModule, dp.OutputFifoBaseAddress, dp.OutputFifoLength, (SHORT *)WriteBuffer))
   										{ ThreadErrorNumber = 0x1; IsThreadComplete = TRUE; return 1; }

	//        WriteBuffer ( )
	for(i = 0x0; i < 2*DataStep; i++)
	{
		WriteBuffer[i] = Round((2047.0 + SignalAmplitude*sin(2.0*Pi*SignalFrequency*CurrentTime) + fi.DacOffsetCoef[DacNumber])*fi.DacScaleCoef[DacNumber]);
		WriteBuffer[i] &= (WORD)(0xFFF);
		WriteBuffer[i] |= (WORD)(DacNumber << 15) | (WORD)(0x1 << 14);
		CurrentTime += 1.0/dp.OutputRate;
	}

	//         bulk USB (PIPE_RESET)
	if(!STOP_WRITE_Usb3000(pModule)) { ThreadErrorNumber = 0x6; IsThreadComplete = TRUE; return 0; }

	//   
	WriteEvent[0] = CreateEvent(NULL, FALSE , FALSE, NULL);
	memset(&WriteOv[0], 0, sizeof(OVERLAPPED)); WriteOv[0].hEvent = WriteEvent[0];
	WriteEvent[1] = CreateEvent(NULL, FALSE , FALSE, NULL);
	memset(&WriteOv[1], 0, sizeof(OVERLAPPED)); WriteOv[1].hEvent = WriteEvent[1];

	//   
	TimeOut = DataStep/dp.OutputRate + 1000;

	//      
	RequestNumber = 0;
	if(!WriteData_Usb3000(pModule, WriteBuffer, &DataStep, &BytesTransferred[RequestNumber], &WriteOv[RequestNumber]))
				if(GetLastError() != ERROR_IO_PENDING) { CloseHandle(WriteEvent[0]); CloseHandle(WriteEvent[1]); ThreadErrorNumber = 0x2; IsThreadComplete = TRUE; return 0; }

	//      
	if(START_WRITE_Usb3000(pModule))
	{
		//    
		for(;;)
		{
			RequestNumber ^= 0x1;
			//         DSP 
			if(!WriteData_Usb3000(pModule, WriteBuffer + RequestNumber*DataStep, &DataStep, &BytesTransferred[RequestNumber], &WriteOv[RequestNumber]))
					if(GetLastError() != ERROR_IO_PENDING) { ThreadErrorNumber = 0x2; break; }

			//       
			if(WaitForSingleObject(WriteEvent[RequestNumber^0x1], TimeOut) == WAIT_TIMEOUT)
				            		{ ThreadErrorNumber = 0x3; break; }

			//      ( )
			BaseIndex = (RequestNumber^0x1)*DataStep;
			for(i = 0x0; i < DataStep; i++)
			{
				WriteBuffer[i + BaseIndex] = Round((2047.0 + SignalAmplitude*sin(2.0*Pi*SignalFrequency*CurrentTime) + fi.DacOffsetCoef[DacNumber])*fi.DacScaleCoef[DacNumber]);
				WriteBuffer[i + BaseIndex] &= (WORD)(0xFFF);
				WriteBuffer[i + BaseIndex] |= (WORD)(DacNumber << 15) | (WORD)(0x1 << 14);
				CurrentTime += 1.0/dp.OutputRate;
	  		}

			if(ThreadErrorNumber) break;
			else if(KeyHit()) { GetKey(); ThreadErrorNumber = 0x1; break; }
			else Sleep(20);
			Counter++;
		}
	}
	else { ThreadErrorNumber = 0x5; }

	//   
	if(!STOP_WRITE_Usb3000(pModule)) ThreadErrorNumber = 0x6;
	//   
	if(!CancelIo(hModule)) ThreadErrorNumber = 0x7;
	//    
	for(i = 0x0; i < 0x2; i++) CloseHandle(WriteEvent[i]);
	//  
	Sleep(100);
	//      
	IsThreadComplete = TRUE;
	//        
	return 0;
}

//---------------------------------------------------------------------------
//
//---------------------------------------------------------------------------
WORD Round(double Data)
{
	if(Data > 0.0) Data += 0.5;
	else if(Data < 0.0) Data = -0.5;
	return (WORD)Data;
}


//------------------------------------------------------------------------
//    
//------------------------------------------------------------------------
void ShowThreadErrorMessage(void)
{
	switch(ThreadErrorNumber)
	{
		case 0x0:
			break;

		case 0x1:
			//     ,   
			printf("\n WRITE Thread: The program was terminated! :(((\n");
			break;

		case 0x2:
			printf("\n WRITE Thread: WriteData_Usb3000() --> Bad :(((\n");
			break;

		case 0x3:
			printf("\n WRITE Thread: Timeout is occured :(((\n");
			break;

		case 0x4:
			printf("\n WRITE Thread: Buffer Data Error! :(((\n");
			break;

		case 0x5:
			printf("\n WRITE Thread: START_WRITE_Usb3000() --> Bad :(((\n");
			break;

		case 0x6:
			printf("\n WRITE Thread: STOP_WRITE_Usb3000() --> Bad! :(((\n");
			break;

		case 0x7:
			printf("\n READ Thread: Can't complete input and output (I/O) operations! :(((");
			break;

		default:
			printf("\n WRITE Thread: Unknown error! :(((\n");
			break;
	}

	return;
}

//------------------------------------------------------------------------
//   ,  ,    
//------------------------------------------------------------------------
void TerminateApplication(char *ErrorString, BOOL TerminationFlag)
{
	//   
	if(pModule)
	{ 
		//   
		if(!ReleaseInstance_Usb3000(pModule)) printf(" ReleaseInstance_Usb3000() --> Bad\n", TRUE);
		else printf(" ReleaseInstance_Usb3000() --> OK\n");
		//     
		pModule = NULL;
	}

	//    
	if(WriteBuffer) {	free(WriteBuffer); WriteBuffer = NULL; }
	//     
	if(hWriteThread) { CloseHandle(hWriteThread); hWriteThread = NULL; }

	//   
	if(ErrorString) printf(ErrorString);

	//   -   
	if(TerminationFlag) exit(1);
	else return;
}

