program WriteData;

{$APPTYPE CONSOLE}

uses
  SysUtils, Windows, Rtusbapi;

const
	// -    ( 256)  . WriteData
	DataStep : DWORD = 64*1024;
	//      : 0  1
	DacNumber : WORD = $0;
	//   
	WriteRate : double  = 100.0;

var
	//   
	hWriteThread : THANDLE;
	WriteTid : DWORD;

	//   USB3000
	pModule : IRTUSB3000;
	//   Rtusbapi.dll
	DllVersion : DWORD;
	//  
	ModuleHandle : THandle;
	// ,      DSP
	DspInfo : DSP_INFO_USB3000;
	//     
	fi : FLASH_USB3000;
	//    
	op : OUTPUT_PARS_USB3000;
	//  
	ModuleName: String;
	//   AVR
	AvrVersion : array [0..4] of CHAR;
	//   
	ModuleSerialNumber : array [0..8] of CHAR;
	//  -
	Counter, OldCounter : DWORD;
	//    
	DacSample : SHORT;
	//     
	Buffer : array of SHORT;

	//       
	ThreadErrorNumber : WORD;
	//     
	IsThreadComplete : boolean;

	//    
	CurrentTime : double;		  			//  
	SignalFrequency : double; 	  			//  
	SignalAmplitude : double;				//   

	//  
	i : WORD;
	hConIn : THandle;
	Str : string;

//------------------------------------------------------------------------------
//            ESCAPE
//------------------------------------------------------------------------------
function Terminated : boolean;
var
	Buffer: INPUT_RECORD;
	Count: DWORD;

begin
	Result := false;
	GetNumberOfConsoleInputEvents(hConIn, Count);
	if Count > 0 then
		begin
			ReadConsoleInput(hConIn, Buffer, 1, Count);
			case Buffer.EventType of
				KEY_EVENT:
					case Buffer.Event.KeyEvent.wVirtualKeyCode of
	            VK_ESCAPE: Result := true;
            //  
          end;
       //   
      end;
    end;
end;

//------------------------------------------------------------------------------
//        
//------------------------------------------------------------------------------
function WaitingForRequestCompleted(var WriteOv : OVERLAPPED) : boolean;
var 	BytesTransferred : DWORD;
begin
	Result := true;
	while true do
	   begin
			if GetOverlappedResult(ModuleHandle, WriteOv, BytesTransferred, FALSE) then break
			else if (GetLastError() <>  ERROR_IO_INCOMPLETE) then
				begin
					//      
					ThreadErrorNumber := 3; Result := false; break;
				end
			else if Terminated() then
				begin
					//   (  ESC)
					ThreadErrorNumber := 4; Result := false; break;
				end
			else Sleep(20);
		end;
end;

//------------------------------------------------------------------------------
//       
// FIFO     DSP
//------------------------------------------------------------------------------
function FillOutputBufer : boolean;
var i : WORD;
begin
	Result := true;
	//     FIFO  
	for i := 0 to (op.OutputFifoLength-1) do
		begin
			Buffer[i] := Round(2047.0 + SignalAmplitude*sin(2.0*pi*SignalFrequency*CurrentTime) + fi.DacOffsetCoef[DacNumber]);
			Buffer[i] := Round(Buffer[i] * fi.DacScaleCoef[DacNumber]);
			Buffer[i] := Buffer[i] and WORD($0FFF);
			Buffer[i] := Buffer[i] or (DacNumber shl 15) or ($1 shl 14);
			CurrentTime := CurrentTime + 1.0/op.OutputRate;
		end;
	//   FIFO    DSP 
	if not pModule.PUT_DM_ARRAY(op.OutputFifoBaseAddress, op.OutputFifoLength, @Buffer[0]) then
									begin ThreadErrorNumber := 7; Result := false; end;
end;

//------------------------------------------------------------------------------
//      
//------------------------------------------------------------------------------
procedure MakeOutputData(RequestNumber : WORD);
var
i : WORD;
BaseIndex : DWORD;
begin
	//    
	BaseIndex := RequestNumber*DataStep;
	for i := 0 to (DataStep-1) do
		begin
			Buffer[i + BaseIndex] := Round(2047.0 + SignalAmplitude*sin(2.*pi*SignalFrequency*CurrentTime) + fi.DacOffsetCoef[DacNumber]);
			Buffer[i + BaseIndex] := Round(Buffer[i + BaseIndex] * fi.DacScaleCoef[DacNumber]);
			Buffer[i + BaseIndex] := Buffer[i + BaseIndex] and WORD($0FFF);
			Buffer[i + BaseIndex] := Buffer[i + BaseIndex] or (DacNumber shl 15) or ($1 shl 14);
			CurrentTime := CurrentTime + 1.0/op.OutputRate;
		end;
end;

//------------------------------------------------------------------------------
//           
//               USB3000
//------------------------------------------------------------------------------
function WriteThread(var param : pointer): DWORD;
var
	RequestNumber : WORD;
	//     
	WriteEvent : array[0..1] of THANDLE;
	//  OVERLAPPED    
	WriteOv : array[0..1] of OVERLAPPED;
	BytesTransferred : array[0..1] of DWORD;

begin
	Result := 0;
	//         bulk USB
	if not pModule.STOP_WRITE() then	begin	ThreadErrorNumber := 1; IsThreadComplete := true; exit; end;

	//  FIFO    
	if not FillOutputBufer() then begin	IsThreadComplete := true; exit; end;

	//   
	WriteEvent[0] := CreateEvent(nil, FALSE , FALSE, nil);
	FillMemory(@WriteOv[0], sizeof(OVERLAPPED), 0);
	WriteOv[0].hEvent := WriteEvent[0];
	WriteEvent[1] := CreateEvent(nil, FALSE , FALSE, nil);
	FillMemory(@WriteOv[1], sizeof(OVERLAPPED), 0);
	WriteOv[1].hEvent := WriteEvent[1];

	RequestNumber := 0;
	//        
	MakeOutputData(RequestNumber);
	//         
	MakeOutputData(RequestNumber xor $1);

	//        Buffer
	if not pModule.WriteData(@Buffer[RequestNumber*DataStep], @DataStep, @BytesTransferred[RequestNumber], @WriteOv[RequestNumber]) then
		begin
			if (GetLastError() <> ERROR_IO_PENDING) then
				begin
					CloseHandle(WriteEvent[0]); CloseHandle(WriteEvent[1]); ThreadErrorNumber := 2; IsThreadComplete := true; exit;
				end
		end;

	//      
	if pModule.START_WRITE() then
   	begin
			//    
			while true do
				begin
					RequestNumber := RequestNumber xor $1;
					//       
					if not pModule.WriteData(@Buffer[RequestNumber*DataStep], @DataStep, @BytesTransferred[RequestNumber], @WriteOv[RequestNumber]) then
						begin
							if (GetLastError() <> ERROR_IO_PENDING) then
								begin
									ThreadErrorNumber := 2; break;
								end
						end;

					//        
					if not WaitingForRequestCompleted(WriteOv[RequestNumber xor $1]) then break;

					//      
					MakeOutputData(RequestNumber xor $1);

					//        
					if ThreadErrorNumber <> 0 then break
					else if Terminated() then
						begin
							//   (  ESC)
							ThreadErrorNumber := 4; break;
						end
					else Sleep(20);

					//  
					Inc(Counter);
				end
		end
	else ThreadErrorNumber := 5;

	//   
	if not pModule.STOP_WRITE() then ThreadErrorNumber := 1;

	//  ,     
	if not CancelIo(ModuleHandle) then ThreadErrorNumber := 6;

	//   
	CloseHandle(WriteEvent[0]); CloseHandle(WriteEvent[1]);

	//      
	IsThreadComplete := true;

end;

//------------------------------------------------------------------------------
//   
//------------------------------------------------------------------------------
procedure TerminateApplication(ErrorString: string);
begin
	//   
	MessageBox(HWND(nil), pCHAR(ErrorString), '!!!', MB_OK + MB_ICONINFORMATION);
	//     
	if hWriteThread = THANDLE(nil) then CloseHandle(hWriteThread);
	//   
	if pModule <> nil then pModule.ReleaseInstance();
	//    
	if Buffer <> nil then Buffer := nil;
	halt;
end;

//------------------------------------------------------------------------------
//         
//------------------------------------------------------------------------------
procedure ShowThreadErrorMessage;
begin
	case ThreadErrorNumber of
		$0 : ;
		$1 : WriteLn(' WRITE Thread: STOP_WRITE() --> Bad! :(((');
		$2 : WriteLn(' WRITE Thread: ReadData() --> Bad :(((');
		$3 : WriteLn(' WRITE Thread: Waiting data Error! :(((');
		//     ,   
		$4 : WriteLn(' WRITE Thread: The program was terminated! :(((');
		$5 : WriteLn(' WRITE Thread: START_WRITE() --> Bad :(((');
		$6 : WriteLn(' WRITE Thread: Can''t complete input and output (I/O) operations! :(((');
		$7 : WriteLn(' WRITE Thread: Can''t fill FIFO output buffer in DSP driver! :(((');
		else WriteLn(' WRITE Thread: Unknown error! :(((');
	end;
end;

//******************************************************************************
//      						main program
//******************************************************************************
begin
	//      - 
	hConIn := GetStdHandle(STD_INPUT_HANDLE);

	//    DLL 
	DllVersion := RtGetDllVersion;
	if DllVersion <> CURRENT_VERSION_RTUSBAPI then
		begin
			Str := '  DLL  Rtusbapi.dll! ' + #10#13 +
					 '           : ' + IntToStr(DllVersion shr 16) +  '.' + IntToStr(DllVersion and $FFFF) + '.' +
					 ' : ' + IntToStr(CURRENT_VERSION_RTUSBAPI shr 16) + '.' + IntToStr(CURRENT_VERSION_RTUSBAPI and $FFFF) + '.';
			TerminateApplication(Str);
		end
	else WriteLn(' DLL Version --> OK');

	//        USB3000
	pModule := RtCreateInstance(pCHAR('usb3000'));
	if pModule = nil then TerminateApplication('     USB3000!')
	else WriteLn(' Module Interface --> OK');

	//    USB3000   127  
	for i := 0 to 126 do
		if pModule.OpenDevice(i) then break;

	// - ?
	if i > 126 then TerminateApplication('    USB3000   256  !')
	else WriteLn(Format(' OpenDevice(%u) --> OK', [i]));

	//   
	ModuleHandle := pModule.GetModuleHandle();

	//       
	ModuleName := '0123456789';
	if not pModule.GetModuleName(pCHAR(ModuleName)) then TerminateApplication('    !')
	else WriteLn(' GetModuleName() --> OK');

	// ,    USB3000
	if Boolean(AnsiCompareStr(ModuleName, 'USB3000')) then TerminateApplication('       USB3000!')
	else WriteLn(' The module is ''USB3000''');

	//    
	if not pModule.GetModuleSerialNumber(@ModuleSerialNumber) then TerminateApplication('     !')
	else WriteLn(' GetModuleSerialNumber() --> OK');
	//       
	WriteLn(' The Serial Number is ' + String(ModuleSerialNumber));

	//    AVR
	if not pModule.GetAvrVersion(@AvrVersion) then TerminateApplication('     AVR !')
	else WriteLn(' GetAvrVersion() --> OK');
	//      AVR
	WriteLn(' The AVR Driver Version is ' + String(AvrVersion));

	//   DSP     DLL  Rtusbapi.dll
	if not pModule.LOAD_DSP(nil) then TerminateApplication('    USB3000!')
	else WriteLn(' LOAD_DSP() --> OK');

	//   
 	if not pModule.MODULE_TEST() then TerminateApplication('    USB3000!')
	else WriteLn(' MODULE_TEST() --> OK');

	//       DSP
	if not pModule.GET_DSP_INFO(@DspInfo) then TerminateApplication('     DSP!')
	else WriteLn(' GET_DSP_INFO() --> OK');
	//      DSP
	WriteLn(' The DSP Driver Version is ' + IntToStr(DspInfo.DspMajor) + '.' + IntToStr(DspInfo.DspMinor));

	//    size  FLASH_USB3000
	fi.size := sizeof(FLASH_USB3000);
	//     
	if not pModule.GET_FLASH(@fi) then TerminateApplication('     USB3000!')
	else WriteLn(' GET_MODULE_DESCR() --> OK');

	//       
	DacSample := 0;
	//     
	DacSample := Round(DacSample + fi.DacOffsetCoef[0]);
	DacSample := Round(DacSample * fi.DacScaleCoef[0]);
	if not pModule.WRITE_SAMPLE(0, @DacSample) then TerminateApplication('     !')
	else WriteLn(' WRITE_SAMPLE(0) --> OK');

	//        
	DacSample := 0;
	//     
	DacSample := Round(DacSample + fi.DacOffsetCoef[1]);
	DacSample := Round(DacSample * fi.DacScaleCoef[1]);
	if not pModule.WRITE_SAMPLE(1, @DacSample) then TerminateApplication('     !')
	else WriteLn(' WRITE_SAMPLE(1) --> OK');

	//    size  INPUT_PARS_USB3000
	op.size := sizeof(OUTPUT_PARS_USB3000);
	//      
	if not pModule.GET_OUTPUT_PARS(@op) then TerminateApplication('      !')
	else WriteLn(' GET_OUTPUT_PARS --> OK');

	//        USB3000
	op.OutputRate := WriteRate;					//     
	op.OutputFifoBaseAddress := $3000;			//   FIFO  
	op.OutputFifoLength := $F80;	 				//  FIFO  

	//        
	if not pModule.SET_OUTPUT_PARS(@op) then TerminateApplication('     !')
	else WriteLn(' SET_OUTPUT_PARS --> OK');

	//     
	SignalFrequency := 1.0; 			//  
	SignalAmplitude := 2000.0;			//   
	CurrentTime := 0.0 ;		  			//  

	//          
	WriteLn('');
	Write(' Module USB3000 (S/N ', StrPas(@fi.SerialNumber)); WriteLn(') is ready ... ');
	WriteLn(' Ouput parameters:');
	WriteLn(Format('   OutputRate = %5.3f kHz', [op.OutputRate]));
	WriteLn(' Signal parameters:');
	WriteLn(Format('   SignalFrequency  = %2.2f kHz', [SignalFrequency]));
	WriteLn(Format('   SignalAmplitude  = %1.3f V', [SignalAmplitude*5.0/2000.0]));

	//  
	Counter := $0; OldCounter := $FFFFFFFF;
	//     
	ThreadErrorNumber := 0;
	//    -   
	SetLength(Buffer, 2*DataStep);
	//    
	hWriteThread := CreateThread(nil, $2000, @WriteThread, nil, 0, WriteTid);
	if hWriteThread = THANDLE(nil) then TerminateApplication('     !');

{ !!!        !!!													}
	if DacNumber = 0 then Str := 'first'
	else Str := 'second';
	WriteLn(Format(#10#13'   Now SINUS signal is on the %s DAC channel', [Str]));
	WriteLn(' (you can press ESC key to terminate the program)');
	repeat
		if Counter <> OldCounter then
			begin
				Write(Format(' Counter %8u'#13, [Counter]));
				OldCounter := Counter;
			end
		else Sleep(20);
	until IsThreadComplete;

	//      
	WaitForSingleObject(hWriteThread, INFINITE);

	//   
	Write(#10#13#10#13);

	//     
	if hWriteThread = THANDLE(nil) then CloseHandle(hWriteThread);
	//    
	Buffer := nil;
	//   
	if not pModule.ReleaseInstance() then  TerminateApplication('     USB3000!')
	else WriteLn(' ReleaseInstance() --> OK');

	//       
	WriteLn('');
	if ThreadErrorNumber <> 0 then ShowThreadErrorMessage()
	else WriteLn(' The program was completed successfully!!!');
   
end.

