program ReadData;

{$APPTYPE CONSOLE}

uses
  SysUtils, Windows, Rtusbapi;

const
	// -    ( 256)  . ReadData
	DataStep : DWORD = 1024*1024;
	//    DataStep     
	NBlockToRead : WORD = 20;
	//   
	ReadRate : double  = 3000.0;

var
	//   
	hReadThread : THANDLE;
	ReadTid : DWORD;

	//     
	FileHandle: Integer;

	//   USB3000
	pModule : IRTUSB3000;
	//   Rtusbapi.dll
	DllVersion : DWORD;
	//  
	ModuleHandle : THandle;
	// ,      DSP
	DspInfo : DSP_INFO_USB3000;
	//     
	fi : FLASH_USB3000;
	//    
	ip : INPUT_PARS_USB3000;
	//  
	ModuleName: String;
	//   AVR
	AvrVersion : array [0..4] of CHAR;
	//   
	ModuleSerialNumber : array [0..8] of CHAR;
	//  -
	Counter, OldCounter : WORD;
	//     
	Buffer : array of SHORT;

	//       
	ThreadErrorNumber : WORD;
	//     
	IsThreadComplete : boolean;

	//  
	i : WORD;
	hConIn : THandle;
	ErrorString : string;

//------------------------------------------------------------------------------
//            ESCAPE
//------------------------------------------------------------------------------
function Terminated : boolean;
var
	Buffer: INPUT_RECORD;
	Count: DWORD;

begin
	Result := false;
	GetNumberOfConsoleInputEvents(hConIn, Count);
	if Count > 0 then
		begin
			ReadConsoleInput(hConIn, Buffer, 1, Count);
			case Buffer.EventType of
				KEY_EVENT:
					case Buffer.Event.KeyEvent.wVirtualKeyCode of
	            VK_ESCAPE: Result := true;
            //  
          end;
       //   
      end;
    end;
end;

//------------------------------------------------------------------------------
//        
//------------------------------------------------------------------------------
function WaitingForRequestCompleted(var ReadOv : OVERLAPPED) : boolean;
var 	BytesTransferred : DWORD;
begin
	Result := true;
	while true do
	   begin
			if GetOverlappedResult(ModuleHandle, ReadOv, BytesTransferred, FALSE) then break
			else if (GetLastError() <>  ERROR_IO_INCOMPLETE) then
				begin
					//      
					ThreadErrorNumber := 3; Result := false; break;
				end
			else if Terminated() then
				begin
					//   (  ESC)
					ThreadErrorNumber := 4; Result := false; break;
				end
			else Sleep(20);
		end;
end;

//------------------------------------------------------------------------------
//           
//                c  USB3000
//------------------------------------------------------------------------------
function ReadThread(var param : pointer): DWORD;
var
	RequestNumber : WORD;
	i : WORD ;
	//     
	ReadEvent : array[0..1] of THANDLE;
	//  OVERLAPPED    
	ReadOv : array[0..1] of OVERLAPPED;
	BytesTransferred : array[0..1] of DWORD;

begin
	Result := 0;
	//         bulk USB
	if not pModule.STOP_READ() then begin ThreadErrorNumber := 1; IsThreadComplete := true; exit; end;

	//   
	ReadEvent[0] := CreateEvent(nil, FALSE , FALSE, nil);
	FillMemory(@ReadOv[0], sizeof(OVERLAPPED), 0);
	ReadOv[0].hEvent := ReadEvent[0];
	ReadEvent[1] := CreateEvent(nil, FALSE , FALSE, nil);
	FillMemory(@ReadOv[1], sizeof(OVERLAPPED), 0);
	ReadOv[1].hEvent := ReadEvent[1];

	//        Buffer
	RequestNumber := 0;
	if not pModule.ReadData(@Buffer[0], @DataStep, @BytesTransferred[RequestNumber], @ReadOv[RequestNumber]) then
		begin
			if (GetLastError() <> ERROR_IO_PENDING) then
				begin
					CloseHandle(ReadEvent[0]); CloseHandle(ReadEvent[1]); ThreadErrorNumber := 2; IsThreadComplete := true; exit;
				end
		end;

	//      
	if pModule.START_READ() then
   	begin
			//   
			for i := 1 to (NBlockToRead-1) do
				begin
					RequestNumber := RequestNumber xor $1;
					//       
					if not pModule.ReadData(@Buffer[i*DataStep], @DataStep, @BytesTransferred[RequestNumber], @ReadOv[RequestNumber]) then
						begin
							if (GetLastError() <> ERROR_IO_PENDING) then
								begin
									ThreadErrorNumber := 2; break;
								end
						end;

					//       
					if not WaitingForRequestCompleted(ReadOv[RequestNumber xor $1]) then break;

					//        
					if ThreadErrorNumber <> 0 then break
					else if Terminated() then
						begin
							//   (  ESC)
							ThreadErrorNumber := 4; break;
						end
					else Sleep(20);

					//  
					Inc(Counter);
				end
		end
	else ThreadErrorNumber := 5;

	//       
	if ThreadErrorNumber = 0 then
		begin
			if WaitingForRequestCompleted(ReadOv[RequestNumber]) then Inc(Counter);
		end;

	//   
	if not pModule.STOP_READ() then ThreadErrorNumber := 1;

	//  ,     
	if not CancelIo(ModuleHandle) then ThreadErrorNumber := 6;

	//   
	CloseHandle(ReadEvent[0]); CloseHandle(ReadEvent[1]);

	//      
	IsThreadComplete := true;

end;

//------------------------------------------------------------------------------
//   
//------------------------------------------------------------------------------
procedure TerminateApplication(ErrorString: string);
begin
	//   
	MessageBox(HWND(nil), pCHAR(ErrorString), '!!!', MB_OK + MB_ICONINFORMATION);
	//     
	if hReadThread = THANDLE(nil) then CloseHandle(hReadThread);
	//   
	if pModule <> nil then pModule.ReleaseInstance();
	//    
	if Buffer <> nil then Buffer := nil;
	halt;
end;

//------------------------------------------------------------------------------
//         
//------------------------------------------------------------------------------
procedure ShowThreadErrorMessage;
begin
	case ThreadErrorNumber of
		$0 : ;
		$1 : WriteLn(' READ Thread: STOP_READ() --> Bad! :(((');
		$2 : WriteLn(' READ Thread: ReadData() --> Bad :(((');
		$3 : WriteLn(' READ Thread: Waiting data Error! :(((');
		//     ,   
		$4 : WriteLn(' READ Thread: The program was terminated! :(((');
		$5 : WriteLn(' READ Thread: START_READ() --> Bad :(((');
		else WriteLn(' READ Thread: Unknown error! :(((');
	end;
end;

//******************************************************************************
//      						main program
//******************************************************************************
begin
	//      - 
	hConIn := GetStdHandle(STD_INPUT_HANDLE);

	//    DLL 
	DllVersion := RtGetDllVersion;
	if DllVersion <> CURRENT_VERSION_RTUSBAPI then
		begin
			ErrorString := '  DLL  Rtusbapi.dll! ' + #10#13 +
						'           : ' + IntToStr(DllVersion shr 16) +  '.' + IntToStr(DllVersion and $FFFF) + '.' +
						' : ' + IntToStr(CURRENT_VERSION_RTUSBAPI shr 16) + '.' + IntToStr(CURRENT_VERSION_RTUSBAPI and $FFFF) + '.';
			TerminateApplication(ErrorString);
		end
	else WriteLn(' DLL Version --> OK');

	//        USB3000
	pModule := RtCreateInstance(pCHAR('usb3000'));
	if pModule = nil then TerminateApplication('     USB3000!')
	else WriteLn(' Module Interface --> OK');

	//    USB3000   127  
	for i := 0 to 126 do
   	if pModule.OpenDevice(i) then break;

	// - ?
	if i > 126 then TerminateApplication('    USB3000   256  !')
	else WriteLn(Format(' OpenDevice(%u) --> OK', [i]));

	//   
	ModuleHandle := pModule.GetModuleHandle();

	//       
	ModuleName := '0123456789';
	if not pModule.GetModuleName(pCHAR(ModuleName)) then TerminateApplication('    !')
	else WriteLn(' GetModuleName() --> OK');

	// ,    USB3000
	if Boolean(AnsiCompareStr(ModuleName, 'USB3000')) then TerminateApplication('       USB3000!')
	else WriteLn(' The module is ''USB3000''');

	//    
	if not pModule.GetModuleSerialNumber(@ModuleSerialNumber) then TerminateApplication('     !')
	else WriteLn(' GetModuleSerialNumber() --> OK');
	//       
	WriteLn(' The Serial Number is ' + String(ModuleSerialNumber));

	//    AVR
	if not pModule.GetAvrVersion(@AvrVersion) then TerminateApplication('     AVR !')
	else WriteLn(' GetAvrVersion() --> OK');
	//      AVR
	WriteLn(' The AVR Driver Version is ' + String(AvrVersion));

	//   DSP     DLL  Rtusbapi.dll
	if not pModule.LOAD_DSP(nil) then TerminateApplication('    USB3000!')
	else WriteLn(' LOAD_DSP() --> OK');

	//   
 	if not pModule.MODULE_TEST() then TerminateApplication('    USB3000!')
	else WriteLn(' MODULE_TEST() --> OK');

	//       DSP
	if not pModule.GET_DSP_INFO(@DspInfo) then TerminateApplication('     DSP!')
	else WriteLn(' GET_DSP_INFO() --> OK');
	//      DSP
	WriteLn(' The DSP Driver Version is ' + IntToStr(DspInfo.DspMajor) + '.' + IntToStr(DspInfo.DspMinor));

	//    size  FLASH_USB3000
	fi.size := sizeof(FLASH_USB3000);
	//     
	if not pModule.GET_FLASH(@fi) then TerminateApplication('     USB3000!')
	else WriteLn(' GET_MODULE_DESCR() --> OK');

	//    size  INPUT_PARS_USB3000
	ip.size := sizeof(INPUT_PARS_USB3000);
	//      
	if not pModule.GET_INPUT_PARS(@ip) then TerminateApplication('      !')
	else WriteLn(' GET_INPUT_PARS --> OK');

	//        USB3000
	ip.CorrectionEnabled := true;				//   
	ip.InputClockSource := INTERNAL_INPUT_CLOCK_USB3000;	//        
	ip.ChannelsQuantity := 4;					//   
	for i:=0 to (ip.ChannelsQuantity-1) do ip.ControlTable[i] := i;
	ip.InputRate := ReadRate;					//     
	ip.InterKadrDelay := 0.0;					//   -     0.0
	ip.InputFifoBaseAddress := $0;  			//   FIFO  
	ip.InputFifoLength := $3000;	 			//  FIFO  
	//     ,      USB3000
	for i:=0 to 7 do
		begin
			ip.AdcOffsetCoef[i] := fi.AdcOffsetCoef[i];
			ip.AdcScaleCoef[i] := fi.AdcScaleCoef[i];
		end;

	//        
	if not pModule.SET_INPUT_PARS(@ip) then TerminateApplication('     !')
	else WriteLn(' SET_INPUT_PARS --> OK');

	//          
	WriteLn('');
	Write(' Module USB3000 (S/N ', StrPas(@fi.SerialNumber)); WriteLn(') is ready ... ');
	WriteLn(' Input parameters:');
	if ip.InputClockSource = INTERNAL_INPUT_CLOCK_USB3000 then WriteLn('   InputClockSource is INTERNAL')
	else WriteLn('   InputClockSource is EXTERNAL');
	WriteLn('   ChannelsQuantity = ', ip.ChannelsQuantity);
	WriteLn(Format('   InputRate = %5.3f kHz', [ip.InputRate]));
	WriteLn(Format('   InterKadrDelay = %2.4f ms', [ip.InterKadrDelay]));
	WriteLn(Format('   ChannelRate =  %5.3f kHz', [ip.ChannelRate]));

	//    -   
	SetLength(Buffer, NBlockToRead*DataStep);
	//    
	hReadThread := CreateThread(nil, $2000, @ReadThread, nil, 0, ReadTid);
	if hReadThread = THANDLE(nil) then TerminateApplication('     !');

{ !!!         !!!													}
	WriteLn(#10#13' You can press ESC key to terminate the program...');
	//     
	ThreadErrorNumber := 0;
	//      
	IsThreadComplete := false;
	//  
	Counter := $0; OldCounter := $FFFF;
	repeat
		if Counter <> OldCounter then
			begin
				Write(Format(' Counter %3u from %3u'#13, [Counter, NBlockToRead]));
				OldCounter := Counter;
			end
		else Sleep(20);
	until IsThreadComplete;

	//         
	WaitForSingleObject(hReadThread, INFINITE);

	//   
	Write(#10#13#10#13);

	//       -    
	if ThreadErrorNumber = 0 then
	begin
		//       
		FileHandle := FileCreate('Test.dat');
		if FileHandle = -1 then TerminateApplication('    Test.dat    !')
		else WriteLn(' Open file Test.dat... OK!');

		//       
		if FileWrite(FileHandle, Buffer[0], NBlockToRead*DataStep*sizeof(SHORT)) = -1 then  TerminateApplication('       Test.dat!')
		else WriteLn(' Write file Test.dat... OK!');

		//   
		FileClose(FileHandle);
	end;

	//     
	if hReadThread = THANDLE(nil) then CloseHandle(hReadThread);
	//    
	Buffer := nil;
	//   
	if not pModule.ReleaseInstance() then  TerminateApplication('     USB3000!')
	else WriteLn(' ReleaseInstance() --> OK');

	//       
	WriteLn('');
	if ThreadErrorNumber <> 0 then ShowThreadErrorMessage()
	else WriteLn(' The program was completed successfully!!!');

end.
