unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Rtusbapi;

type
  TLoadingForm = class(TForm)
    LoadingButton: TButton;
    BoardPars: TGroupBox;
    StaticText7: TStaticText;
    StaticText3: TStaticText;
    StaticText4: TStaticText;
    StaticText2: TStaticText;
    StaticText6: TStaticText;
    ModuleNameEdit: TEdit;
    SerialNumberEdit: TEdit;
    StaticText5: TStaticText;
    DspTypeEdit: TEdit;
    RevisionEdit: TEdit;
    ClockFrequencyEdit: TEdit;
    IsDacPresentedEdit: TEdit;
    StaticText8: TStaticText;
    ModuleLoadingLed: TShape;
    StaticText13: TStaticText;
    Memo: TMemo;
    GroupBox1: TGroupBox;
    StaticText10: TStaticText;
    AvrVersionEdit: TEdit;
    StaticText11: TStaticText;
    DspVersionEdit: TEdit;
    StaticText1: TStaticText;
    UsbSpeedEdit: TEdit;
    StaticText9: TStaticText;
    procedure LoadingButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
	procedure DoShortCut(var Msg: TWMKey; var Handled: Boolean);
	procedure InitDisplayInfo;
	procedure DisplayInfo(fi : FLASH_USB3000);
  public
    { Public declarations }
  end;

var
	LoadingForm: TLoadingForm;
	pModule : IRTUSB3000;
	DllVersion : DWORD;
	ModuleType : String;
   hModule : THandle;
   DspDriver: String;
	// ,      DSP
	DspInfo : DSP_INFO_USB3000;
	//     
   fi : FLASH_USB3000;
	//    
   ap : INPUT_PARS_USB3000;
	//    
   dp : OUTPUT_PARS_USB3000;
	//  
	ModuleName : array [0..10] of Char;
	//  USB
	UsbSpeed : Byte;
	//   
	ModuleSerialNumber : array [0..8] of Char;
	//   AVR
	AvrVersion : array [0..4] of Char;
   Status : boolean;

DllError : array[0..127] of Char;
N : DWord;

	//  
	ReadEvent : THANDLE ;
	// OVERLAPPED 
	ReadOv : OVERLAPPED ;
	BytesTransferred : DWORD;
   DataStep : DWORD;
	Buffer : array[0..35000] of SHORT;
   AdcBuffer : PSHORT;
   TimeOut : DWORD ;

implementation

{$R *.DFM}

//------------------------------------------------------------------------------
//        
//------------------------------------------------------------------------------
procedure TLoadingForm.LoadingButtonClick(Sender: TObject);
var
	i : BYTE;
   ErrorString : AnsiString;
begin
	LoadingButton.Enabled := false;
	InitDisplayInfo();
   Application.ProcessMessages;

	//    DLL 
	DllVersion := RtGetDllVersion;
   if DllVersion <> CURRENT_VERSION_RTUSBAPI then
   	begin
			ErrorString := '  DLL  Rtusbapi.dll!' + #10#13 +
						'            : ' + IntToStr(DllVersion shr 16) +  '.' + IntToStr(DllVersion and $FFFF) + '.' +
						' : ' + IntToStr(CURRENT_VERSION_RTUSBAPI shr 16) + '.' + IntToStr(CURRENT_VERSION_RTUSBAPI and $FFFF) + '.';
      	Application.MessageBox(PChar(ErrorString), '!!!', MB_OK + MB_ICONINFORMATION);
	      Close();
         Exit;
      end;

	//        USB3000
	ModuleType := 'usb3000';
	pModule := RtCreateInstance(PChar(ModuleType));
	if pModule = nil then begin Application.MessageBox('     USB3000!', '!!!', MB_OK + MB_ICONINFORMATION); Close(); Exit; end;
	//   -     
	if not pModule.OpenDevice(0) then begin Application.MessageBox('    ''USB3000''    !', '!!!', MB_OK + MB_ICONINFORMATION); LoadingButton.Enabled := true; pModule.ReleaseInstance(); Exit; end;
	//       
	if not pModule.GetModuleName(@ModuleName) then begin Application.MessageBox('        !', '!!!', MB_OK + MB_ICONINFORMATION); pModule.ReleaseInstance(); LoadingButton.Enabled := true; Exit; end;
	// ,   'USB3000'
	if Boolean(StrComp(@ModuleName, PChar('USB3000'))) then begin Application.MessageBox('     ''USB3000''!', '!!!', MB_OK + MB_ICONINFORMATION); pModule.ReleaseInstance(); LoadingButton.Enabled := true; Exit; end;
	//     USB 
	if not pModule.GetUsbSpeed(@UsbSpeed) then begin Application.MessageBox('      USB!', '!!!', MB_OK + MB_ICONINFORMATION); pModule.ReleaseInstance(); LoadingButton.Enabled := true; Exit; end;
	//    
	if not pModule.GetModuleSerialNumber(@ModuleSerialNumber) then begin Application.MessageBox('     !', '!!!', MB_OK + MB_ICONINFORMATION); pModule.ReleaseInstance(); LoadingButton.Enabled := true; Exit; end;
	//    AVR
	if not pModule.GetAvrVersion(@AvrVersion) then begin Application.MessageBox('     AVR !', '!!!', MB_OK + MB_ICONINFORMATION); pModule.ReleaseInstance(); LoadingButton.Enabled := true; Exit; end;

	//     
//	DspDriver := 'usb3000.rtd';
//	if not pModule.LOAD_DSP(PChar(DspDriver)) then begin ModuleLoadingLed.Brush.Color := clRed; Application.MessageBox('    DSP  !', '!!!', MB_OK + MB_ICONINFORMATION); pModule.ReleaseInstance(); Close(); Exit; end;
	//   DSP     DLL 
	if not pModule.LOAD_DSP() then begin ModuleLoadingLed.Brush.Color := clRed; Application.MessageBox('    DSP  !', '!!!', MB_OK + MB_ICONINFORMATION); pModule.ReleaseInstance(); Close(); Exit; end;
	//   
	if not pModule.MODULE_TEST() then begin ModuleLoadingLed.Brush.Color := clRed; Application.MessageBox('    DSP!', '!!!', MB_OK + MB_ICONINFORMATION); pModule.ReleaseInstance(); Close(); Exit; end;

	//       DSP
	if not pModule.GET_DSP_INFO(@DspInfo) then begin ModuleLoadingLed.Brush.Color := clRed; Application.MessageBox('     DSP!', '!!!', MB_OK + MB_ICONINFORMATION); pModule.ReleaseInstance(); Close(); Exit; end;

	//    size  FLASH_USB3000
	fi.size := sizeof(FLASH_USB3000);
	//     
	if not pModule.GET_FLASH(@fi) then begin ModuleLoadingLed.Brush.Color := clRed; Application.MessageBox('    !', '!!!', MB_OK + MB_ICONINFORMATION); pModule.ReleaseInstance(); Close(); Exit; end;

	//  !   
	ModuleLoadingLed.Brush.Color := clLime;
	//     
	DisplayInfo(fi);

	//    size  INPUT_PARS_USB3000
	ap.size := sizeof(INPUT_PARS_USB3000);
	//     
	if not pModule.GET_INPUT_PARS(@ap) then begin Application.MessageBox('     !', '!!!', MB_OK + MB_ICONINFORMATION); pModule.ReleaseInstance(); Close(); Exit; end;

//	N := pModule.GetLastErrorString(@DllError, 128);

	//    
	ap.ChannelsQuantity := 4;
	for i:=0 to (ap.ChannelsQuantity-1) do ap.ControlTable[i] := i;
	ap.InputRate := 1000.;
	ap.InterKadrDelay := 0.0;
	//       
	if not pModule.SET_INPUT_PARS(@ap) then begin Application.MessageBox('    !', '!!!', MB_OK + MB_ICONINFORMATION); pModule.ReleaseInstance(); Close(); Exit; end;

	//    size  OUTPUT_PARS_USB3000
	dp.size := sizeof(OUTPUT_PARS_USB3000);
	//     
	if not pModule.GET_OUTPUT_PARS(@dp) then begin Application.MessageBox('     !', '!!!', MB_OK + MB_ICONINFORMATION); pModule.ReleaseInstance(); Close(); Exit; end;
	//    
	dp.OutputRate := 100.0;
	if not pModule.SET_OUTPUT_PARS(@dp) then begin Application.MessageBox('    !', '!!!', MB_OK + MB_ICONINFORMATION); pModule.ReleaseInstance(); Close(); Exit; end;
{
	//       
	ReadEvent := CreateEvent(nil, FALSE , FALSE, nil);
	FillMemory(@ReadOv, sizeof(OVERLAPPED), 0); ReadOv.hEvent := ReadEvent;
	DataStep := 32768;
	TimeOut := Trunc(ap.ChannelsQuantity*DataStep/ap.ChannelRate + 1000.0);

	AdcBuffer := @Buffer;

	//      
	if not pModule.STOP_READ() then begin Application.MessageBox('   !', '!!!', MB_OK); Close(); Exit; end;
	//      
	if not pModule.START_READ() then begin Application.MessageBox('   !', '!!!', MB_OK); Close(); Exit; end;

	//       AdcBuffer
	BytesTransferred := 0;
	pModule.ReadData(AdcBuffer, @DataStep, @BytesTransferred, @ReadOv);
	//    
	if WaitForSingleObject(ReadEvent, TimeOut) = WAIT_TIMEOUT then Application.MessageBox('    !', '!!!', MB_OK);
   // !   Buffer    .
}
	//   
	if not pModule.ReleaseInstance() then begin Application.MessageBox('    !', '!!!', MB_OK + MB_ICONINFORMATION); Close(); end;
	LoadingButton.Enabled := true;

   LoadingButton.SetFocus();
end;

//---------------------------------------------------------------------------
//      
//---------------------------------------------------------------------------
procedure TLoadingForm.InitDisplayInfo;
begin
	UsbSpeedEdit.Text := '???';
	AvrVersionEdit.Text := '????';
	DspVersionEdit.Text := '?????';
	ModuleLoadingLed.Brush.Color := clBtnFace;
	ModuleNameEdit.Text := '???????';
	DspTypeEdit.Text := '??????????';
	SerialNumberEdit.Text := '????????';
	ClockFrequencyEdit.Text := '?????';
	RevisionEdit.Text := '?';
	IsDacPresentedEdit.Text := '????';
end;

//---------------------------------------------------------------------------
//     
//---------------------------------------------------------------------------
procedure TLoadingForm.DisplayInfo(fi : FLASH_USB3000);
begin
	if UsbSpeed = USB11_USB2185 then UsbSpeedEdit.Text := ' 12'
   else if UsbSpeed = USB20_USB2185 then UsbSpeedEdit.Text := '480';

	AvrVersionEdit.Text := StrPas(@AvrVersion);
	DspVersionEdit.Text := IntToStr(DspInfo.DspMajor) + '.' + IntToStr(DspInfo.DspMinor);

	fi.Name[10] := Byte(#0);
	ModuleNameEdit.Text := StrPas(@fi.Name);
	fi.DspType[16] := Byte(#0);
	DspTypeEdit.Text := StrPas(@fi.DspType);
	fi.SerialNumber[8] := Byte(#0);
	SerialNumberEdit.Text := StrPas(@fi.SerialNumber);
	ClockFrequencyEdit.Text := FormatFloat('0.', fi.DspClockout/1000.0);
	RevisionEdit.Text := String(fi.Revision);
	if fi.IsDacPresented = 0 then IsDacPresentedEdit.Text := ''
	else IsDacPresentedEdit.Text := '';
end;

//---------------------------------------------------------------------------
//     
//---------------------------------------------------------------------------
procedure TLoadingForm.FormCreate(Sender: TObject);
begin
   Application.OnShortCut := DoShortCut;
	InitDisplayInfo();
end;

//---------------------------------------------------------------------------
//    ESCAPE  
//---------------------------------------------------------------------------
procedure TLoadingForm.DoShortCut(var Msg: TWMKey; var Handled: Boolean);
begin
	if Msg.CharCode = VK_ESCAPE then
   begin
   	if Application.MessageBox('   ?', ' !', MB_YESNO + MB_ICONQUESTION) = IDYES then Application.Terminate();
   end;
end;

end.
