//******************************************************************************
//      - 
//   USB3000
//******************************************************************************
#include <stdio.h>
#include <conio.h>
#include <math.h>
#include "Rtusbapi.h"

//   
void TerminateApplication(char *ErrorString, bool TerminationFlag = true);
//     
BOOL WaitingForWriteRequestCompleted(OVERLAPPED * const WriteOv);
//  
void ShowThreadErrorMessage(void);

//    
DWORD WINAPI ServiceReadThread(PVOID /*Context*/);
//   
HANDLE hReadThread;
DWORD ReadTid;

//    
DWORD WINAPI ServiceWriteThread(PVOID /*Context*/);
//   
HANDLE hWriteThread;
DWORD WriteTid;

//      
HANDLE hFile;


//   -   
const WORD MaxVirtualSoltsQuantity = 127;

//    Rtusbapi.dll
DWORD DllVersion;
//    
IRTUSB3000 *pModule;
//  
HANDLE ModuleHandle;
//  
char ModuleName[10];
//    USB
BYTE UsbSpeed;
//   
char ModuleSerialNumber[9];
//   AVR
char AvrVersion[5];
//     
RTUSB3000::FLASH fi;
// ,      DSP
RTUSB3000::DSP_INFO di;
// ,    
RTUSB3000::INPUT_PARS ip;
// ,    
RTUSB3000::OUTPUT_PARS dp;

//max  -   ( 32)  . ReadData  WriteData()
DWORD DataStep = 1024*1024;
// -     DataStep 
const WORD NBlockRead = 20;
//     
DWORD ReadPoints = NBlockRead*DataStep;
//     
DWORD WritePoints = 2*DataStep;
//      
SHORT *ReadBuffer;
//      
SHORT *WriteBuffer;

// -   
const WORD CHANNELS_QUANTITY = 0x1;
//    
const double ReadRate = 3000.0;
//   
const WORD DacNumber = 0x0;
//    
const double WriteRate = 100.0;

//  -
DWORD Counter[2] = { 0x0, 0x0};
DWORD OldCounter[2] = { 0xFFFFFFFF, 0xFFFFFFFF };

//       
WORD ReadThreadErrorNumber;
//       
WORD WriteThreadErrorNumber;
//      
bool IsThreadComplete = false;

//------------------------------------------------------------------------
//  
//------------------------------------------------------------------------
void main(void)
{
	WORD i;

	//       - 
	ReadBuffer  = WriteBuffer = NULL;
	//     - 
	hReadThread = hWriteThread = NULL;
	//     :(
	hFile = INVALID_HANDLE_VALUE;
 	//        
	ReadThreadErrorNumber = WriteThreadErrorNumber = 0x0;

	//   
	clrscr();

	printf(" *********************************************\n");
	printf(" Console example for USB3000 Read-Write stream\n");
	printf(" *********************************************\n\n");

	//     Rtusbapi.dll
	if((DllVersion = RtGetDllVersion()) != CURRENT_VERSION_RTUSBAPI)
	{
		char String[128];
		sprintf(String, " Rtusbapi.dll Version Error!!!\n   Current: %1u.%1u. Required: %1u.%1u",
											DllVersion >> 0x10, DllVersion & 0xFFFF,
											CURRENT_VERSION_RTUSBAPI >> 0x10, CURRENT_VERSION_RTUSBAPI & 0xFFFF);

		TerminateApplication(String);
	}
	else printf(" Rtusbapi.dll Version --> OK\n");

	//      USB3000
	pModule = static_cast<IRTUSB3000 *>(RtCreateInstance("usb3000"));
	if(pModule == NULL)  TerminateApplication(" Module Interface --> Bad\n");
	else printf(" Module Interface --> OK\n");

	//    USB3000   127  
	for(i = 0x0; i < MaxVirtualSoltsQuantity; i++) if(pModule->OpenDevice(i)) break;
	// - ?
	if(i == MaxVirtualSoltsQuantity) TerminateApplication(" Can't find module USB3000 in first 127 virtual slots!\n");
	else printf(" OpenDevice(%u) --> OK\n", i);

	//    (handle) 
	ModuleHandle = pModule->GetModuleHandle();
	if(ModuleHandle == INVALID_HANDLE_VALUE) TerminateApplication(" GetModuleHandle() --> Bad\n");
	else printf(" GetModuleHandle() --> OK\n");

	//    
	if(!pModule->GetModuleName(ModuleName)) TerminateApplication(" GetModuleName() --> Bad\n");
	else printf(" GetModuleName() --> OK\n");
	// ,    'USB3000'
	if(strcmp(ModuleName, "USB3000")) TerminateApplication(" The module is not 'USB3000'\n");
	else printf(" The module is 'USB3000'\n");

	//      USB20
	if(!pModule->GetUsbSpeed(&UsbSpeed)) { printf(" GetUsbSpeed() --> Bad\n"); exit(1); }
	else printf(" GetUsbSpeed() --> OK\n");
	//     AVR
	printf(" USB Speed is %s\n", UsbSpeed ? "HIGH (480 Mbit/s)" : "FULL (12 Mbit/s)");

	//    
	if(!pModule->GetModuleSerialNumber(ModuleSerialNumber)) TerminateApplication(" GetModuleSerialNumber() --> Bad\n");
	else printf(" GetModuleSerialNumber() --> OK\n");
	//     
	printf(" Module Serial Number is %s\n", ModuleSerialNumber);

	//    AVR
	if(!pModule->GetAvrVersion(AvrVersion)) TerminateApplication(" GetAvrVersion() --> Bad\n");
	else printf(" GetAvrVersion() --> OK\n");
	//     AVR
	printf(" Avr Driver Version is %s\n", AvrVersion);

	//   DSP      DLL 
	if(!pModule->LOAD_DSP()) TerminateApplication(" LOAD_DSP() --> Bad\n");
	else printf(" LOAD_DSP() --> OK\n");

	//   
 	if(!pModule->MODULE_TEST()) TerminateApplication(" MODULE_TEST() --> Bad\n");
	else printf(" MODULE_TEST() --> OK\n");

	//      DSP
	if(!pModule->GET_DSP_INFO(&di)) TerminateApplication(" GET_DSP_INFO() --> Bad\n");
	else printf(" GET_DSP_INFO() --> OK\n");
	//      DSP
	printf(" DSP Driver version is %1u.%1u\n", di.DspMajor, di.DspMinor);

	//  
	fi.size = sizeof(RTUSB3000::FLASH);
	if(!pModule->GET_FLASH(&fi)) TerminateApplication(" GET_FLASH() --> Bad\n");
	else printf(" GET_FLASH() --> OK\n");

	//      
	if(!fi.IsDacPresented) TerminateApplication("\n DAC is absent on this module USB3000!\n");

	//    size  RTUSB3000::INPUT_PARS
	ip.size = sizeof(RTUSB3000::INPUT_PARS);
	//     
	if(!pModule->GET_INPUT_PARS(&ip)) TerminateApplication(" GET_INPUT_PARS() --> Bad\n");
	else printf(" GET_INPUT_PARS() --> OK\n");

	//     
	ip.CorrectionEnabled = true;							//   
	ip.InputClockSource = RTUSB3000::INTERNAL_INPUT_CLOCK;	//        
//	ip.InputClockSource = RTUSB3000::EXTERNAL_INPUT_CLOCK;	//        
	ip.SynchroType = RTUSB3000::NO_SYNCHRO;			//        
//	ip.SynchroType = RTUSB3000::TTL_START_SYNCHRO;	//        
	ip.ChannelsQuantity = CHANNELS_QUANTITY; 			//   
	for(i = 0x0; i < ip.ChannelsQuantity; i++) ip.ControlTable[i] = (WORD)(i);
	ip.InputRate = ReadRate;								//     
	ip.InterKadrDelay = 0.0;
	ip.InputFifoBaseAddress = 0x0;  						//   FIFO     DSP
	ip.InputFifoLength = 0x3000;	 						//  FIFO     DSP
	//     ,     
	for(i = 0x0; i < 0x8; i++) { ip.AdcOffsetCoef[i] = fi.AdcOffsetCoef[i]; ip.AdcScaleCoef[i] = fi.AdcScaleCoef[i]; }
	//       
	if(!pModule->SET_INPUT_PARS(&ip)) TerminateApplication(" SET_INPUT_PARS() --> Bad\n");
	else printf(" SET_INPUT_PARS() --> OK\n");

	//     
	dp.size = sizeof(RTUSB3000::OUTPUT_PARS);
	if(!pModule->GET_OUTPUT_PARS(&dp)) TerminateApplication(" GET_OUTPUT_PARS() --> Bad\n");
	else printf(" GET_OUTPUT_PARS() --> OK\n");

	//     
	dp.OutputRate = WriteRate;		  			//     
	dp.OutputFifoBaseAddress = 0x3000;   	//   FIFO     DSP
	dp.OutputFifoLength = 0xF80;				//  FIFO     DSP

	//     
	if(!pModule->SET_OUTPUT_PARS(&dp)) TerminateApplication(" SET_OUTPUT_PARS() --> Bad\n");
	else printf(" SET_OUTPUT_PARS() --> OK\n");

	//       
	ReadBuffer = new SHORT[ReadPoints];
	if(!ReadBuffer) TerminateApplication(" Cannot allocate ReadBuffer memory\n");
	//       
	WriteBuffer = new SHORT[WritePoints];
	if(!WriteBuffer) TerminateApplication(" Cannot allocate WriteBuffer memory\n");

	printf(" \n");
	printf(" Module USB3000 (S/N %s) is ready ... \n", fi.SerialNumber);
	printf(" Read parameters:\n");
	printf("   InputClockSource is %s\n", ip.InputClockSource ? "EXTERNAL" : "INTERNAL");
	printf("   SynchroType is %s\n", ip.SynchroType ? "TTL_START_SYNCHRO" : "NO_SYNCHRO");
	printf("   ChannelsQuantity = %2d\n", ip.ChannelsQuantity);
	printf("   AdcRate = %8.3f kHz\n", ip.InputRate);
	printf("   InterKadrDelay = %2.4f ms\n", ip.InterKadrDelay);
	printf("   ChannelRate = %8.3f kHz\n", ip.ChannelRate);
	printf(" Write parameters:\n");
	printf("   DacRate = %6.1f kHz\n\n", dp.OutputRate);

	//      
	hReadThread = CreateThread(0, 0x2000, ServiceReadThread, 0, 0, &ReadTid);
	if(!hReadThread) TerminateApplication("Cann't start input data thread!");
	//      
	hWriteThread = CreateThread(0, 0x2000, ServiceWriteThread, 0, 0, &WriteTid);
	if(!hWriteThread) TerminateApplication("Cann't start output data thread!");

	//     
	while(!IsThreadComplete)
	{
		if(Counter[0] != OldCounter[0]) { printf(" Read Counter %3lu from %3lu\r", Counter[0], NBlockRead); OldCounter[0] = Counter[0]; }
		else Sleep(20);
	}
	//      
	WaitForSingleObject(hReadThread, INFINITE);
	//      
	WaitForSingleObject(hWriteThread, INFINITE);
	//   
	printf("\n\n");

	//         -     
 	if(!ReadThreadErrorNumber | WriteThreadErrorNumber)
	{
		//      
		hFile = CreateFile("Test.dat", GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, 0, NULL);
		if(hFile == INVALID_HANDLE_VALUE) TerminateApplication(" Open file 'Test.dat' --> Failed!!!\n");
		else printf(" CreateFile(Test.dat) --> Ok\n");

		//      
		DWORD FileBytesWritten=0x0;
		if(!WriteFile(	hFile,					// handle to file to write to
	    					ReadBuffer,		 		// pointer to data to write to file
							2*ReadPoints,	 		// number of bytes to write
    						&FileBytesWritten,	// pointer to number of bytes written
					   	NULL			  			// pointer to structure needed for overlapped I/O
					   )) TerminateApplication(" WriteFile(Test.dat) --> Failed!!!");
		else printf(" WriteFile(Test.dat) --> Ok\n");
	}

	//    -   
	if(ReadThreadErrorNumber | WriteThreadErrorNumber) { TerminateApplication(NULL, false); ShowThreadErrorMessage(); }
	else { printf("\n"); TerminateApplication("\n The program was completed successfully!!!\n", false); }
}

//------------------------------------------------------------------------
// ,       
//------------------------------------------------------------------------
DWORD WINAPI ServiceReadThread(PVOID /*Context*/)
{
	WORD i;
	WORD RequestNumber;
	//     
	HANDLE ReadEvent[2];
	//  OVERLAPPED    
	OVERLAPPED ReadOv[2];
	DWORD BytesTransferred[2];
	DWORD TimeOut;

	//         bulk USB
	if(!pModule->STOP_READ()) { ReadThreadErrorNumber = 0x6; IsThreadComplete = true; return 0; }

	//   
	ReadEvent[0] = CreateEvent(NULL, FALSE , FALSE, NULL);
	memset(&ReadOv[0], 0, sizeof(OVERLAPPED)); ReadOv[0].hEvent = ReadEvent[0];
	ReadEvent[1] = CreateEvent(NULL, FALSE , FALSE, NULL);
	memset(&ReadOv[1], 0, sizeof(OVERLAPPED)); ReadOv[1].hEvent = ReadEvent[1];

	//   
	TimeOut = DataStep/ReadRate + 1000;

	//      
	RequestNumber = 0;
	if(!pModule->ReadData(ReadBuffer, &DataStep, &BytesTransferred[RequestNumber], &ReadOv[RequestNumber]))
				if(GetLastError() != ERROR_IO_PENDING) { CloseHandle(ReadEvent[0]); CloseHandle(ReadEvent[1]); ReadThreadErrorNumber = 0x2; IsThreadComplete = true; return 0; }

	//    
	if(pModule->START_READ())
	{
		//   
		for(i = 0x1; i < NBlockRead; i++)
		{
			RequestNumber ^= 0x1;
			//      
			if(!pModule->ReadData(ReadBuffer + i*DataStep, &DataStep, &BytesTransferred[RequestNumber], &ReadOv[RequestNumber]))
					if(GetLastError() != ERROR_IO_PENDING) { ReadThreadErrorNumber = 0x2; break; }

			//       
			if(WaitForSingleObject(ReadEvent[RequestNumber^0x1], TimeOut) == WAIT_TIMEOUT)
				            		{ ReadThreadErrorNumber = 0x3; break; }

			if(ReadThreadErrorNumber) break;
			else if(kbhit()) { ReadThreadErrorNumber = 0x1; break; }
			else Sleep(20);
			Counter[0]++;
		}
		//       
		if(!ReadThreadErrorNumber)
		{
			RequestNumber ^= 0x1;
			if(WaitForSingleObject(ReadEvent[RequestNumber^0x1], TimeOut) == WAIT_TIMEOUT) ReadThreadErrorNumber = 0x3;
			Counter[0]++;
		}
	}
	else { ReadThreadErrorNumber = 0x5; }

	//   
	if(!pModule->STOP_READ()) ReadThreadErrorNumber = 0x6;
	//        
	if(!CancelIo(ModuleHandle)) { ReadThreadErrorNumber = 0x7; }
	//    
	for(i = 0x0; i < 0x2; i++) CloseHandle(ReadEvent[i]);
	//  
	Sleep(100);
	//      
	IsThreadComplete = true;
	//        
	return 0;
}

//------------------------------------------------------------------------
// ,       
//------------------------------------------------------------------------
DWORD WINAPI ServiceWriteThread(PVOID /*Context*/)
{
	WORD RequestNumber;
	DWORD i;
	DWORD BaseIndex;
	//  
	HANDLE WriteEvent[2];
	// OVERLAPPED       
	OVERLAPPED WriteOv[2];
	DWORD BytesTransferred[2];

	//     
	double CurrentTime = 0.0; 			  		//  
	double SignalFrequency = 1.0; 	  		//  
	double SignalAmplitude = 2000.0;			//   

	//         bulk USB  (PIPE_RESET)
	if(!pModule->STOP_WRITE()) { WriteThreadErrorNumber = 0x6; IsThreadComplete = true; return 0; }

	//     FIFO   (  )
	for(i = 0x0; i < (DWORD)dp.OutputFifoLength; i++)
	{
		WriteBuffer[i] = (WORD)(2047.0 + SignalAmplitude*sin(2.*M_PI*SignalFrequency*CurrentTime));
		WriteBuffer[i] &= (WORD)(0xFFF);
		WriteBuffer[i] |= (WORD)(DacNumber << 15) | (WORD)(0x1 << 14);
		CurrentTime += 1.0/dp.OutputRate;
	}
	//   FIFO    
	if(!pModule->PUT_DM_ARRAY(dp.OutputFifoBaseAddress, dp.OutputFifoLength, (SHORT *)WriteBuffer))
   										{ WriteThreadErrorNumber = 0x1; IsThreadComplete = true; return 1; }

	//       WriteBuffer (  )
	for(i = 0x0; i < 2*DataStep; i++)
	{
		WriteBuffer[i] = (WORD)(2047.0 + SignalAmplitude*sin(2.*M_PI*SignalFrequency*CurrentTime));
		WriteBuffer[i] &= (WORD)(0xFFF);
		WriteBuffer[i] |= (WORD)(DacNumber << 15) | (WORD)(0x1 << 14);
		CurrentTime += 1.0/dp.OutputRate;
	}

	WriteEvent[0] = CreateEvent(NULL, FALSE , FALSE, NULL);
	memset(&WriteOv[0],0,sizeof(OVERLAPPED)); WriteOv[0].hEvent=WriteEvent[0];
	WriteEvent[1] = CreateEvent(NULL, FALSE , FALSE, NULL);
	memset(&WriteOv[1],0,sizeof(OVERLAPPED)); WriteOv[1].hEvent=WriteEvent[1];

	RequestNumber = 0x0;
	//    
	if(!pModule->WriteData(WriteBuffer, &DataStep, &BytesTransferred[RequestNumber], &WriteOv[RequestNumber]))
				if(GetLastError() != ERROR_IO_PENDING) { CloseHandle(WriteEvent[0]); CloseHandle(WriteEvent[1]); WriteThreadErrorNumber = 0x2; IsThreadComplete = true; return 0; }

	//   
	if(pModule->START_WRITE())
	{
		//      
		while(!IsThreadComplete)
		{
			RequestNumber ^= 0x1;
			//           WriteBuffer
			if(!pModule->WriteData(WriteBuffer + RequestNumber*DataStep, &DataStep, &BytesTransferred[RequestNumber], &WriteOv[RequestNumber]))
					if(GetLastError() != ERROR_IO_PENDING) { WriteThreadErrorNumber = 0x2; break; }

			//        
			if(!WaitingForWriteRequestCompleted(&WriteOv[RequestNumber^0x1])) break;

			//     (  )
			BaseIndex = (RequestNumber^0x1)*DataStep;
			for(i = 0x0; i < DataStep; i++)
			{
				WriteBuffer[i + BaseIndex] = (WORD)(2047.0 + SignalAmplitude*sin(2.*M_PI*SignalFrequency*CurrentTime));
				WriteBuffer[i + BaseIndex] &= (WORD)(0xFFF);
				WriteBuffer[i + BaseIndex] |= (WORD)(DacNumber << 15) | (WORD)(0x1 << 14);
				CurrentTime += 1.0/dp.OutputRate;
	  		}

			if(IsThreadComplete) break;
			else if(kbhit()) { WriteThreadErrorNumber = 0x3; break; }
			else Sleep(20);
			Counter[1]++;
		}
	}
	else { WriteThreadErrorNumber = 0x5; }

	//         bulk USB  (PIPE_RESET)
	if(!pModule->STOP_WRITE()) WriteThreadErrorNumber = 0x6;
	//        
	if(!CancelIo(ModuleHandle)) { WriteThreadErrorNumber = 0x7; }
	//   
	for(i = 0x0; i < 0x2; i++) CloseHandle(WriteEvent[i]);
	//  
	Sleep(100);
	//      
	IsThreadComplete = true;
	//        
	return 0;
}

//------------------------------------------------------------------------------
//        
//------------------------------------------------------------------------------
BOOL WaitingForWriteRequestCompleted(OVERLAPPED * const WriteOv)
{
	DWORD BytesTransferred;

	while(true)
	{
			if(GetOverlappedResult(ModuleHandle, WriteOv, &BytesTransferred, FALSE)) break;
			else if(GetLastError() !=  ERROR_IO_INCOMPLETE) { WriteThreadErrorNumber = 0x2; return FALSE; }
			else if(IsThreadComplete) return FALSE;
			else Sleep(20);
	}
	return TRUE;
}

//------------------------------------------------------------------------
//    
//------------------------------------------------------------------------
void ShowThreadErrorMessage(void)
{
	switch(ReadThreadErrorNumber)
	{
		case 0x0:
			break;

		case 0x1:
			//     ,   
			printf("\n READ Thread: The program was terminated! :(((\n");
			break;

		case 0x2:
			printf("\n READ Thread: ReadData() --> Bad :(((\n");
			break;

		case 0x3:
			printf("\n READ Thread: Timeout is occured :(((\n");
			break;

		case 0x4:
			printf("\n READ Thread: Buffer Data Error! :(((\n");
			break;

		case 0x5:
			printf("\n READ Thread: START_READ() --> Bad :(((\n");
			break;

		case 0x6:
			printf("\n READ Thread: STOP_READ() --> Bad! :(((\n");
			break;

		case 0x7:
			printf("\n READ Thread: Can't complete input and output (I/O) operations! :(((");
			break;

		default:
			printf("\n READ Thread: Unknown error! :(((\n");
			break;
   }


	switch(WriteThreadErrorNumber)
	{
		case 0x0:
			break;

		case 0x1:
			printf("\n WRITE Thread: PUT_DM_ARRAY() --> Bad! :(((\n");
			break;

		case 0x2:
			printf("\n WRITE Thread: Write Request --> Bad :(((\n");
			break;

		case 0x3:
			//     ,   
			printf("\n WRITE Thread: The program was terminated! :(((\n");
			break;

		case 0x4:
			printf("\n WRITE Thread: Timeout is occured :(((\n");
			break;

		case 0x5:
			printf("\n WRITE Thread: START_WRITE() --> Bad :(((\n");
			break;

		case 0x6:
			printf("\n WRITE Thread: STOP_WRITE() --> Bad! :(((\n");
			break;

		case 0x7:
			printf("\n WRITE Thread: Can't complete input and output (I/O) operations! :(((");
			break;

		default:
			printf("\n WRITE Thread: Unknown error! :(((\n");
			break;
	}

	return;
}

//------------------------------------------------------------------------
//   ,  ,    
//------------------------------------------------------------------------
void TerminateApplication(char *ErrorString, bool TerminationFlag)
{
	//   
	if(pModule)
	{
		//   
		if(!pModule->ReleaseInstance()) printf(" ReleaseInstance() --> Bad\n");
		else printf(" ReleaseInstance() --> OK\n");
		//     
		pModule = NULL;
	}

	//   
	if(ReadBuffer) { delete[] ReadBuffer; ReadBuffer = NULL; }
	if(WriteBuffer) { delete[] WriteBuffer; WriteBuffer = NULL; }
	//     
	if(hReadThread) { CloseHandle(hReadThread); hReadThread = NULL; }
	//     
	if(hWriteThread) { CloseHandle(hWriteThread); hWriteThread = NULL; }
	//    
	if(hFile != INVALID_HANDLE_VALUE) { CloseHandle(hFile); hFile = INVALID_HANDLE_VALUE; }

	//   
	if(ErrorString) printf(ErrorString);

	//   -   
	if(TerminationFlag) exit(1);
	else return;
}

