//******************************************************************************
//           USB3000
//******************************************************************************
#include <stdio.h>
#include <conio.h>
#include <math.h>
#include "Rtusbapi.h"

//   
void TerminateApplication(char *ErrorString, bool TerminationFlag = true);
//       
BOOL WaitingForRequestCompleted(OVERLAPPED *ReadOv);
//     
void ShowThreadErrorMessage(void);

//   -   
const WORD MaxVirtualSoltsQuantity = 127;

//      
DWORD WINAPI ServiceReadThread(PVOID /*Context*/);
//   
HANDLE hReadThread;
DWORD ReadTid;

//      
HANDLE hFile;
DWORD FileBytesWritten;

//    Rtusbapi.dll
DWORD DllVersion;
//    
IRTUSB3000 *pModule;
//  
char ModuleName[10];
//  
HANDLE ModuleHandle;
//    USB
BYTE UsbSpeed;
//   
char ModuleSerialNumber[9];
//   AVR
char AvrVersion[5];
// ,      DSP
RTUSB3000::DSP_INFO di;
//     
RTUSB3000::FLASH fi;
//    
RTUSB3000::INPUT_PARS ip;

// -   
const WORD CHANNELS_QUANTITY = 0x4;
//    
const double ReadRate = 3000.0;

//max  -   ( 32)  . ReadData  WriteData()
DWORD DataStep = 1024*1024;
//    DataStep     
const WORD NBlockRead = 50;
//      
SHORT	*ReadBuffer;

//  -
DWORD Counter = 0x0, OldCounter = 0xFFFFFFFF;

//       
WORD ThreadErrorNumber;
//     
bool IsThreadComplete = false;

//------------------------------------------------------------------------
//  
//------------------------------------------------------------------------
void main(void)
{
	WORD i;

	//       
	ReadBuffer = NULL;
	//      
	hReadThread = NULL;
	//     :(
	hFile = INVALID_HANDLE_VALUE;
	//      
	ThreadErrorNumber = 0x0;

	//   
	clrscr();

	printf(" **********************************************\n");
	printf(" Data Reading Console Example for USB3000 unit \n");
	printf(" **********************************************\n\n");

	//     Rtusbapi.dll
	if((DllVersion = RtGetDllVersion()) != CURRENT_VERSION_RTUSBAPI)
	{
		char String[128];
		sprintf(String, " Rtusbapi.dll Version Error!!!\n   Current: %1u.%1u. Required: %1u.%1u",
											DllVersion >> 0x10, DllVersion & 0xFFFF,
											CURRENT_VERSION_RTUSBAPI >> 0x10, CURRENT_VERSION_RTUSBAPI & 0xFFFF);

		TerminateApplication(String);
	}
	else printf(" Rtusbapi.dll Version --> OK\n");

	//      USB3000
	pModule = static_cast<IRTUSB3000 *>(RtCreateInstance("usb3000"));
	if(!pModule) TerminateApplication(" Module Interface --> Bad\n");
	else printf(" Module Interface --> OK\n");

	//    USB3000   127  
	for(i = 0x0; i < MaxVirtualSoltsQuantity; i++) if(pModule->OpenDevice(i)) break;
	// - ?
	if(i == MaxVirtualSoltsQuantity) TerminateApplication(" Can't find module USB3000 in first 127 virtual slots!\n");
	else printf(" OpenDevice(%u) --> OK\n", i);

	//    (handle) 
	ModuleHandle = pModule->GetModuleHandle();
	if(ModuleHandle == INVALID_HANDLE_VALUE) TerminateApplication(" GetModuleHandle() --> Bad\n");
	else printf(" GetModuleHandle() --> OK\n");

	//    
	if(!pModule->GetModuleName(ModuleName)) TerminateApplication(" GetModuleName() --> Bad\n");
	else printf(" GetModuleName() --> OK\n");
	// ,   'USB3000'
	if(strcmp(ModuleName, "USB3000")) TerminateApplication(" The module is not 'USB3000'\n");
	else printf(" The module is 'USB3000'\n");

	//      USB20
	if(!pModule->GetUsbSpeed(&UsbSpeed)) { printf(" GetUsbSpeed() --> Bad\n"); exit(1); }
	else printf(" GetUsbSpeed() --> OK\n");
	//     AVR
	printf(" USB Speed is %s\n", UsbSpeed ? "HIGH (480 Mbit/s)" : "FULL (12 Mbit/s)");

	//    
	if(!pModule->GetModuleSerialNumber(ModuleSerialNumber)) TerminateApplication(" GetModuleSerialNumber() --> Bad\n");
	else printf(" GetModuleSerialNumber() --> OK\n");
	//     
	printf(" Module Serial Number is %s\n", ModuleSerialNumber);

	//    AVR
	if(!pModule->GetAvrVersion(AvrVersion)) TerminateApplication(" GetAvrVersion() --> Bad\n");
	else printf(" GetAvrVersion() --> OK\n");
	//     AVR
	printf(" Avr Driver Version is %s\n", AvrVersion);

	//   DSP      DLL 
	if(!pModule->LOAD_DSP()) TerminateApplication(" LOAD_DSP() --> Bad\n");
	else printf(" LOAD_DSP() --> OK\n");

	//   
 	if(!pModule->MODULE_TEST()) TerminateApplication(" MODULE_TEST() --> Bad\n");
	else printf(" MODULE_TEST() --> OK\n");

	//     DSP
	if(!pModule->GET_DSP_INFO(&di)) TerminateApplication(" GET_DSP_INFO() --> Bad\n");
	else printf(" GET_DSP_INFO() --> OK\n");
	//      DSP
	printf(" DSP Driver version is %1u.%1u\n", di.DspMajor, di.DspMinor);

	//    size  RTUSB3000::FLASH
	fi.size = sizeof(RTUSB3000::FLASH);
	//     
	if(!pModule->GET_FLASH(&fi)) TerminateApplication(" GET_FLASH() --> Bad\n");
	else printf(" GET_FLASH() --> OK\n");

	//    size  RTUSB3000::INPUT_PARS
	ip.size = sizeof(RTUSB3000::INPUT_PARS);
	//     
	if(!pModule->GET_INPUT_PARS(&ip)) TerminateApplication(" GET_INPUT_PARS() --> Bad\n");
	else printf(" GET_INPUT_PARS() --> OK\n");

	//     
	ip.CorrectionEnabled = true;							//   
	ip.InputClockSource = RTUSB3000::INTERNAL_INPUT_CLOCK;	//        
//	ip.InputClockSource = RTUSB3000::EXTERNAL_INPUT_CLOCK;	//        
	ip.SynchroType = RTUSB3000::NO_SYNCHRO;			//        
//	ip.SynchroType = RTUSB3000::TTL_START_SYNCHRO;	//        
	ip.ChannelsQuantity = CHANNELS_QUANTITY; 			//   
	for(i = 0x0; i < ip.ChannelsQuantity; i++) ip.ControlTable[i] = (WORD)(i);
	ip.InputRate = ReadRate;								//     
	ip.InterKadrDelay = 0.0;								//   -     0.0
	ip.InputFifoBaseAddress = 0x0;  						//   FIFO     DSP
	ip.InputFifoLength = 0x3000;	 						//  FIFO     DSP
	//     ,     
	for(i = 0x0; i < 0x8; i++) { ip.AdcOffsetCoef[i] = fi.AdcOffsetCoef[i]; ip.AdcScaleCoef[i] = fi.AdcScaleCoef[i]; }
	//       
	if(!pModule->SET_INPUT_PARS(&ip)) TerminateApplication(" SET_INPUT_PARS() --> Bad\n");
	else printf(" SET_INPUT_PARS() --> OK\n");

	//          
	ReadBuffer = new SHORT[NBlockRead * DataStep];
	if(!ReadBuffer) TerminateApplication(" Cannot allocate memory for data buffer\n");

	//        
	hFile = CreateFile("Test.dat", GENERIC_WRITE, 0, NULL, CREATE_ALWAYS,
		FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN | FILE_FLAG_WRITE_THROUGH, NULL);
	if(hFile == INVALID_HANDLE_VALUE) TerminateApplication("\n Can't create file 'Test.dat'!\n");

	//       
	hReadThread = CreateThread(0, 0x2000, ServiceReadThread, 0x0, 0x0, &ReadTid);
	if(!hReadThread) TerminateApplication(" ServiceReadThread() --> Bad\n");
	else printf(" ServiceReadThread() --> OK\n");

	//       
	printf(" \n");
	printf(" Module USB3000 (S/N %s) is ready ... \n", ModuleSerialNumber);
	printf(" Adc parameters:\n");
	printf("   InputClockSource is %s\n", ip.InputClockSource ? "EXTERNAL" : "INTERNAL");
	printf("   SynchroType is %s\n", ip.SynchroType ? "TTL_START_SYNCHRO" : "NO_SYNCHRO");
	printf("   ChannelsQuantity = %2d\n", ip.ChannelsQuantity);
	printf("   AdcRate = %8.2f kHz\n", ip.InputRate);
	printf("   InterKadrDelay = %8.5f ms\n", ip.InterKadrDelay);
	printf("   ChannelRate = %8.2f kHz\n", ip.ChannelRate);

	//     
	printf("\n");
	while(!IsThreadComplete)
	{
		if(OldCounter != Counter) { printf(" Counter %3u from %3u\r", Counter, NBlockRead); OldCounter = Counter; }
		else Sleep(20);
	}

	//      
	WaitForSingleObject(hReadThread, INFINITE);

	//    -   
	printf("\n\n");
	if(ThreadErrorNumber) { TerminateApplication(NULL, false); ShowThreadErrorMessage(); }
	else { printf("\n"); TerminateApplication("\n The program was completed successfully!!!\n", false); }
}

//------------------------------------------------------------------------
//          
//------------------------------------------------------------------------
DWORD WINAPI ServiceReadThread(PVOID /*Context*/)
{
	WORD RequestNumber;
	WORD i;
	//     
	HANDLE ReadEvent[2];
	//  OVERLAPPED    
	OVERLAPPED ReadOv[2];
	DWORD BytesTransferred[2];
//	DWORD TimeOut;

	//         bulk USB
	if(!pModule->STOP_READ()) { ThreadErrorNumber = 0x6; IsThreadComplete = true; return 0x0; }

	//   
	ReadEvent[0] = CreateEvent(NULL, FALSE , FALSE, NULL);
	memset(&ReadOv[0], 0, sizeof(OVERLAPPED)); ReadOv[0].hEvent = ReadEvent[0];
	ReadEvent[1] = CreateEvent(NULL, FALSE , FALSE, NULL);
	memset(&ReadOv[1], 0, sizeof(OVERLAPPED)); ReadOv[1].hEvent = ReadEvent[1];

	//   
//	TimeOut = DataStep/ReadRate + 1000;

	//      
	RequestNumber = 0x0;
	if(!pModule->ReadData(ReadBuffer, &DataStep, &BytesTransferred[RequestNumber], &ReadOv[RequestNumber]))
				if(GetLastError() != ERROR_IO_PENDING) { CloseHandle(ReadEvent[0]); CloseHandle(ReadEvent[1]); ThreadErrorNumber = 0x2; IsThreadComplete = true; return 0x0; }

	//    
	if(pModule->START_READ())
	{
		//   
		for(i = 0x1; i < NBlockRead; i++)
		{
			RequestNumber ^= 0x1;
			//      
			if(!pModule->ReadData(ReadBuffer + i*DataStep, &DataStep, &BytesTransferred[RequestNumber], &ReadOv[RequestNumber]))
					if(GetLastError() != ERROR_IO_PENDING) { ThreadErrorNumber = 0x2; break; }

			//       
			if(!WaitingForRequestCompleted(&ReadOv[RequestNumber^0x1])) break;
//			if(WaitForSingleObject(ReadEvent[RequestNumber^0x1], TimeOut) == WAIT_TIMEOUT)
//				            		{ ThreadErrorNumber = 0x3; break; }
			if(ThreadErrorNumber) break;

			//      
			if(!WriteFile(	hFile,													// handle to file to write to
		    					ReadBuffer + (RequestNumber^0x1)*DataStep,  	// pointer to data to write to file
								2*DataStep,	 											// number of bytes to write
	    						&FileBytesWritten,									// pointer to number of bytes written
						   	NULL			  											// pointer to structure needed for overlapped I/O
							   )) { ThreadErrorNumber = 0x4; break; }

			if(ThreadErrorNumber) break;
			else if(kbhit()) { ThreadErrorNumber = 0x1; break; }
			else Sleep(20);
			Counter++;
		}
		//       
		if(!ThreadErrorNumber)
		{
			RequestNumber ^= 0x1;
//			if(WaitForSingleObject(ReadEvent[RequestNumber^0x1], TimeOut) == WAIT_TIMEOUT) ThreadErrorNumber = 0x3;
			if(WaitingForRequestCompleted(&ReadOv[RequestNumber^0x1]))
			{
				//      
				if(!WriteFile(	hFile,													// handle to file to write to
		    					ReadBuffer + (RequestNumber^0x1)*DataStep,  	// pointer to data to write to file
								2*DataStep,	 											// number of bytes to write
	    						&FileBytesWritten,									// pointer to number of bytes written
						   	NULL			  											// pointer to structure needed for overlapped I/O
							   )) ThreadErrorNumber = 0x4;
				Counter++;
			}            
		}
	}
	else { ThreadErrorNumber = 0x5; }

	//   
	if(!pModule->STOP_READ()) ThreadErrorNumber = 0x6;
	//        
	if(!CancelIo(ModuleHandle)) { ThreadErrorNumber = 0x7; }
	//    
	for(i = 0x0; i < 0x2; i++) CloseHandle(ReadEvent[i]);
	//  
	Sleep(100);
	//      
	IsThreadComplete = true;
	//      
	return 0;
}

//---------------------------------------------------------------------------
//
//---------------------------------------------------------------------------
BOOL WaitingForRequestCompleted(OVERLAPPED *ReadOv)
{
	DWORD ReadBytesTransferred;

	while(TRUE)
	{
		if(GetOverlappedResult(ModuleHandle, ReadOv, &ReadBytesTransferred, FALSE)) break;
		else if(GetLastError() !=  ERROR_IO_INCOMPLETE) { ThreadErrorNumber = 0x3; return FALSE; }
		else if(kbhit()) { ThreadErrorNumber = 0x1; return FALSE; }
		else Sleep(20);
	}
	return TRUE;
}

//------------------------------------------------------------------------
//         
//------------------------------------------------------------------------
void ShowThreadErrorMessage(void)
{
	switch(ThreadErrorNumber)
	{
		case 0x0:
			break;

		case 0x1:
			//     ,   
			printf("\n READ Thread: The program was terminated! :(((\n");
			break;

		case 0x2:
			printf("\n READ Thread: ReadData() --> Bad :(((\n");
			break;

		case 0x3:
			printf("\n READ Thread: Read Request --> Bad :(((\n");
//			printf("\n READ Thread: Timeout is occured :(((\n");
			break;

		case 0x4:
			printf("\n READ Thread: Writing file error!\n");
			break;

		case 0x5:
			printf("\n READ Thread: START_READ() --> Bad :(((\n");
			break;

		case 0x6:
			printf("\n READ Thread: STOP_READ() --> Bad! :(((\n");
			break;

		case 0x7:
			printf("\n READ Thread: Can't complete input and output (I/O) operations! :(((");
			break;

		default:
			printf("\n READ Thread: Unknown error! :(((\n");
			break;
	}

	return;
}

//------------------------------------------------------------------------
//   ,  ,    
//------------------------------------------------------------------------
void TerminateApplication(char *ErrorString, bool TerminationFlag)
{
	//   
	if(pModule)
	{
		//   
		if(!pModule->ReleaseInstance()) printf(" ReleaseInstance() --> Bad\n");
		else printf(" ReleaseInstance() --> OK\n");
		//     
		pModule = NULL;
	}

	//   
	if(ReadBuffer) { delete[] ReadBuffer; ReadBuffer = NULL; }
	//     
	if(hReadThread) { CloseHandle(hReadThread); hReadThread = NULL; }
	//    
	if(hFile != INVALID_HANDLE_VALUE) { CloseHandle(hFile); hFile = INVALID_HANDLE_VALUE; }

	//   
	if(ErrorString) printf(ErrorString);

	//   -   
	if(TerminationFlag) exit(1);
	else return;
}

