//******************************************************************************
//        USB3000
//      - (master-slave)
//******************************************************************************
#include <stdio.h>
#include <conio.h>
#include <math.h>
#include "Rtusbapi.h"


//    
void TerminateApplication(char *ErrorString = NULL);
//    
DWORD WINAPI ServiceReadThread(PVOID ThreadIndex);

const WORD CHANNELS_QUANTITY 		= 0x2;
//   -   
const WORD MAX_DEVICE_QUANTITY	= 0x10;

//  
HANDLE 	hReadThread[MAX_DEVICE_QUANTITY];
WORD 		ThreadIndex[MAX_DEVICE_QUANTITY];
DWORD 	ReadTid[MAX_DEVICE_QUANTITY];

//       USB3000
IRTUSB3000 *pModule[MAX_DEVICE_QUANTITY];
//  
char ModuleName[10];
//    USB
BYTE UsbSpeed;
//   
char ModuleSerialNumber[9];
//   AVR
char AvrVersion[5];
// ,      DSP
RTUSB3000::DSP_INFO di;
//     
RTUSB3000::FLASH fi;
//    
RTUSB3000::INPUT_PARS ip;
// -  
WORD ModuleQuantity;

//    
DWORD DataStep = 1024*1024;
//  
SHORT *Buffer[MAX_DEVICE_QUANTITY];
//    
bool IsThreadTerminated[MAX_DEVICE_QUANTITY];

//         
WORD ThreadErrorNumber[MAX_DEVICE_QUANTITY];
//     
WORD ErrorNumber;

//     
WORD XCoordCounter, YCoordCounter;
//  
WORD Counter[MAX_DEVICE_QUANTITY];
//  
CRITICAL_SECTION cs;

//------------------------------------------------------------------------
//  
//------------------------------------------------------------------------
void main(void)
{
	WORD i, j;

	//   
	clrscr();

	printf(" ***************************************\n");
	printf(" Console example for Multi USB3000		\n");
	printf(" ***************************************\n\n");

	//   
	InitializeCriticalSection(&cs);

	//    DLL 
	if(RtGetDllVersion() != CURRENT_VERSION_RTUSBAPI) TerminateApplication(" Dll Version Error!!!\n");
	else printf(" Dll Version --> OK\n");

	printf("\n USB3000 modules List:\n");
	//    
	ModuleQuantity = 0x0;
	//   MAX_DEVICE_QUANTITY       USB3000
	for(i = 0x0; i < MAX_DEVICE_QUANTITY; i++)
	{
		//    
		pModule[i] = NULL;
		//    
		pModule[i] = static_cast<IRTUSB3000 *>(RtCreateInstance("usb3000"));
		if(!pModule[i]) TerminateApplication(" Module Interface --> Bad\n");
		//   -     
		else if(!pModule[i]->OpenDevice(i))  { pModule[i]->ReleaseDevice(); pModule[i] = NULL; continue; }
		//       
		else if(!pModule[i]->GetModuleName(ModuleName)) TerminateApplication(" GetModuleName() --> Bad\n");
		// ,   USB3000
		else if(strcmp(ModuleName, "USB3000")) TerminateApplication(" The detected module is not USB3000. The appication is terminated.\n");
		//    USB
		else if(!pModule[i]->GetUsbSpeed(&UsbSpeed)) TerminateApplication(" GetUsbSpeed() --> Bad\n");
		//     
		else if(!pModule[i]->GetModuleSerialNumber(ModuleSerialNumber)) TerminateApplication(" GetModuleSerialNumber() --> Bad\n");
		//   DSP   DLL
		else if(!pModule[i]->LOAD_DSP()) TerminateApplication(" LOAD_LBIOS() --> Bad\n");
		//   
	 	else if(!pModule[i]->MODULE_TEST()) TerminateApplication(" MODULE_TEST() --> Bad\n");
		//    LBIOS
		else if(!pModule[i]->GET_DSP_INFO(&di)) TerminateApplication(" GET_DSP_INFO() --> Bad\n");

		//    size  RTUSB3000::FLASH
		fi.size = sizeof(RTUSB3000::FLASH);
		//     
		if(!pModule[i]->GET_FLASH(&fi)) TerminateApplication(" GET_FLASH() --> Bad\n");

		//    size  RTUSB3000::INPUT_PARS
		ip.size = sizeof(RTUSB3000::INPUT_PARS);
		//     
		if(!pModule[i]->GET_INPUT_PARS(&ip)) TerminateApplication(" GET_INPUT_PARS() --> Bad\n");

		//    
		ip.CorrectionEnabled = true;				  		//   
		//          (master), .
		//        
		if(i == 0x0) ip.InputClockSource = RTUSB3000::INTERNAL_INPUT_CLOCK;
		//         (slave), .
		//        
		else ip.InputClockSource = RTUSB3000::EXTERNAL_INPUT_CLOCK;
		ip.SynchroType = RTUSB3000::NO_SYNCHRO;  		//    
		ip.ChannelsQuantity = CHANNELS_QUANTITY; 		// -  
		for(j = 0x0; j < CHANNELS_QUANTITY; j++) ip.ControlTable[j] = (WORD)(j);
		ip.InputRate = 3000.0;						 		//     
		ip.InterKadrDelay = 0.0;
		//     ,     
		for(j = 0x0; j < 0x8; j++) { ip.AdcOffsetCoef[j] = fi.AdcOffsetCoef[j]; ip.AdcScaleCoef[j] = fi.AdcScaleCoef[j]; }
		//       
		if(!pModule[i]->SET_INPUT_PARS(&ip)) TerminateApplication(" SET_INPUT_PARS() --> Bad\n");

		//     
		Buffer[i] = NULL;
		Buffer[i] = new SHORT[2*DataStep];
		if(!Buffer[i]) TerminateApplication(" Cannot allocate buffer memory.\n");

		//    
		ModuleQuantity++;
		printf("   %2u. Virtual Slot %2u. Module (S/N %s, %s) is ready ... \n", ModuleQuantity, i, fi.SerialNumber, UsbSpeed ? "HIGH-SPEED (480 Mbit/s)" : "FULL-SPEED (12 Mbit/s)");
	}

	// :    -?
	if(!ModuleQuantity) { printf("   Empty...\n");  TerminateApplication("\n Can't detect any USB3000 module  :(((\n"); }

	//   
	XCoordCounter = (WORD)wherex();
	YCoordCounter = (WORD)wherey(); YCoordCounter += (WORD)0x2;

	//
	ErrorNumber = 0x0;
	for(WORD i=0; i < MAX_DEVICE_QUANTITY; i++)
	{
		//   
		ThreadErrorNumber[i] = 0x0;
		IsThreadTerminated[i] = false;

		//      
		if(!pModule[i]) continue;
		ThreadIndex[i] = i;
		hReadThread[i] = CreateThread(0, 0x2000, ServiceReadThread, &ThreadIndex[i], 0, &ReadTid[i]);
		if(!hReadThread[i]) TerminateApplication("\n CreateThread() --> Bad\n");
	}

	//          
	printf("\n  Press any key to terminate the program ...\n");
	while(true)
	{
		if(kbhit()) { ErrorNumber = 0x1; break; }
		Sleep(100);
	}

	//   
	if(ModuleQuantity) gotoxy(XCoordCounter, YCoordCounter + ModuleQuantity + 0x2);
	else printf("\n\n");
	//     ,   
	if(ErrorNumber == 0x1) printf(" The program was successfully terminated!\n");

	//   
	TerminateApplication();
}

//------------------------------------------------------------------------
//    
//------------------------------------------------------------------------
void TerminateApplication(char *ErrorString)
{
	WORD i;

	if(ErrorString) printf(ErrorString);

	//   
	for(i = 0x0; i < MAX_DEVICE_QUANTITY; i++)
	{
		if(hReadThread[i] != NULL)
		{
			//   
			IsThreadTerminated[i] = true;
			//     
			WaitForSingleObject(hReadThread[i], INFINITE);
			//    
			CloseHandle(hReadThread[i]);
		}
		//   
		if(Buffer[i]) { delete[] Buffer[i]; Buffer[i] = NULL; }
		//  
		if(pModule[i]) { pModule[i]->ReleaseDevice(); pModule[i] = NULL; }
		//      -     
//		if(!ErrorNumber) { if(ThreadErrorNumber[i]) ShowThreadErrorMessage(ThreadErrorNumber[i], i); }
	}

	//   
	DeleteCriticalSection(&cs);

	if(ErrorString) exit(1);
	else return;
}

//------------------------------------------------------------------------
//      USB3000
//------------------------------------------------------------------------
DWORD WINAPI ServiceReadThread(PVOID ThreadIndex)
{
	//  
	WORD RequestNumber;
	//      
	WORD ti = *(WORD *)ThreadIndex;
	//     
	HANDLE ReadEvent[2];
	//  OVERLAPPED    
	OVERLAPPED ReadOv[2];
	DWORD BytesTransferred[2];

	//         bulk USB
	if(pModule[ti]->STOP_READ())
	{
		//   
		ReadEvent[0] = CreateEvent(NULL, FALSE , FALSE, NULL);
		memset(&ReadOv[0], 0, sizeof(OVERLAPPED)); ReadOv[0].hEvent = ReadEvent[0];
		ReadEvent[1] = CreateEvent(NULL, FALSE , FALSE, NULL);
		memset(&ReadOv[1], 0, sizeof(OVERLAPPED)); ReadOv[1].hEvent = ReadEvent[1];

		//    
		EnterCriticalSection(&cs);
			gotoxy(XCoordCounter, YCoordCounter + 1*ti);
			printf("  Counter[%2u]: %8u", ti+0x1, Counter[ti] = 0x0);
		LeaveCriticalSection(&cs);

		//      
		RequestNumber = 0x0;
		if(!pModule[ti]->ReadData(Buffer[ti], &DataStep, &BytesTransferred[RequestNumber], &ReadOv[RequestNumber]))
				if(GetLastError() != ERROR_IO_PENDING) { ThreadErrorNumber[ti] = 0x2; goto ThreadFinish; }

		//    
		if(pModule[ti]->START_READ())
		{
			//   
			while(!IsThreadTerminated[ti])
			{
				//      
				RequestNumber ^= 0x1;
				if(!pModule[ti]->ReadData(Buffer[ti] + RequestNumber*DataStep, &DataStep, &BytesTransferred[RequestNumber], &ReadOv[RequestNumber]))
						if(GetLastError() != ERROR_IO_PENDING) { ThreadErrorNumber[ti] = 0x2; break; }

				//    
				while(true)
				{
					if(HasOverlappedIoCompleted(&ReadOv[RequestNumber^0x1])) break;
					else if(IsThreadTerminated[ti]) break;
					else Sleep(0);
				}

				//    
				Counter[ti]++;
				//        
				if(!ThreadErrorNumber[ti])
				{
					EnterCriticalSection(&cs);
						gotoxy(XCoordCounter, YCoordCounter + 1*ti);
						printf("  Counter[%2u]: %8u", ti+0x1, Counter[ti]);
					LeaveCriticalSection(&cs);
				}

				//   -     
				if(IsThreadTerminated[ti]) break;
				else if(ThreadErrorNumber[ti]) break;
				else Sleep(0);
			}
		}
		else ThreadErrorNumber[ti] = 0x4;
	}
	else ThreadErrorNumber[ti] = 0x6;

ThreadFinish:
	//   
	if(!pModule[ti]->STOP_READ()) ThreadErrorNumber[ti] = 0x6;
	//   
	if(!CancelIo(pModule[ti]->GetModuleHandle())) ThreadErrorNumber[ti] = 0x7;
	//   
	CloseHandle(ReadEvent[0]); CloseHandle(ReadEvent[1]);

	//        
	if(ThreadErrorNumber[ti])
	{
		EnterCriticalSection(&cs);
			gotoxy(XCoordCounter, YCoordCounter + 1*ti);
			printf("  Counter[%2u]: Thread Error!", ti+0x1, Counter[ti]);
		LeaveCriticalSection(&cs);
	}

	return 0x0;							//   
}

