#include <stdio.h>
#include <conio.h>
#include <math.h>
#include "Rtusbapi.h"

//   
void TerminateApplication(char *ErrorString, bool TerminationFlag = true);

//   -   
const WORD MaxVirtualSoltsQuantity = 127;

//    Rtusbapi.dll
DWORD DllVersion;
//    
IRTUSB3000 *pModule;
//  
char ModuleName[10];
//    USB
BYTE UsbSpeed;
//   
char ModuleSerialNumber[9];
//   AVR
char AvrVersion[5];
// ,      DSP
RTUSB3000::DSP_INFO di;
//     
RTUSB3000::FLASH fi;
//    
RTUSB3000::OUTPUT_PARS dp;
//       
SHORT DacSample;

UINT Temp;

//------------------------------------------------------------------------
//  
//------------------------------------------------------------------------
void main(void)
{
	WORD i;

	//   
	clrscr();

	printf(" *******************************************\n");
	printf(" Console example for USB3000 WRITE_SAMPLE() \n");
	printf(" *******************************************\n\n");

	//     Rtusbapi.dll
	if((DllVersion = RtGetDllVersion()) != CURRENT_VERSION_RTUSBAPI)
	{
		char String[128];
		sprintf(String, " Rtusbapi.dll Version Error!!!\n   Current: %1u.%1u. Required: %1u.%1u",
											DllVersion >> 0x10, DllVersion & 0xFFFF,
											CURRENT_VERSION_RTUSBAPI >> 0x10, CURRENT_VERSION_RTUSBAPI & 0xFFFF);

		TerminateApplication(String);
	}
	else printf(" Rtusbapi.dll Version --> OK\n");

	//      USB3000
	pModule = static_cast<IRTUSB3000 *>(RtCreateInstance("usb3000"));
	if(pModule == NULL)  TerminateApplication(" Module Interface --> Bad\n");
	else printf(" Module Interface --> OK\n");

	//    USB3000   127  
	for(i = 0x0; i < MaxVirtualSoltsQuantity; i++) if(pModule->OpenDevice(i)) break;
	// - ?
	if(i == MaxVirtualSoltsQuantity) TerminateApplication(" Can't find module USB3000 in first 127 virtual slots!\n");
	else printf(" OpenDevice(%u) --> OK\n", i);

	//       
	if(!pModule->GetModuleName(ModuleName)) TerminateApplication(" GetModuleName() --> Bad\n");
	else printf(" GetModuleName() --> OK\n");
	// ,   'USB3000'
	if(strcmp(ModuleName, "USB3000")) TerminateApplication(" The module is not 'USB3000'\n");
	else printf(" The module is 'USB3000'\n");

	//      USB20
	if(!pModule->GetUsbSpeed(&UsbSpeed)) { printf(" GetUsbSpeed() --> Bad\n"); exit(1); }
	else printf(" GetUsbSpeed() --> OK\n");
	//     AVR
	printf(" USB Speed is %s\n", UsbSpeed ? "HIGH (480 Mbit/s)" : "FULL (12 Mbit/s)");

	//    
	if(!pModule->GetModuleSerialNumber(ModuleSerialNumber)) TerminateApplication(" GetModuleSerialNumber() --> Bad\n");
	else printf(" GetModuleSerialNumber() --> OK\n");
	//     
	printf(" Module Serial Number is %s\n", ModuleSerialNumber);

	//    AVR
	if(!pModule->GetAvrVersion(AvrVersion)) TerminateApplication(" GetAvrVersion() --> Bad\n");
	else printf(" GetAvrVersion() --> OK\n");
	//     AVR
	printf(" Avr Driver Version is %s\n", AvrVersion);

	//   DSP      DLL 
	if(!pModule->LOAD_DSP()) TerminateApplication(" LOAD_DSP() --> Bad\n");
	else printf(" LOAD_DSP() --> OK\n");

	//   
 	if(!pModule->MODULE_TEST()) TerminateApplication(" MODULE_TEST() --> Bad\n");
	else printf(" MODULE_TEST() --> OK\n");

	//     DSP
	if(!pModule->GET_DSP_INFO(&di)) TerminateApplication(" GET_DSP_INFO() --> Bad\n");
	else printf(" GET_DSP_INFO() --> OK\n");
	//      DSP
	printf(" DSP Driver version is %1u.%1u\n", di.DspMajor, di.DspMinor);

	//    size  RTUSB3000::FLASH
	fi.size = sizeof(RTUSB3000::FLASH);
	//     
	if(!pModule->GET_FLASH(&fi)) TerminateApplication(" GET_FLASH() --> Bad\n");
	else printf(" GET_FLASH() --> OK\n");

	//       
	if(!fi.IsDacPresented) TerminateApplication("\n DAC is absent on this module USB3000!\n");

	//    size  OUTPUT_PARS
	dp.size = sizeof(RTUSB3000::OUTPUT_PARS);
	//     
	if(!pModule->GET_OUTPUT_PARS(&dp)) TerminateApplication(" GET_OUTPUT_PARS() --> Bad\n");
	else printf(" GET_OUTPUT_PARS() --> OK\n");

	//    
	dp.OutputRate = 100.0;			//  
	dp.OutputFifoLength = 0xF80;	// 0xF80(3968) -   FIFO    DSP 
	if(!pModule->SET_OUTPUT_PARS(&dp)) TerminateApplication(" SET_OUTPUT_PARS() --> Bad\n");
	else printf(" SET_OUTPUT_PARS() --> OK\n");

	//      
	printf(" \n");
	printf(" Module USB3000 (S/N %s) is ready ... \n", fi.SerialNumber);
	printf(" Dac parameters:\n");
	printf("   OutputRate = %7.2f kHz\n", dp.OutputRate);
	printf("   DacFifoLength = %d\n", dp.OutputFifoLength);
	printf("\n Now SINUS signal is on the first DAC channel and \n");
	printf("    -SINUS signal is on the second DAC channel.\n");
	printf("     (Press any key to terminate the program)\n");

	//     DAC_SAMPLE().
	//         ,
	//        -.
	// ..         ;)
	double CurrentTime = 0.0;
	for(i = 0x0 ; ; i++)
	{
		DacSample = (SHORT)(2000*sin(2.*M_PI*2.5*CurrentTime));
		CurrentTime += 1.0/dp.OutputRate;

		//    - ,     
		if(kbhit()) break;
		//       
		else if(!pModule->WRITE_SAMPLE(WORD(0x0), &DacSample)) TerminateApplication(" WRITE_SAMPLE(0) --> Bad\n");

		Sleep(50);

		//       
		DacSample *= (SHORT)-1;
		if(!pModule->WRITE_SAMPLE(WORD(0x1), &DacSample)) TerminateApplication(" WRITE_SAMPLE(1) --> Bad\n");

		//     
		if(!(i%10))
		{
			static flag;

			flag ^= -0x1;
			if(flag) printf("                                             \r");
			else printf(" ............................................\r");
		}
	}

	//        
	DacSample = (SHORT)(0x0);
	if(!pModule->WRITE_SAMPLE(WORD(0x0), &DacSample)) printf(" WRITE_SAMPLE(0) --> Bad\n");
	else if(!pModule->WRITE_SAMPLE(WORD(0x1), &DacSample)) printf(" WRITE_SAMPLE(1) --> Bad\n");

	//   
	printf("                                             \n");
	TerminateApplication("\n The program was completed successfully!!!\n", false);
}

//------------------------------------------------------------------------
//         
//------------------------------------------------------------------------
void TerminateApplication(char *ErrorString, bool TerminationFlag)
{
	//   
	if(pModule)
	{
		//   
		if(!pModule->ReleaseInstance()) printf(" ReleaseInstance() --> Bad\n");
		else printf(" ReleaseInstance() --> OK\n");
		//     
		pModule = NULL;
	}

	//   
	if(ErrorString) printf(ErrorString);

	//   -   
	if(TerminationFlag) exit(1);
	else return;
}

