//******************************************************************************
//     USB3000       
//   READ_SAMPLE().
//       .
//******************************************************************************
#include <stdio.h>
#include <conio.h>
#include "Rtusbapi.h"

//   
void TerminateApplication(char *ErrorString, bool TerminationFlag = true);

//   -   
const WORD MaxVirtualSoltsQuantity = 127;

//    Rtusbapi.dll
DWORD DllVersion;
//    
IRTUSB3000 *pModule;
//  
char ModuleName[10];
//    USB
BYTE UsbSpeed;
//   
char ModuleSerialNumber[9];
//   AVR
char AvrVersion[5];
// ,      DSP
RTUSB3000::DSP_INFO di;
//     
RTUSB3000::FLASH fi;
//    
RTUSB3000::INPUT_PARS ip;

// -       
const WORD CHANNELS_QUANTITY = 0x4;
//    
const double ReadRate = 3000.0;

//  
SHORT AdcSample1, AdcSample2;

//------------------------------------------------------------------------
//  
//------------------------------------------------------------------------
void main(void)
{
	WORD i;

	//   
	clrscr();

	printf(" *****************************************\n");
	printf(" Console example for USB3000 READ_SAMPLE()\n");
	printf(" *****************************************\n\n");

	//     Rtusbapi.dll
	if((DllVersion = RtGetDllVersion()) != CURRENT_VERSION_RTUSBAPI)
	{
		char String[128];
		sprintf(String, " Rtusbapi.dll Version Error!!!\n   Current: %1u.%1u. Required: %1u.%1u",
											DllVersion >> 0x10, DllVersion & 0xFFFF,
											CURRENT_VERSION_RTUSBAPI >> 0x10, CURRENT_VERSION_RTUSBAPI & 0xFFFF);

		TerminateApplication(String);
	}
	else printf(" Rtusbapi.dll Version --> OK\n");

	//      USB3000
	pModule = static_cast<IRTUSB3000 *>(RtCreateInstance("usb3000"));
	if(pModule == NULL)  TerminateApplication(" Module Interface --> Bad\n");
	else printf(" Module Interface --> OK\n");

	//    USB3000   127  
	for(i = 0x0; i < MaxVirtualSoltsQuantity; i++) if(pModule->OpenDevice(i)) break;
	// - ?
	if(i == MaxVirtualSoltsQuantity) TerminateApplication(" Can't find module USB3000 in first 127 virtual slots!\n");
	else printf(" OpenDevice(%u) --> OK\n", i);

	//       
	if(!pModule->GetModuleName(ModuleName)) TerminateApplication(" GetModuleName() --> Bad\n");
	else printf(" GetModuleName() --> OK\n");
	// ,   'USB3000'
	if(strcmp(ModuleName, "USB3000")) TerminateApplication(" The module is not 'USB3000'\n");
	else printf(" The module is 'USB3000'\n");

	//      USB20
	if(!pModule->GetUsbSpeed(&UsbSpeed)) { printf(" GetUsbSpeed() --> Bad\n"); exit(1); }
	else printf(" GetUsbSpeed() --> OK\n");
	//     AVR
	printf(" USB Speed is %s\n", UsbSpeed ? "HIGH (480 Mbit/s)" : "FULL (12 Mbit/s)");

	//    
	if(!pModule->GetModuleSerialNumber(ModuleSerialNumber)) TerminateApplication(" GetModuleSerialNumber() --> Bad\n");
	else printf(" GetModuleSerialNumber() --> OK\n");
	//     
	printf(" Module Serial Number is %s\n", ModuleSerialNumber);

	//    AVR
	if(!pModule->GetAvrVersion(AvrVersion)) TerminateApplication(" GetAvrVersion() --> Bad\n");
	else printf(" GetAvrVersion() --> OK\n");
	//     AVR
	printf(" Avr Driver Version is %s\n", AvrVersion);

	//   DSP      DLL 
	if(!pModule->LOAD_DSP()) TerminateApplication(" LOAD_DSP() --> Bad\n");
	else printf(" LOAD_DSP() --> OK\n");

	//   
 	if(!pModule->MODULE_TEST()) TerminateApplication(" MODULE_TEST() --> Bad\n");
	else printf(" MODULE_TEST() --> OK\n");

	//     DSP
	if(!pModule->GET_DSP_INFO(&di)) TerminateApplication(" GET_DSP_INFO() --> Bad\n");
	else printf(" GET_DSP_INFO() --> OK\n");
	//      DSP
	printf(" DSP Driver version is %1u.%1u\n", di.DspMajor, di.DspMinor);

	//    size  RTUSB3000::FLASH
	fi.size = sizeof(RTUSB3000::FLASH);
	//     
	if(!pModule->GET_FLASH(&fi)) TerminateApplication(" GET_FLASH() --> Bad\n");
	else printf(" GET_FLASH() --> OK\n");

	//    size  RTUSB3000::INPUT_PARS
	ip.size = sizeof(RTUSB3000::INPUT_PARS);
	//     
	if(!pModule->GET_INPUT_PARS(&ip)) TerminateApplication(" GET_INPUT_PARS() --> Bad\n");
	else printf(" GET_INPUT_PARS() --> OK\n");

	//     
	// !!!           DSP
	//  ,    
	//    !!!
	ip.CorrectionEnabled = true;				  			//   
	ip.InputClockSource = RTUSB3000::INTERNAL_INPUT_CLOCK;	//        
//	ip.InputClockSource = RTUSB3000::EXTERNAL_INPUT_CLOCK;	//        
	ip.SynchroType = RTUSB3000::NO_SYNCHRO;			//        
//	ip.SynchroType = RTUSB3000::TTL_START_SYNCHRO;	//        
	ip.ChannelsQuantity = CHANNELS_QUANTITY; 			//   
	for(i = 0x0; i < CHANNELS_QUANTITY; i++) ip.ControlTable[i] = (WORD)(i);
	ip.InputRate = ReadRate;							 	//     
	ip.InterKadrDelay = 0.0;
	//     ,     
	for(i = 0x0; i < 8; i++) { ip.AdcOffsetCoef[i] = fi.AdcOffsetCoef[i]; ip.AdcScaleCoef[i] = fi.AdcScaleCoef[i]; }
	//       
	if(!pModule->SET_INPUT_PARS(&ip)) TerminateApplication(" SET_INPUT_PARS() --> Bad\n");
	else printf(" SET_INPUT_PARS() --> OK\n");

	//      
	printf(" \n");
	printf(" Module USB3000 (S/N %s) is ready ... \n", fi.SerialNumber);
	printf("   Data Correction is %s\n", ip.CorrectionEnabled ? "enabled" : "disabled");

	printf("\n Press any key to terminate this program...\n");
	//     ADC_SAMPLE 
	//      
	printf("\n\n");
	printf(" ADC Channel:                     1         2\n");
	while(!kbhit())
	{
		if(!pModule->READ_SAMPLE((WORD)(0x00), &AdcSample1)) TerminateApplication("\n\n  READ_SAMPLE(0,) --> Bad\n");
		else if(!pModule->READ_SAMPLE((WORD)(0x01), &AdcSample2)) TerminateApplication("\n\n  READ_SAMPLE(1,) --> Bad\n");

		printf(" AdcSample Data (ADC code):     %5d     %5d\r", AdcSample1, AdcSample2);
	}

	//   
	printf("\n");
	TerminateApplication("\n The program was completed successfully!!!\n", false);
}

//------------------------------------------------------------------------
//   ,  ,    
//------------------------------------------------------------------------
void TerminateApplication(char *ErrorString, bool TerminationFlag)
{
	//   
	if(pModule)
	{ 
		//   
		if(!pModule->ReleaseInstance()) printf(" ReleaseInstance() --> Bad\n"); 
		else printf(" ReleaseInstance() --> OK\n");
		//     
		pModule = NULL; 
	}

	//   
	if(ErrorString) printf(ErrorString);

	//   -   
	if(TerminationFlag) exit(1);
	else return;
}

