{ ********************************************************************* }
{ ᭮ ணࠬ (ࠩ)  ࠡ  㫥 USB-3000				}
{ ********************************************************************* }
#include "Const.h"
.MODULE/ABS=ProgramBaseAddress/SEG=int_pm_user     main_program;
.ENTRY StartBios, Irq1Handler;

#include "Vars.h"

{ After DSP RESET we appear to be here                                  }
StartBios:
	DIS SEC_REG;  						{ ३    ॣ஢		}

{ I4, M4, L4 ᯮ  㯠  ६ ࠩ DSP			}
	M4 = 0x0; L4 = 0x0;
	M7 = 0x0; L7 = 0x0;

{ ନ㥬  TARGET																	}
	PutValPm(AR, 0x5355, TargetAddr + 0);
	PutValPm(AR, 0x3342, TargetAddr + 1);
	PutValPm(AR, 0x3030, TargetAddr + 2);
	PutValPm(AR, 0x0030, TargetAddr + 3);
	PutValPm(AR, 0x0000, TargetAddr + 4);

{ ନ㥬  LABEL																	}
	PutValPm(AR, 0x7452, LabelAddr + 0);
	PutValPm(AR, 0x6365, LabelAddr + 1);
	PutValPm(AR, 0x0068, LabelAddr + 2);

{ ନ㥬 ⥪  ࠩ DSP											}
	AR = VERMAJOR; SR = LSHIFT AR BY 8 (LO);
	AR = VERMINOR;	SR = SR OR LSHIFT AR BY 0 (LO);
	PutPm(SR0,VersionAddr);

{ 襬  ⮢ ६ 室 祭							}
	PutValPm(AR, 0x5555, TMode1Addr);
	PutValPm(AR, 0xAAAA, TMode2Addr);

{ Set Wait State for ALL External Devices                   				}
	AR = 0x000A;						{ 0000 0000 0000 1010 						}
	DM(Dm_Wait_Reg) = AR;			{ 0x3FFE - Waitstate Control Register 	}

{ SPORT0 - disable, SPORT1 - disable, SPORT1 - FI, FO, IRQ0, IRQ1, SCLK1}
	AR=0x0;
	DM(Sys_Ctrl_Reg)=AR;				{ 0x3FFF - System Control Register 		}

{ *********************************************************************	}
{ 	Set SPORT0 for data output															}
{ 	SCLK and Transmit Frame - internal, word = 16 bits                	}
{ 	Serial Clock Divide Modulus 														}
	GetPm(AR, Sclk0DivAddr);		{ SCLK0 period = 250.0 ns					}
	DM(Sport0_Sclkdiv) = AR;		{ 0x3FF5 - Serial Clock Divide Modulus	}

{ Receive Frame Sync Divide Modulus 												}
	GetPm(AR, OutputRateAddr);		{ ⠪⮢  뢮 			}
	DM(Sport0_Rfsdiv) = AR; { 0x3FF4 - Receive Frame Sync Divide Modulus }

{ 頥 ⮡ਧ SPORT0													}
	AR=0x4000;							{ 0100 0000 0000 0000						}
	DM(Sport0_Autobuf_Ctrl)=AR;

{ Control word for SPORT0 : SCLK - internal 										}
{ low level, alternate internal receive frame on each word(16 bit) 		}
{ low level, alternate external transmit frame on each word(16 bit)		}
	AR = 0x7DCF;						{ 0111 1110 1100 1111						}
	DM(Sport0_Ctrl_Reg) = AR;		{ 0x3FF6 - SPORT0 Control Register		}
{ *********************************************************************	}

{ *********************************************************************	}
{ * Set SPORT1 for data input (ADC or TTL)                 	 			*	}
{ Serial Clock Divide Modulus 														}
	GetPm(AR, InputRateAddr);	{   							}
	DM(Sport1_Sclkdiv) = AR;	{ 0x3FF1 - Serial Clock Divide Modulus		}

{ Receive Frame Sync Divide Modulus 												}
	AR = 0xF;					{ RFS period = 16 SCLK	 							}
	DM(Sport1_Rfsdiv) = AR;	{ 0x3FF0 - Receive Frame Sync Divide Modulus	}

{ Control word for SPORT1 : SCLK - external 										}
{ high level, alternate internal receive frame on each word(16 bit)		}
{ high level, alternate internal transmit frame on each word(16 bit)		}
	AR = 0x3F1F; 						{ 0011 1111 0001 1111 						}
	DM(Sport1_Ctrl_Reg) = AR;		{ 0x3FF2 - SPORT1 Control Register		}
{ *********************************************************************	}

{ IRQ0, IRQ1, IRQ2 - negative front, disable Interrupt Nesting 			}
	ICNTL = 0x07;

{ ⨬    뢠													}
	IFC = 0xFF; NOP;

{ ⠭ 䫠 FO  室  ﭨ									}
	RESET FLAG_OUT;

{ ⠭ 䫠 FLx  室  ﭨ								}
	RESET FL0, RESET FL1, RESET FL2;

{ ⠭ 䫠 PFx  室  ﭨ								}
	AR = 0x00; DM(Prog_Flag_Data) = AR;
{ ⠭ ࠢ 䫠 PFx: PF0,PF1,PF3,PF4  PF7 - 室, 	}
{				   						  PF2,PF5  PF6 - 室				}
	AR=0x64;	 									{	0110 0100							}
	DM(Prog_Flag_Comp_Sel_Ctrl)=AR;

{ ᨬ ᢥ⮤																	}
	AR = DM(Prog_Flag_Data); AR = SETBIT 2 OF AR; DM(Prog_Flag_Data) = AR;

{     ᥣ ⮫쪮 ADSP-2185, ..  ७  	}
	DMOVLAY = 0x0; PMOVLAY = 0x0;
{ 稬 ஡ ० 㬭⥫													}
	DIS M_MODE;

{ ந樠㥬 室 㪠⥫  ६						}
	CALL InitAdcInputPointers;
	CALL InitOutputPointers;

{   ᭮ ணࠬ,    ⮢  ࠡ	}
	PutValPm(AR, 0x1, ReadyAddr);

{ ᫨ 饭  ,   SCLK   㤥					}
	GetPm(AR, InputEnableAddr); NONE = PASS AR;
	IF EQ JUMP MainLoopEntry;

{ 稬 , ..ᤥ SCLK ७										}
	AR = 0x7F1F; 						{ 0111 1111 0001 1111 						}
	DM(Sport1_Ctrl_Reg) = AR;		{ 0x3FF2 - SPORT1 Control Register		}

{ =====================================================================	}
{ ᭮ 横 /뢮 													}
{ =====================================================================	}
MainLoopEntry:
{ ࠧ訬 ⮫쪮 室 뢠 											}
	GetPm(AR, ImaskValueAddr); IMASK = AR; NOP;

MainLoop:
{ । (᫨  ) ⮢   									}
	CALL PutInputData;
{  (᫨  㦭) ⮢   									}
	CALL GetOutputData;
{  뢮  																}	
	CALL CheckDacSample;
{ ⮪  㯨襩 												}
	CALL CommandProcessing;
{ ᪮ 横 ࠩ															}
	JUMP MainLoop;

{ *********************************************************************	}
{ 楤 । ⮢   FIFO    				}
{ *********************************************************************	}
PutInputData:
{    ࠧ襭?																}
	GetPm(AR, InputEnableAddr); NONE= PASS AR;
	IF EQ RTS;								{ ᫨ ,   멤			}

{     뫠   ?												}
	AR = I3;									{ 稬 '' FIFO 			}
	AY0 = I2;  								{ 稬 '墮' FIFO 			}
	AR = AR - AY0;
	GetPm(AY0, CurInputFifoLengthAddr);{ ⥪  FIFO  	}
	IF LT AR = AR + AY0;		{ ⥯  AR ⨭ ࠧ  I3  I2	}
	GetPm(AY0, InputFifoLengthOver2Addr);	{   FIFO  	}
	NONE = AR - AY0;    						{ ࠢ    		}
	IF LT RTS;								{ ᫨ ,  멤				}

{ ᫨  ⮢,  ᣥਬ ᮮ⢥饥 뢠  AVR		}
	AR = DM(Prog_Flag_Data); AR = SETBIT 5 OF AR; DM(Prog_Flag_Data) = AR;
	NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP;
	NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP;
	AR = CLRBIT 5 OF AR; DM(Prog_Flag_Data) = AR;
{ 㥬 㪠⥫  '墮' FIFO  							}
	MODIFY(I2, M2);

{ ᯮ 室  㭪樨															}
	RTS;

{ *********************************************************************	}
{ 楤 ਥ       							}
{ *********************************************************************	}
GetOutputData:
{  ࠡ  ࠧ襭?																}
	GetPm(AR, OutputEnableAddr); NONE= PASS AR;
	IF EQ RTS;								{ ᫨ ,   멤			}

{     ਭ   ?												}
	AR = I1;									{ 稬 '' FIFO 			}
	AY0 = I0;  								{ 稬 '墮' FIFO 				}
	AR = AR - AY0;
	GetPm(AY0, CurOutputFifoLengthAddr);{ ⥪  FIFO  	}
	IF LT AR = AR + AY0;		{ ⥯  AR ⨭ ࠧ  I3  I2	}
	GetPm(AY0, OutputFifoLengthOver2Addr);	{   FIFO  	}
	NONE = AR - AY0; 						{ ࠢ    		}
	IF LT RTS;								{ ᫨ ,  멤				}

{ ᫨ ⮢ ਭ    ,  ᣥਬ					}
{ 													ᮮ⢥饥 뢠  AVR	}
	AR = DM(Prog_Flag_Data); AR = SETBIT 6 OF AR; DM(Prog_Flag_Data) = AR;
	NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP;
	NOP; NOP; NOP; NOP; NOP; NOP; NOP; NOP;
	AR = CLRBIT 6 OF AR; DM(Prog_Flag_Data) = AR;

{ 㥬 㪠⥫  '墮' FIFO  							}
	MODIFY(I0, M0);

{ ᯮ 室  㭪樨															}
	RTS;

{ *********************************************************************	}
{ ஢ઠ 砭 ⭮ 뢮  									}
{ *********************************************************************	}
CheckDacSample:
{ 䫠 襭 뤠   											}
	AR = SB; NONE = PASS AR; IF EQ RTS;

{ ᪨㥬 뢠 SPORT0 Transmit()									}
	GetPm(AR,ImaskValueAddr);
	AR = CLRBIT 6 OF AR;				{  뢠 SPORT0 Transmit			}
	PutPm(AR,ImaskValueAddr);
	IMASK = AR; NOP;

{ ᨬ 䫠 襭 ⭮ 뤠   				}
	SB = 0x0;

{ থ窠  4 																	}
	CALL Delay2mks;
	CALL Delay2mks;

{ ⥯ 몫稬 SPORT0 ()														}
{ SPORT0 - disable, SPORT1 - disable, SPORT1 - FI, FO, IRQ0, IRQ1, SCLK1}
	AR = 0x0;
	DM(Sys_Ctrl_Reg) = AR;	  		{ 0x3FFF - System Control Register 		}

{ 訬 믮 	⭮ 뢮  						}
	JUMP EndOfCommand;

{ *********************************************************************	}
{ ࠡ稪 뢠 IRQ1 ( ᨭ஭)							}
{ *********************************************************************	}
Irq1Handler:
	ENA SEC_REG;			{ ३  ன  ॣ஢					}

{ ࠭ ॣ I4																	}
	AY0 = I4;

{ ࠧ訬 뢠 IRQE()  IRQ2()								}
	GetPm(AR, ImaskValueAddr);
	AR = CLRBIT 2 OF AR;				{ ⨬ 뢠 IRQ1(.ᨭ.)	}
	AR = SETBIT 4 OF AR;				{ ࠧ訬 뢠 IRQE()			}
	PutPm(AR, ImaskValueAddr);

{    ॣ IMASK   祭								}
	DIS INTS;
	POP STS;
	ENA SEC_REG;			{ ३  ன  ॣ஢					}

	IMASK = AR; NOP;

	DIS SEC_REG; 			{ ३    ॣ஢					}
	PUSH STS;
	IMASK = 0x0; NOP;

	ENA INTS;				{ ࠧ訬  뢠								}

	ENA SEC_REG;			{ ३  ன  ॣ஢					}

{ ⠭ 䫠,  ࠧ襭  										}
	PutValPm(AR, 0x1, InputEnableAddr);
{ ᬮਬ  筨 ⠪⮢ ᮢ 										}
	GetPm(AR, InputClockSourceAddr);
{ ⠭ ॣ I4																}
	I4 = AY0;
{ ⨬ , ஬ IRQ2()  SPORT0 Transmit (뢮)			}
	IFC = 0x3F; NOP;

{ ᫨ ᯮ㥬 譨 ⠪⮢  -  멤					}
	NONE = PASS AR; IF NE RTI;
	
{ ⨬  , 稢  SCLK1, .. ᤥ  ७	}
	AR = 0x7F1F; 						{ 0111 1111 0001 1111 						}
	DM(Sport1_Ctrl_Reg) = AR; 		{ 0x3FF2 - SPORT1 Control Register		}

{ ᯮ 室  뢠														}
	RTI;

{ ********************************************************************  }
{   																	}
{ ********************************************************************  }
CommandProcessing:
{ ஢ਬ   ࠡ⠭ ?										}
	AR = SE; NONE = PASS AR;
	IF EQ RTS; 							{ ᫨ ,   멤				}

{ ᨬ 䫠 ࠡ⠭ 											}
	SE = 0x0;

{ 㧭  ।  													}
	GetPm(AR, CommandAddr);	AR = PASS AR;
	IF EQ JUMP Test_cmd;       				{   0					}
	AR = AR-0x1;
	IF EQ JUMP Start_Read_cmd;			 		{   1					}
	AR = AR-0x1;
	IF EQ JUMP Stop_Read_cmd;			 		{   2					}
	AR = AR-0x1;
	IF EQ JUMP Read_Kadr_cmd;  				{   3					}
	AR = AR-0x1;
	IF EQ JUMP Read_Sample_cmd;  				{   4					}
	AR = AR-0x1;
	IF EQ JUMP Start_Write_cmd;		  		{   5					}
	AR = AR-0x1;
	IF EQ JUMP Stop_Write_cmd;			  		{   6					}
	AR = AR-0x1;
	IF EQ JUMP Write_Sample_cmd;		  		{   7 				}
	AR = AR-0x1;
	IF EQ JUMP Enable_TTL_Out_cmd;			{   8 				}
	AR = AR-0x1;
	IF EQ JUMP Get_TTL_cmd;   					{   9 				}
	AR = AR-0x1;
	IF EQ JUMP Put_TTL_cmd;   					{   10		 		}

{ 訡  ।  												}
ErrorEndOfCommand:
	PutValPm(AR, 0xFFFF, CommandAddr);

{ ᯮ 室  㭪樨															}
	RTS;

{ *********************************************************************	}
{ ⮢ .                                                   	}
{ ᫥ 室  祩	  TestLoadVar								}
{  													  ᫮ 0xAA55		}
{ *********************************************************************	}
Test_cmd:
	PutValPm(AR,0xAA55, TestLoadVarAddr);

{ *********************************************************************	}
{ 室  ࠡ稪  IRQE													}
{ ᫥ 室  祩	  Command   ᫮ 0x0		}
{ *********************************************************************	}
EndOfCommand:
{ 㫨    ਧ 襭  ࠡ⪨					}
	PutValPm(AR, 0x0, CommandAddr);
{ ᯮ 室  㭪樨															}
	RTS;

{ *********************************************************************	}
{  ᪠  														}
{ *********************************************************************	}
Start_Read_cmd:
{ ⠭ , 몫稢  SCLK , .. ᤥ  譨			}
	AR = 0x3F1F; 						{ 0011 1111 0001 1111 						}
	DM(Sport1_Ctrl_Reg) = AR;		{ 0x3FF2 - SPORT1 Control Register		}

{ ࠧ᪨㥬 뢠 IRQ2()											}
	GetPm(AR,ImaskValueAddr);
	AR = CLRBIT 2 OF AR;			  { ᪨㥬 뢠 IRQ1(.ᨭ.)}
	AR = CLRBIT 4 OF AR;			  { ᪨㥬 뢠 IRQE()		}
	PutPm(AR,ImaskValueAddr);
	IMASK = AR; NOP; NOP;

{ প  2  																		}
	CALL Delay2mks;

{ ᨬ    뢠 ஬ SPORT0 Transmit (뢮)			}
	IFC = 0xBF; NOP;

{   ⪨ MainLoop ய襬  CALL PutInputData						}
	I4=^MainLoop; AR=^PutInputData;
	CALL ModifyCall;

{ ᨬ 䫠 ࠧ襭  												}
	PutValPm(AR, 0x0, InputEnableAddr);

{ ᢥ⨬ ᢥ⮤																	}
/*	AR=DM(Prog_Flag_Data); AR= CLRBIT 2 OF AR; DM(Prog_Flag_Data)=AR;*/

{ ᭨  ⨯   :   							}
	GetPm(AR, InputTypeAddr); AR = ABS AR; NONE = PASS AR;
	IF EQ JUMP ErrorEndOfCommand;				{     :(		}
	AR = AR - 0x1;
	IF EQ JUMP AdcInputTypeStart;		 		{     		}
	AR = AR - 0x1;
	IF EQ JUMP TtlInputTypeStart;		 		{     		}
{  ࠢ ⨯  												}
	JUMP ErrorEndOfCommand;

{ *********************************************************************	}
{  ⠭   														}
{ *********************************************************************	}
Stop_Read_cmd:
{ ⠭ ᡮ 																	} 
	CALL StopRead;
	
{ ᨬ ᢥ⮤																	}
/*	AR=DM(Prog_Flag_Data); AR= SETBIT 2 OF AR; DM(Prog_Flag_Data)=AR;*/

{ ᨬ 䫠 ࠧ襭  												}
	PutValPm(AR, 0x0, InputEnableAddr);

{ 訬 믮 ⥪饩 												}
	JUMP EndOfCommand;

{ ********************************************************************  }
{ ⠭ ᡮ : 頥  ७   	} 
{ 筨 ⠪⮢ ᮢ    ७					}	
{ ********************************************************************  }
StopRead:
{ ࠧ᪨㥬 뢠 IRQ2()											}
	GetPm(AR, ImaskValueAddr);
	AR = CLRBIT 2 OF AR;			  { ᪨㥬 뢠 IRQ1(.ᨭ.)}
	AR = CLRBIT 4 OF AR;			  { ᪨㥬 뢠 IRQE()		}
	PutPm(AR, ImaskValueAddr);
	IMASK = AR; NOP;

{ ⠭  ७  SCLK1, ᤥ  譨			}
	AR = 0x3F1F; 						{ 0011 1111 0001 1111 						}
	DM(Sport1_Ctrl_Reg) = AR;		{ 0x3FF2 - SPORT1 Control Register		}

{ --------------  筨 ⠪⮢ ᮢ -------------------	}
{ ------ 롥६ ᯮ짮 ७ ⠪⮢ ᮢ ----------	}
{ -------- 15  ॣ TTL_OUT   ⠭  '0' -------	}
{ ﭨ 室 																}
	GetPm(AR, TtlOutAddr); AY0 = 0xFF;
	AR = AR AND AY0; SR0 = AR;
{ ।  室 													}
	GetPm(AR, TtlOutEnableAddr); AR = AR AND 0x1;
	SR = SR OR LSHIFT AR BY 14 (LO);
{ ⥯ ⠭ ஢ 室   . ࠬ				}
	IO(TTL_OUT) = SR0;
{ ---------------------------------------------------------------------	}

{ প  2  																		}
	CALL Delay2mks;

{ ᨬ    뢠 ஬ SPORT0 Transmit (뢮)			}
	IFC = 0xBF; NOP;

{ ᯮ 室  㭪樨															}
	RTS;

{ ********************************************************************  }
{ প  2.0  																	}
{ ********************************************************************  }
Delay2mks:
	CNTR = 142;
	DO Delay2mksLoop UNTIL CE;
Delay2mksLoop: NOP;
	RTS;

{ ********************************************************************  }
{ প   																}
{ ********************************************************************  }
DelayMls:
	CNTR=1000;
	DO Lab1 UNTIL CE;
		CNTR=72;
		DO Lab2 UNTIL CE;
	Lab2: NOP;
Lab1: NOP;

	AR=AR-0x1;
	IF NE JUMP DelayMls;

{ ᯮ 室  㭪樨															}
	RTS;

{ ====================================================================== }
#include "AdcInput.h"
#include "TtlInput.h"
#include "Output.h"
#include "Synchro.h"
#include "Fifo.h"
#include "Ttl.h"

.ENDMOD;
