#include "wrRtusbapi.h"

// =============================================================================
//   -   Rtusbapi.dll     USB3000
// =============================================================================

//------------------------------------------------------------------------------
//       USB   R-Technology
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI OpenDevice_Usb3000(LPVOID IDevPtr, WORD VirtualSlot)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->OpenDevice(VirtualSlot);
}

//------------------------------------------------------------------------------
//    
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI CloseDevice_Usb3000(LPVOID IDevPtr)
{
    return (BOOL)((IRTUSB3000 *)IDevPtr)->CloseDevice();
}

//------------------------------------------------------------------------------
//   
//------------------------------------------------------------------------------
extern "C" HANDLE WINAPI GetModuleHandle_Usb3000(LPVOID IDevPtr)
{
	return (HANDLE)((IRTUSB3000 *)IDevPtr)->GetModuleHandle();
}

//------------------------------------------------------------------------------
//      USB
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI GetUsbSpeed_Usb3000(LPVOID IDevPtr, BYTE * const UsbSpeed)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->GetUsbSpeed(UsbSpeed);
}

//------------------------------------------------------------------------------
//   
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI GetModuleName_Usb3000(LPVOID IDevPtr, PCHAR const ModuleName)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->GetModuleName(ModuleName);
}

//------------------------------------------------------------------------------
//    
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI GetModuleSerialNumber_Usb3000(LPVOID IDevPtr, PCHAR const SerialNumber)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->GetModuleSerialNumber(SerialNumber);
}

//------------------------------------------------------------------------------
//     AVR
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI GetAvrVersion_Usb3000(LPVOID IDevPtr, PCHAR const AvrVersion)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->GetAvrVersion(AvrVersion);
}


//------------------------------------------------------------------------------
//     
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI ReleaseInstance_Usb3000(LPVOID IDevPtr)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->ReleaseInstance();
}

//------------------------------------------------------------------------------
//    DSP
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI RESET_DSP_Usb3000(LPVOID IDevPtr)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->RESET_DSP();
}

//------------------------------------------------------------------------------
//    DSP   RTUSB3000
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI LOAD_DSP_Usb3000(LPVOID IDevPtr, PCHAR const FileName)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->LOAD_DSP(FileName);
}

//------------------------------------------------------------------------------
//    
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI MODULE_TEST_Usb3000(LPVOID IDevPtr)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->MODULE_TEST();
}

//------------------------------------------------------------------------------
//     DSP
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI GET_DSP_INFO_Usb3000(LPVOID IDevPtr, DSP_INFO_USB3000* const wrDspInfo)
{
	// ,      DSP
	RTUSB3000::DSP_INFO di;

	if(!((IRTUSB3000 *)IDevPtr)->GET_DSP_INFO(&di)) return FALSE;
	di.Target[9] = '\0';
	strcpy((char *)wrDspInfo->Target, (char *)di.Target);
	di.Label[5] = '\0';
	strcpy((char *)wrDspInfo->Label, (char *)di.Label);
	wrDspInfo->DspMajor = di.DspMajor;
	wrDspInfo->DspMinor = di.DspMinor;

	return TRUE;
}

//------------------------------------------------------------------------------
//    DSP   
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI SEND_COMMAND_Usb3000(LPVOID IDevPtr, WORD Command)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->SEND_COMMAND(Command);
}


//------------------------------------------------------------------------------
//          
//------------------------------------------------------------------------------
extern "C" int WINAPI GetLastErrorString_Usb3000(LPVOID IDevPtr, LPTSTR const lpBuffer, DWORD nSize)
{
	return ((IRTUSB3000 *)IDevPtr)->GetLastErrorString(lpBuffer, nSize);
}



//------------------------------------------------------------------------------
//         
//------------------------------------------------------------------------
extern "C" BOOL WINAPI GET_INPUT_PARS_Usb3000(LPVOID IDevPtr, INPUT_PARS_USB3000 * const wrAp)
{
	WORD i;
	//    
	RTUSB3000::INPUT_PARS ap;

	ap.size = sizeof(RTUSB3000::INPUT_PARS);
	if(!((IRTUSB3000 *)IDevPtr)->GET_INPUT_PARS(&ap)) return FALSE;

	wrAp->size = sizeof(INPUT_PARS_USB3000);
	wrAp->InputEnabled = ap.InputEnabled;			  			//  /   (  )
	wrAp->CorrectionEnabled = ap.CorrectionEnabled;			//     ( )
	wrAp->InputClockSource = ap.InputClockSource;			//      
	wrAp->InputType = ap.InputType;								//      (  )
	wrAp->SynchroType = ap.SynchroType;							//      
	wrAp->SynchroAdType = ap.SynchroAdType;					//   
	wrAp->SynchroAdMode = ap.SynchroAdMode; 					//   
	wrAp->SynchroAdChannel = ap.SynchroAdChannel;  			//     
	wrAp->SynchroAdPorog = ap.SynchroAdPorog; 				//      
	wrAp->ChannelsQuantity = ap.ChannelsQuantity;		  	//    
	for(i = 0x0; i < 128; i++) wrAp->ControlTable[i] = ap.ControlTable[i];	//      
	wrAp->InputFifoBaseAddress = ap.InputFifoBaseAddress;	//   FIFO  
	wrAp->InputFifoLength = ap.InputFifoLength;	  			//  FIFO  
	wrAp->InputRate = ap.InputRate;	  			  				//      
	wrAp->InterKadrDelay = ap.InterKadrDelay;		  			//    
	wrAp->ChannelRate = ap.ChannelRate;							//     
	for(i = 0x0; i < 0x8; i++)
	{
		wrAp->AdcOffsetCoef[i] = ap.AdcOffsetCoef[i]; 	 	//  .    
		wrAp->AdcScaleCoef[i] = ap.AdcScaleCoef[i];		 	//  .   
	}

	return TRUE;
}


//------------------------------------------------------------------------------
//         
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI SET_INPUT_PARS_Usb3000(LPVOID IDevPtr, INPUT_PARS_USB3000 * const wrAp)
{
	WORD i;
	//    
	RTUSB3000::INPUT_PARS ap;

	ap.size = sizeof(RTUSB3000::INPUT_PARS);
	ap.InputEnabled = wrAp->InputEnabled;			  			//  /   (  )
	ap.CorrectionEnabled = wrAp->CorrectionEnabled;			//     ( )
	ap.InputClockSource = wrAp->InputClockSource;			//      
	ap.InputType = wrAp->InputType;								//      (  )
	ap.SynchroType = wrAp->SynchroType;							//      
	ap.SynchroAdType = wrAp->SynchroAdType;					//   
	ap.SynchroAdMode = wrAp->SynchroAdMode; 					//   
	ap.SynchroAdChannel = wrAp->SynchroAdChannel;  			//     
	ap.SynchroAdPorog = wrAp->SynchroAdPorog; 				//      
	ap.ChannelsQuantity = wrAp->ChannelsQuantity;		  	//    
	for(i = 0x0; i < 128; i++) ap.ControlTable[i] = wrAp->ControlTable[i];	//      
	ap.InputFifoBaseAddress = wrAp->InputFifoBaseAddress;	//   FIFO  
	ap.InputFifoLength = wrAp->InputFifoLength;	  			//  FIFO  
	ap.InputRate = wrAp->InputRate;	  			  				//      
	ap.InterKadrDelay = wrAp->InterKadrDelay;		  			//    
	ap.ChannelRate = wrAp->ChannelRate;							//     
	for(i = 0x0; i < 0x8; i++)
	{
		ap.AdcOffsetCoef[i] = wrAp->AdcOffsetCoef[i]; 	 	//  ->    
		ap.AdcScaleCoef[i] = wrAp->AdcScaleCoef[i];		 	//  ->   
	}

	if(!((IRTUSB3000 *)IDevPtr)->SET_INPUT_PARS(&ap)) return FALSE;

	wrAp->size = sizeof(INPUT_PARS_USB3000);
	wrAp->InputEnabled = ap.InputEnabled;			  			//  /   (  )
	wrAp->CorrectionEnabled = ap.CorrectionEnabled;			//     ( )
	wrAp->InputClockSource = ap.InputClockSource;			//      
	wrAp->InputType = ap.InputType;								//      (  )
	wrAp->SynchroType = ap.SynchroType;							//      
	wrAp->SynchroAdType = ap.SynchroAdType;					//   
	wrAp->SynchroAdMode = ap.SynchroAdMode; 					//   
	wrAp->SynchroAdChannel = ap.SynchroAdChannel;  			//     
	wrAp->SynchroAdPorog = ap.SynchroAdPorog; 				//      
	wrAp->ChannelsQuantity = ap.ChannelsQuantity;		  	//    
	for(i = 0x0; i < 128; i++) wrAp->ControlTable[i] = ap.ControlTable[i];	//      
	wrAp->InputFifoBaseAddress = ap.InputFifoBaseAddress;	//   FIFO  
	wrAp->InputFifoLength = ap.InputFifoLength;	  			//  FIFO  
	wrAp->InputRate = ap.InputRate;	  			  				//      
	wrAp->InterKadrDelay = ap.InterKadrDelay;		  			//    
	wrAp->ChannelRate = ap.ChannelRate;							//     
	for(i = 0x0; i < 0x8; i++)
	{
		wrAp->AdcOffsetCoef[i] = ap.AdcOffsetCoef[i]; 	 	//  .    
		wrAp->AdcScaleCoef[i] = ap.AdcScaleCoef[i];		 	//  .   
	}

	return TRUE;
}


//------------------------------------------------------------------------------
//    
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI START_READ_Usb3000(LPVOID IDevPtr)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->START_READ();
}

//------------------------------------------------------------------------------
//    
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI STOP_READ_Usb3000(LPVOID IDevPtr)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->STOP_READ();
}

//------------------------------------------------------------------------------
//       
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI READ_KADR_Usb3000(LPVOID IDevPtr, SHORT * const Data)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->READ_KADR(Data);
}

//------------------------------------------------------------------------------
//       
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI READ_SAMPLE_Usb3000(LPVOID IDevPtr, WORD Channel, SHORT * const Sample)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->READ_SAMPLE(Channel, Sample);
}

//------------------------------------------------------------------------
//     
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI ReadData_Usb3000(LPVOID IDevPtr, SHORT * const lpBuffer, DWORD * const nNumberOfWordsToRead, LPDWORD lpNumberOfBytesRead, LPOVERLAPPED lpOverlapped)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->ReadData(lpBuffer, nNumberOfWordsToRead, lpNumberOfBytesRead, lpOverlapped);
}




//------------------------------------------------------------------------------
//         
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI GET_OUTPUT_PARS_Usb3000(LPVOID IDevPtr, OUTPUT_PARS_USB3000 * const wrDp)
{
	// ,      
	RTUSB3000::OUTPUT_PARS dp;

	dp.size = sizeof(RTUSB3000::OUTPUT_PARS);
	if(!((IRTUSB3000 *)IDevPtr)->GET_OUTPUT_PARS(&dp)) return FALSE;

	wrDp->size = sizeof(OUTPUT_PARS_USB3000);
	wrDp->OutputEnabled = dp.OutputEnabled;						// /  
	wrDp->OutputRate = dp.OutputRate;	  		  					//     
	wrDp->OutputFifoBaseAddress = dp.OutputFifoBaseAddress; 	//   FIFO  
	wrDp->OutputFifoLength = dp.OutputFifoLength;				//  FIFO  

	return TRUE;
}

//------------------------------------------------------------------------------
//         
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI SET_OUTPUT_PARS_Usb3000(LPVOID IDevPtr, OUTPUT_PARS_USB3000 * const wrDp)
{
	// ,      
	RTUSB3000::OUTPUT_PARS dp;

	dp.size = sizeof(RTUSB3000::OUTPUT_PARS);
	dp.OutputEnabled = wrDp->OutputEnabled;						// /  
	dp.OutputRate = wrDp->OutputRate;	  		  					//     
	dp.OutputFifoBaseAddress = wrDp->OutputFifoBaseAddress; 	//   FIFO  
	dp.OutputFifoLength = wrDp->OutputFifoLength;				//  FIFO  

	if(!((IRTUSB3000 *)IDevPtr)->SET_OUTPUT_PARS(&dp)) return FALSE;

	wrDp->size = sizeof(OUTPUT_PARS_USB3000);
	wrDp->OutputEnabled = dp.OutputEnabled;						// /  
	wrDp->OutputRate = dp.OutputRate;	  		  					//     
	wrDp->OutputFifoBaseAddress = dp.OutputFifoBaseAddress; 	//   FIFO  
	wrDp->OutputFifoLength = dp.OutputFifoLength;				//  FIFO  

	return TRUE;
}

//------------------------------------------------------------------------------
//    
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI START_WRITE_Usb3000(LPVOID IDevPtr)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->START_WRITE();
}

//------------------------------------------------------------------------------
//    
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI STOP_WRITE_Usb3000(LPVOID IDevPtr)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->STOP_WRITE();
}

//------------------------------------------------------------------------------
//      
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI WriteData_Usb3000(LPVOID IDevPtr, SHORT * const lpBuffer, DWORD * const nNumberOfWordsToWrite, LPDWORD lpNumberOfBytesWritten, LPOVERLAPPED lpOverlapped)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->WriteData(lpBuffer, nNumberOfWordsToWrite, lpNumberOfBytesWritten, lpOverlapped);
}

//------------------------------------------------------------------------------
//   
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI WRITE_SAMPLE_Usb3000(LPVOID IDevPtr, WORD Channel, SHORT * const Sample)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->WRITE_SAMPLE(Channel, Sample);
}


//------------------------------------------------------------------------------
//       
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI ENABLE_TTL_OUT_Usb3000(LPVOID IDevPtr, BOOL EnableTtlOut)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->ENABLE_TTL_OUT(EnableTtlOut);
}

//------------------------------------------------------------------------------
//       
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI TTL_IN_Usb3000(LPVOID IDevPtr, WORD * const TtlIn)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->TTL_IN(TtlIn);
}

//------------------------------------------------------------------------------
//        
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI TTL_OUT_Usb3000(LPVOID IDevPtr, WORD TtlOut)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->TTL_OUT(TtlOut);
}

//------------------------------------------------------------------------------
// /     
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI ENABLE_FLASH_WRITE_Usb3000(LPVOID IDevPtr, BOOL EnableFlashWrite)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->ENABLE_FLASH_WRITE(EnableFlashWrite);
}

//------------------------------------------------------------------------
//    FLASH   
//------------------------------------------------------------------------
extern "C" BOOL WINAPI PUT_FLASH_Usb3000(LPVOID IDevPtr, FLASH_USB3000* const wrFi)
{
	WORD i;
	//     
	RTUSB3000::FLASH fi;

	fi.CRC16 = wrFi->CRC16;										//  
	fi.size = sizeof(RTUSB3000::FLASH);						//     
	for(i = 0x0; i < 9; i++)
		fi.SerialNumber[i] = wrFi->SerialNumber[i];		//   
	for(i = 0x0; i < 11; i++)
		fi.Name[i] = wrFi->Name[i];							//  
	fi.Revision = wrFi->Revision;								//  
	for(i = 0x0; i < 17; i++)
		fi.DspType[i] = wrFi->DspType[i];					//   DSP
	fi.IsDacPresented = wrFi->IsDacPresented; 			//   
	fi.DspClockout = wrFi->DspClockout; 					//   DSP  
  	for(i = 0x0; i < 8; i++)
	{
		fi.AdcOffsetCoef[i] = wrFi->AdcOffsetCoef[i];	//  .    
		fi.AdcScaleCoef[i] = wrFi->AdcScaleCoef[i];		//  .   
	}
	for(i = 0x0; i < 2; i++)
	{
		fi.DacOffsetCoef[i] = wrFi->DacOffsetCoef[i];	//  .    
		fi.DacScaleCoef[i] = wrFi->DacScaleCoef[i];		//  .   
	}
	for(i = 0x0; i < 129; i++)
		fi.ReservedByte[i] = wrFi->ReservedByte[i];		// 

	if(!((IRTUSB3000 *)IDevPtr)->PUT_FLASH(&fi)) return FALSE;

	wrFi->CRC16 = fi.CRC16;										//  
	wrFi->size = sizeof(FLASH_USB3000);						//     

   return TRUE;
}

//------------------------------------------------------------------------
//    FLASH   
//------------------------------------------------------------------------
extern "C" BOOL WINAPI GET_FLASH_Usb3000(LPVOID IDevPtr, FLASH_USB3000 * const wrFi)
{
	WORD i;
	//     
	RTUSB3000::FLASH fi;

	fi.size = sizeof(RTUSB3000::FLASH);						//     
	//     
	if(!((IRTUSB3000 *)IDevPtr)->GET_FLASH(&fi)) return FALSE;

	wrFi->CRC16 = fi.CRC16;										//  
	wrFi->size = sizeof(FLASH_USB3000);						//     
	fi.SerialNumber[8] = '\0';
	for(i = 0x0; i < 9; i++)
		wrFi->SerialNumber[i] = fi.SerialNumber[i];		//   
	fi.Name[10] = '\0';
	for(i = 0x0; i < 11; i++)
		wrFi->Name[i] = fi.Name[i];							//  
	wrFi->Revision = fi.Revision;								//  
	fi.DspType[16] = '\0';
	for(i = 0x0; i < 17; i++)
		wrFi->DspType[i] = fi.DspType[i];					//   DSP
	wrFi->IsDacPresented = fi.IsDacPresented; 			//   
	wrFi->DspClockout = fi.DspClockout; 					//   DSP  
  	for(i = 0x0; i < 8; i++)
	{
		wrFi->AdcOffsetCoef[i] = fi.AdcOffsetCoef[i];	//  .    
		wrFi->AdcScaleCoef[i] = fi.AdcScaleCoef[i];		//  .   
	}
	for(i = 0x0; i < 2; i++)
	{
		wrFi->DacOffsetCoef[i] = fi.DacOffsetCoef[i];	//  .    
		wrFi->DacScaleCoef[i] = fi.DacScaleCoef[i];		//  .   
	}
	for(i = 0x0; i < 129; i++)
		wrFi->ReservedByte[i] = fi.ReservedByte[i];		// 

   return TRUE;
}


//------------------------------------------------------------------------------
//          DSP
//------------------------------------------------------------------------------
extern "C" BOOL WINAPI PUT_VAR_WORD_Usb3000(LPVOID IDevPtr, WORD Address, SHORT Data)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->PUT_VAR_WORD(Address, Data);
}

//------------------------------------------------------------------------
//           DSP
//------------------------------------------------------------------------
extern "C" BOOL WINAPI GET_VAR_WORD_Usb3000(LPVOID IDevPtr, WORD Address, SHORT * const Data)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->GET_VAR_WORD(Address, Data);
}

//------------------------------------------------------------------------
//        DSP
//------------------------------------------------------------------------
extern "C" BOOL WINAPI PUT_DM_WORD_Usb3000(LPVOID IDevPtr, WORD Address, SHORT Data)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->PUT_DM_WORD(Address, Data);
}

//------------------------------------------------------------------------
//        DSP
//------------------------------------------------------------------------
extern "C" BOOL WINAPI GET_DM_WORD_Usb3000(LPVOID IDevPtr, WORD Address, SHORT * const Data)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->GET_DM_WORD(Address, Data);
}

//------------------------------------------------------------------------
//        DSP
//------------------------------------------------------------------------
extern "C" BOOL WINAPI PUT_PM_WORD_Usb3000(LPVOID IDevPtr, WORD Address, LONG Data)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->PUT_PM_WORD(Address, Data);
}

//------------------------------------------------------------------------
//        DSP
//------------------------------------------------------------------------
extern "C" BOOL WINAPI GET_PM_WORD_Usb3000(LPVOID IDevPtr, WORD Address, LONG * const Data)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->GET_PM_WORD(Address, Data);
}

//------------------------------------------------------------------------
//         DSP
//------------------------------------------------------------------------
extern "C" BOOL WINAPI PUT_DM_ARRAY_Usb3000(LPVOID IDevPtr, WORD BaseAddress, WORD NPoints, SHORT * const Data)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->PUT_DM_ARRAY(BaseAddress, NPoints, Data);
}

//------------------------------------------------------------------------
//         DSP
//------------------------------------------------------------------------
extern "C" BOOL WINAPI GET_DM_ARRAY_Usb3000(LPVOID IDevPtr, WORD BaseAddress, WORD NPoints, SHORT * const Data)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->GET_DM_ARRAY(BaseAddress, NPoints, Data);
}

//------------------------------------------------------------------------
//         DSP
//------------------------------------------------------------------------
extern "C" BOOL WINAPI PUT_PM_ARRAY_Usb3000(LPVOID IDevPtr, WORD BaseAddress, WORD NPoints, LONG * const Data)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->PUT_PM_ARRAY(BaseAddress, NPoints, Data);
}

//------------------------------------------------------------------------
//         DSP
//------------------------------------------------------------------------
extern "C" BOOL WINAPI GET_PM_ARRAY_Usb3000(LPVOID IDevPtr, WORD BaseAddress, WORD NPoints, LONG * const Data)
{
	return (BOOL)((IRTUSB3000 *)IDevPtr)->GET_PM_ARRAY(BaseAddress, NPoints, Data);
}

