//---------------------------------------------------------------------------
#ifndef __RTUSBDETECTH__
#define __RTUSBDETECTH__
//---------------------------------------------------------------------------
#include "rtusbapi.h"

//      R-Technology
class CRTUSBDETECT : public IRTUSBDETECT
{
	//   
	virtual BOOL WINAPI OpenDevice(WORD VirtualSlot);
	virtual BOOL WINAPI CloseDevice(void);
	virtual HANDLE WINAPI GetModuleHandle(void);
	virtual BOOL WINAPI GetUsbSpeed(BYTE * const UsbSpeed);
	virtual BOOL WINAPI GetModuleName(PCHAR const ModuleName);
	virtual BOOL WINAPI GetModuleSerialNumber(PCHAR const SerialNumber);
	virtual BOOL WINAPI GetAvrVersion(PCHAR const AvrVersion);
	virtual BOOL WINAPI ReleaseInstance(void);

	//      
	virtual int WINAPI GetLastErrorString(LPTSTR const lpBuffer, const DWORD nSize);

	public:
		// 
		CRTUSBDETECT(HINSTANCE hInst);
		// 
		~CRTUSBDETECT();

	private:
		HINSTANCE hInstance;
		//  
		HANDLE hDevice;
		//     
		CRITICAL_SECTION cs;
		//    
		WORD BASE_ERROR_ID;
		//   
		WORD LastErrorNumber;

		//      USB (vendor request)
		enum 	{ 	V_RESET_DSP,
					V_PUT_ARRAY, V_GET_ARRAY,
					V_START_ADC, V_START_DAC,
					V_COMMAND_IRQ,
					V_GET_USB_SPEED,
					V_PUT_FLASH = 8, V_GET_FLASH = 9,
					V_GET_MODULE_NAME = 11,
					V_GET_MODULE_SERIAL_NUMBER = 13
				};
};

#endif
