#include <windows.h>
#include <winioctl.h>
#include <math.h>
#include <FCNTL.h>
#include <io.h>

#include "bulkioct.h"
#include "rtusbapi.h"
#include "usbdetect.h"

DWORD GetSystemVersionMy(void);

//------------------------------------------------------------------------
// 
//------------------------------------------------------------------------
CRTUSBDETECT::CRTUSBDETECT(HINSTANCE hInst)
{
	//     
	InitializeCriticalSection(&cs);
	//   DLL
	hInstance = hInst;
	//  
	hDevice = INVALID_HANDLE_VALUE;
	//    
	BASE_ERROR_ID = 300;
	//   
	LastErrorNumber = 0;
}

//------------------------------------------------------------------------
// 
//------------------------------------------------------------------------
CRTUSBDETECT::~CRTUSBDETECT() { }



//========================================================================
//       USB-  R-Technology
//========================================================================

//------------------------------------------------------------------------
//       USB 
//------------------------------------------------------------------------
BOOL WINAPI CRTUSBDETECT::OpenDevice(WORD VirtualSlot)
{
	char szDrvName[18], slot[4];

	//   ?
	if(hDevice != INVALID_HANDLE_VALUE) { CloseHandle(hDevice); hDevice = INVALID_HANDLE_VALUE; }

	//   Windows
	DWORD SystemVersion = GetSystemVersionMy();
	if((SystemVersion != 0x00010003/*Win2000  WinXP*/) && (SystemVersion != 0x00020001/*Win98*/))  { LastErrorNumber = 1; return FALSE; }

	//    USB
	wsprintf(slot, "%d", VirtualSlot);
	strcpy(szDrvName, "\\\\.\\RtecUsb");
	strncat(szDrvName, slot, strlen(slot));

	//    
	hDevice = CreateFile(szDrvName, GENERIC_READ | GENERIC_WRITE, 0, NULL,
						                      OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL);

	if(hDevice == INVALID_HANDLE_VALUE)  { LastErrorNumber = 2; return FALSE; }
	else return TRUE;
}

//------------------------------------------------------------------------------
//    
//------------------------------------------------------------------------------
BOOL WINAPI CRTUSBDETECT::CloseDevice(void)
{
	BOOL status = TRUE;

	if(hDevice != INVALID_HANDLE_VALUE)
	{
		if(!CloseHandle(hDevice)) { LastErrorNumber = 3; status = FALSE; }
		hDevice = INVALID_HANDLE_VALUE;
	}

	return status;
}

//------------------------------------------------------------------------
//   
//------------------------------------------------------------------------
HANDLE WINAPI CRTUSBDETECT::GetModuleHandle(void) { return hDevice; }

//------------------------------------------------------------------------
//      USB
//------------------------------------------------------------------------
BOOL WINAPI CRTUSBDETECT::GetUsbSpeed(BYTE * const UsbSpeed)
{
	BOOL status;
	WORD InBuf[4];
	DWORD cbRet=0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }

	//   
	EnterCriticalSection(&cs);

	//     
	InBuf[0] = 1; InBuf[1] = V_GET_USB_SPEED; InBuf[2] = 0x0; InBuf[3] = 0x0;
	//   
	status = DeviceIoControl( hDevice, DIOC_SEND_COMMAND,
				            		&InBuf, sizeof(InBuf),
										UsbSpeed, 1/*bytes*/,
                       			&cbRet, NULL);

	//   
	LeaveCriticalSection(&cs);

	//   :)))))
	if(status) return TRUE;
	//   DeviceIoControl()
	else { LastErrorNumber = 5; return FALSE; }
}

//------------------------------------------------------------------------------
//   
//------------------------------------------------------------------------------
BOOL WINAPI CRTUSBDETECT::GetModuleName(PCHAR const ModuleName)
{
	BOOL status;
	char String[15];
	WORD InBuf[4];
	DWORD cbRet=0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }

	//   
	EnterCriticalSection(&cs);

	//     
	InBuf[0] = 1; InBuf[1] = V_GET_MODULE_NAME; InBuf[2] = 0x0; InBuf[3] = 0x0;
	//   
	status = DeviceIoControl( hDevice, DIOC_SEND_COMMAND,
				            		&InBuf, sizeof(InBuf),
										String, 15/*bytes*/,
                       			&cbRet, NULL);

	//   
	LeaveCriticalSection(&cs);

	//  
	strncpy(ModuleName, String, 10);
	//     0 (  )
	ModuleName[9] = '\0';

	//   :)))))
	if(status) return TRUE;
	//   DeviceIoControl()
	else { LastErrorNumber = 5; return FALSE; }
}

//------------------------------------------------------------------------------
//    
//------------------------------------------------------------------------------
BOOL WINAPI CRTUSBDETECT::GetModuleSerialNumber(PCHAR const SerialNumber)
{
	BOOL status;
	WORD InBuf[4];
	DWORD cbRet=0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }

	//   
	EnterCriticalSection(&cs);

	//      
	InBuf[0] = 1; InBuf[1] = V_GET_MODULE_SERIAL_NUMBER; InBuf[2] = 0x0; InBuf[3] = 0x0;
	//   
	status = DeviceIoControl( hDevice, DIOC_SEND_COMMAND,
	                       		&InBuf, sizeof(InBuf),
	                           SerialNumber, 9/*bytes*/,
	                       		&cbRet, NULL);

	//   
	LeaveCriticalSection(&cs);

	//     0 (  )
	SerialNumber[8] = '\0';

	//   :)))))
	if(status) return TRUE;
	//   DeviceIoControl()
	else { LastErrorNumber = 5; return FALSE; }
}

//------------------------------------------------------------------------
//      
//  RTUSB3000 ( AVR)
//------------------------------------------------------------------------
BOOL WINAPI CRTUSBDETECT::GetAvrVersion(PCHAR const AvrVersion)
{
	BOOL status;
	char String[15];
	WORD InBuf[4];
	DWORD cbRet=0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }

	//   
	EnterCriticalSection(&cs);

	//     
	InBuf[0] = 1; InBuf[1] = V_GET_MODULE_NAME; InBuf[2] = 0x0; InBuf[3] = 0x0;
	//   
	status = DeviceIoControl( hDevice, DIOC_SEND_COMMAND,
				            		&InBuf, sizeof(InBuf),
										String, 15/*bytes*/,
                       			&cbRet, NULL);

	//   
	LeaveCriticalSection(&cs);

	//  
	strncpy(AvrVersion, String+10, 5);
	//     0 (  )
	AvrVersion[4] = '\0';

	//   :)))))
	if(status) return TRUE;
	//   DeviceIoControl()
	else { LastErrorNumber = 5; return FALSE; }
}

//------------------------------------------------------------------------------
//    
//------------------------------------------------------------------------------
BOOL WINAPI CRTUSBDETECT::ReleaseInstance(void)
{
	BOOL status = TRUE;

	//    
	DeleteCriticalSection(&cs);
	//    
	if(!CloseDevice()) status = FALSE;
	//    
	delete this;

	return status;
}

//------------------------------------------------------------------------------
//         
//------------------------------------------------------------------------------
int WINAPI CRTUSBDETECT::GetLastErrorString(LPTSTR const lpBuffer, const DWORD nSize)
{
	return LoadString(hInstance, BASE_ERROR_ID + LastErrorNumber, lpBuffer, nSize);
}
