//---------------------------------------------------------------------------
#ifndef __RTUSB3000H__
#define __RTUSB3000H__
//---------------------------------------------------------------------------
#include "rtusbapi.h"

//      USB3000
class CRTUSB3000 : public IRTUSB3000
{
	//   
	virtual BOOL WINAPI OpenDevice(WORD VirtualSlot);
	virtual BOOL WINAPI CloseDevice(void);
	virtual HANDLE WINAPI GetModuleHandle(void);
	virtual BOOL WINAPI GetUsbSpeed(BYTE * const UsbSpeed);
	virtual BOOL WINAPI GetModuleName(PCHAR const ModuleName);
	virtual BOOL WINAPI GetModuleSerialNumber(PCHAR const SerialNumber);
	virtual BOOL WINAPI GetAvrVersion(PCHAR const AvrVersion);
	virtual BOOL WINAPI ReleaseInstance(void);

	//     DSP 
	virtual BOOL WINAPI RESET_DSP(void);
	virtual BOOL WINAPI LOAD_DSP(PCHAR const FileName);
	virtual BOOL WINAPI MODULE_TEST(void);
	virtual BOOL WINAPI GET_DSP_INFO(RTUSB3000::DSP_INFO * const DspInfo);
	virtual BOOL WINAPI SEND_COMMAND(WORD Command);

	//      DSP
	virtual BOOL WINAPI PUT_VAR_WORD(WORD Address, SHORT Data);
	virtual BOOL WINAPI GET_VAR_WORD(WORD Address, SHORT * const Data);
	virtual BOOL WINAPI PUT_DM_WORD(WORD Address, SHORT Data);
	virtual BOOL WINAPI GET_DM_WORD(WORD Address, SHORT * const Data);
	virtual BOOL WINAPI PUT_PM_WORD(WORD Address, LONG Data);
	virtual BOOL WINAPI GET_PM_WORD(WORD Address, LONG * const Data);
	virtual BOOL WINAPI PUT_DM_ARRAY(WORD BaseAddress, WORD NPoints, SHORT * const Data);
	virtual BOOL WINAPI GET_DM_ARRAY(WORD BaseAddress, WORD NPoints, SHORT * const Data);
	virtual BOOL WINAPI PUT_PM_ARRAY(WORD BaseAddress, WORD NPoints, LONG * const Data);
	virtual BOOL WINAPI GET_PM_ARRAY(WORD BaseAddress, WORD NPoints, LONG * const Data);

	//           
	virtual BOOL WINAPI GET_INPUT_PARS(RTUSB3000::INPUT_PARS * const ap);
	virtual BOOL WINAPI SET_INPUT_PARS(RTUSB3000::INPUT_PARS * const ap);
	virtual BOOL WINAPI START_READ(void);
	virtual BOOL WINAPI STOP_READ(void);
	virtual BOOL WINAPI READ_KADR(SHORT * const Data);
	virtual BOOL WINAPI READ_SAMPLE(WORD Channel, SHORT * const Sample);
	virtual BOOL WINAPI ReadData(SHORT * const lpBuffer, DWORD * const nNumberOfWordsToRead, LPDWORD lpNumberOfBytesRead, LPOVERLAPPED lpOverlapped);

	//    c      
	virtual BOOL WINAPI GET_OUTPUT_PARS(RTUSB3000::OUTPUT_PARS * const dp);
	virtual BOOL WINAPI SET_OUTPUT_PARS(RTUSB3000::OUTPUT_PARS * const dp);
	virtual BOOL WINAPI START_WRITE(void);
	virtual BOOL WINAPI STOP_WRITE(void);
	virtual BOOL WINAPI WRITE_SAMPLE(WORD Channel, SHORT * const Sample);
	virtual BOOL WINAPI WriteData(SHORT * const lpBuffer, DWORD * const nNumberOfWordsToWrite, LPDWORD lpNumberOfBytesWritten, LPOVERLAPPED lpOverlapped);

	//      
	virtual BOOL WINAPI ENABLE_TTL_OUT(BOOL EnableTtlOut);
	virtual BOOL WINAPI TTL_OUT(WORD TtlOut);
	virtual BOOL WINAPI TTL_IN(WORD * const TtlIn);

	//      
	virtual BOOL WINAPI ENABLE_FLASH_WRITE(BOOL EnableFlashWrite);
	virtual BOOL WINAPI PUT_FLASH(RTUSB3000::FLASH * const fi);
	virtual BOOL WINAPI GET_FLASH(RTUSB3000::FLASH * const fi);

	//      
	virtual int WINAPI GetLastErrorString(LPTSTR const lpBuffer, DWORD nSize);

	public:
		// 
		CRTUSB3000(HINSTANCE hInst);
		// 
		~CRTUSB3000();

	private:
		//    Windows   
		DWORD GetWindowsVersion(void);
		LONG *Transform_Buffer(WORD PmPoints, LONG * const Buffer);
		BOOL FindoutInputType(RTUSB3000::INPUT_PARS * const ap);
		BOOL ControlTableCreation(RTUSB3000::INPUT_PARS * const ap);
		WORD CalculateCrc16(BYTE *ptr, WORD NBytes);

		//   DLL
		HINSTANCE hInstance;
		//  
		HANDLE hDevice;
		//   USB (0 -> USB11, 1 -> USB20)
		BYTE UsbSpeed;
		//      
		BOOL EnableFlashWrite;
		//        
		BOOL IsServiceFlashWrite;
		//     
		BOOL EnableTtlOut;
		//      RTUSB2185
		RTUSB3000::FLASH fi;
		//     
		RTUSB3000::INPUT_PARS ap;
		//     
		RTUSB3000::OUTPUT_PARS dp;
		//      LBIOS   
		WORD ProgramBaseAddress;
		//        
		WORD VarsBaseAddress;
		//     
		CRITICAL_SECTION cs;

		//  -     ContolPipe
		WORD MAX_USB_BLOCK;
		//    
		WORD BASE_ERROR_ID;
		//    DSP
		WORD DSP_DM;
		//    DSP
		WORD DSP_PM;

		//   
		WORD LastErrorNumber;

		//      USB (vendor request)
		enum 	{ 	V_RESET_DSP,
					V_PUT_ARRAY, V_GET_ARRAY,
					V_START_READ, V_START_WRITE,
					V_COMMAND_IRQ,
					V_GET_USB_SPEED,
					V_PUT_FLASH = 8, V_GET_FLASH = 9,
					V_GET_MODULE_NAME = 11,
					V_GET_MODULE_SERIAL_NUMBER = 13
				};

		//      DSP
		enum 	{ 	C_TEST,
					C_START_READ, C_STOP_READ, C_READ_KADR, C_READ_SAMPLE,
					C_START_WRITE, C_STOP_WRITE, C_WRITE_SAMPLE,
					C_ENABLE_TTL_OUT, C_TTL_IN, C_TTL_OUT,
					C_LAST_COMMAND
				};

		//   Windows
		enum 	{
					UNKNOWN_WINDOWS_VERSION,
					WINDOWS_32S,
					WINDOWS_95, WINDOWS_98_OR_LATER,
					WINDOWS_NT, WINDOWS_2000, WINDOWS_XP, WINDOWS_2003_SERVER, WINDOWS_VISTA
				};
};

#endif

