//---------------------------------------------------------------------------
#ifndef __RTUSB2185H__
#define __RTUSB2185H__
//---------------------------------------------------------------------------
#include "rtusbapi.h"

//      USB2185
class CRTUSB2185 : public IRTUSB2185
{
	//   
	virtual BOOL WINAPI OpenDevice(WORD VirtualSlot);
	virtual BOOL WINAPI CloseDevice(void);
	virtual HANDLE WINAPI GetModuleHandle(void);
	virtual BOOL WINAPI GetUsbSpeed(BYTE * const UsbSpeed);
	virtual BOOL WINAPI GetModuleName(PCHAR const ModuleName);
	virtual BOOL WINAPI GetModuleSerialNumber(PCHAR const SerialNumber);
	virtual BOOL WINAPI GetAvrVersion(PCHAR const AvrVersion);
	virtual BOOL WINAPI ReleaseInstance(void);

	//     DSP 
	virtual BOOL WINAPI RESET_DSP(void);
	virtual BOOL WINAPI LOAD_DSP(PCHAR const FileName);
	virtual BOOL WINAPI MODULE_TEST(void);
	virtual BOOL WINAPI GET_DSP_INFO(RTUSB2185::DSP_INFO * const DspInfo);
	virtual BOOL WINAPI SEND_COMMAND(WORD Command);

	//      DSP
	virtual BOOL WINAPI PUT_VAR_WORD(WORD Address, SHORT Data);
	virtual BOOL WINAPI GET_VAR_WORD(WORD Address, SHORT * const Data);
	virtual BOOL WINAPI PUT_DM_WORD(WORD Address, SHORT Data);
	virtual BOOL WINAPI GET_DM_WORD(WORD Address, SHORT * const Data);
	virtual BOOL WINAPI PUT_PM_WORD(WORD Address, LONG Data);
	virtual BOOL WINAPI GET_PM_WORD(WORD Address, LONG * const Data);
	virtual BOOL WINAPI PUT_DM_ARRAY(WORD BaseAddress, WORD NPoints, SHORT * const Data);
	virtual BOOL WINAPI GET_DM_ARRAY(WORD BaseAddress, WORD NPoints, SHORT * const Data);
	virtual BOOL WINAPI PUT_PM_ARRAY(WORD BaseAddress, WORD NPoints, LONG * const Data);
	virtual BOOL WINAPI GET_PM_ARRAY(WORD BaseAddress, WORD NPoints, LONG * const Data);

	//        
	virtual BOOL WINAPI START_READ(void);
	virtual BOOL WINAPI STOP_READ(void);
	virtual BOOL WINAPI ReadData(SHORT * const lpBuffer, DWORD * const nNumberOfWordsToRead, LPDWORD lpNumberOfBytesRead, LPOVERLAPPED lpOverlapped);

	//        
	virtual BOOL WINAPI START_WRITE(void);
	virtual BOOL WINAPI STOP_WRITE(void);
	virtual BOOL WINAPI WriteData(SHORT * const lpBuffer, DWORD * const nNumberOfWordsToWrite, LPDWORD lpNumberOfBytesWritten, LPOVERLAPPED lpOverlapped);

	//      
	virtual BOOL WINAPI GET_FLASH(RTUSB2185::FLASH * const fi);
	virtual BOOL WINAPI PUT_FLASH(RTUSB2185::FLASH * const fi);

	//      
	virtual int WINAPI GetLastErrorString(LPTSTR const lpBuffer, DWORD nSize);

	public:
		// 
		CRTUSB2185(HINSTANCE hInst);
		// 
		~CRTUSB2185();

	private:
		//    Windows   
		DWORD GetWindowsVersion(void);
		LONG *Transform_Buffer(WORD PmPoints, LONG * const Buffer);

		//   DLL
		HINSTANCE hInstance;
		//  
		HANDLE hDevice;
		//      
		BOOL EnableFlashWrite;
		//        
		BOOL IsServiceFlashWrite;
		//      RTUSB2185
		RTUSB2185::FLASH fi;
		//        DSP
		WORD ProgramBaseAddress;
		//        DSP
		WORD VarsBaseAddress;
		//     
		CRITICAL_SECTION cs;

		//    DSP
		WORD DSP_DM;
		//    DSP
		WORD DSP_PM;
		//  -     ContolPipe
		WORD MAX_USB_BLOCK;
		//    
		WORD BASE_ERROR_ID;
		//   
		WORD LastErrorNumber;

		//   Windows
		enum 	{
					UNKNOWN_WINDOWS_VERSION,
					WINDOWS_32S,
					WINDOWS_95, WINDOWS_98_OR_LATER,
					WINDOWS_NT, WINDOWS_2000, WINDOWS_XP, WINDOWS_2003_SERVER, WINDOWS_VISTA
				};
};

#endif

