#include <windows.h>
#include <winioctl.h>
#include <math.h>
#include <FCNTL.h>
#include <io.h>

#include "bulkioct.h"
#include "rtusbapi.h"
#include "usb2185.h"

DWORD GetSystemVersionMy(void);

//------------------------------------------------------------------------
// 
//------------------------------------------------------------------------
CRTUSB2185::CRTUSB2185(HINSTANCE hInst)
{
	//   DLL
	hInstance = hInst;
	//  
	hDevice = INVALID_HANDLE_VALUE;
	//      
	EnableFlashWrite = FALSE;
	//       
	IsServiceFlashWrite = FALSE;
	//         DSP
	ProgramBaseAddress = 0x1000;
	//         DSP
	VarsBaseAddress = RTUSB2185::VarsBaseAddress;
	//     
	InitializeCriticalSection(&cs);
	//    DSP
	DSP_DM = 0x4000;
	//    DSP
	DSP_PM = 0x0000;
	//  -     ContolPipe
	MAX_USB_BLOCK = 4096;
	//    
	BASE_ERROR_ID = 100;
	//   
	LastErrorNumber = 0;
}

//------------------------------------------------------------------------
// 
//------------------------------------------------------------------------
CRTUSB2185::~CRTUSB2185() { }




//========================================================================
//        RTUSB2185
//========================================================================

//------------------------------------------------------------------------
//       USB 
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::OpenDevice(WORD VirtualSlot)
{
	//  
	char ModuleName[10];
	//  
	char szDrvName[18], slot[4];

	//   ?
	if(hDevice != INVALID_HANDLE_VALUE) { CloseHandle(hDevice); hDevice = INVALID_HANDLE_VALUE; }

	//   Windows
	DWORD SystemVersion = GetSystemVersionMy();
	if((SystemVersion == UNKNOWN_WINDOWS_VERSION) ||
   	(SystemVersion == WINDOWS_95) || (SystemVersion == WINDOWS_98_OR_LATER) ||
		(SystemVersion == WINDOWS_NT)) { LastErrorNumber = 1; return FALSE; }

	//    USB
	wsprintf(slot, "%d", VirtualSlot);
	strcpy(szDrvName, "\\\\.\\RtecUsb");
	strncat(szDrvName, slot, strlen(slot));

	//    
	hDevice = CreateFile(szDrvName, GENERIC_READ | GENERIC_WRITE, 0, NULL,
						                      OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL);

	//   
	if(hDevice == INVALID_HANDLE_VALUE)  { LastErrorNumber = 2; return FALSE; }
	//   
	else if(!GetModuleName(ModuleName)) { LastErrorNumber = 33; CloseDevice(); return FALSE; }
	//    USB2185
	else if(strcmp(ModuleName, "USB2185")) { LastErrorNumber = 34; CloseDevice(); return FALSE; }
	else return TRUE;
}

//------------------------------------------------------------------------------
//    
//------------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::CloseDevice(void)
{
	BOOL status = TRUE;

	if(hDevice != INVALID_HANDLE_VALUE)
	{
		if(!CloseHandle(hDevice)) { LastErrorNumber = 3; status = FALSE; }
		hDevice = INVALID_HANDLE_VALUE;
	}

	return status;
}

//------------------------------------------------------------------------
//   
//------------------------------------------------------------------------
HANDLE WINAPI CRTUSB2185::GetModuleHandle(void) { return hDevice; }

//------------------------------------------------------------------------
//      USB
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::GetUsbSpeed(BYTE * const UsbSpeed)
{
	BOOL status;
	WORD InBuf[4];
	DWORD cbRet=0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }

	//   
	EnterCriticalSection(&cs);

	//     
	InBuf[0] = 1; InBuf[1] = RTUSB2185::V_GET_USB_SPEED; InBuf[2] = 0x0; InBuf[3] = 0x0;
	//   
	status = DeviceIoControl( hDevice, DIOC_SEND_COMMAND,
				            		&InBuf, sizeof(InBuf),
										UsbSpeed, 1/*bytes*/,
                       			&cbRet, NULL);

	//   
	LeaveCriticalSection(&cs);

	//   :)))))
	if(status) return TRUE;
	//   DeviceIoControl()
	else { LastErrorNumber = 5; return FALSE; }
}

//------------------------------------------------------------------------------
//  
//------------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::GetModuleName(PCHAR const ModuleName)
{
	BOOL status;
	char String[15];
	WORD InBuf[4];
	DWORD cbRet=0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }

	//   
	EnterCriticalSection(&cs);

	//     
	InBuf[0] = 1; InBuf[1] = RTUSB2185::V_GET_MODULE_NAME; InBuf[2] = 0x0; InBuf[3] = 0x0;
	//   
	status = DeviceIoControl( hDevice, DIOC_SEND_COMMAND,
				            		&InBuf, sizeof(InBuf),
										String, 15/*bytes*/,
                       			&cbRet, NULL);


	//   
	LeaveCriticalSection(&cs);

	//  
	strncpy(ModuleName, String, 10);
	//     0 (  )
	ModuleName[9] = '\0';

	//   :)))))
	if(status) return TRUE;
	//   DeviceIoControl()
	else { LastErrorNumber = 5; return FALSE; }
}

//------------------------------------------------------------------------------
//    
//------------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::GetModuleSerialNumber(PCHAR const SerialNumber)
{
	BOOL status;
	WORD InBuf[4];
	DWORD cbRet=0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return false; }

	//   
	EnterCriticalSection(&cs);

	//      
	InBuf[0] = 1; InBuf[1] = RTUSB2185::V_GET_MODULE_SERIAL_NUMBER; InBuf[2] = 0x0; InBuf[3] = 0x0;
	//   
	status = DeviceIoControl( hDevice, DIOC_SEND_COMMAND,
	                       		&InBuf, sizeof(InBuf),
	                           SerialNumber, 9/*bytes*/,
	                       		&cbRet, NULL);

	//   
	LeaveCriticalSection(&cs);

	//     0 (  )
	SerialNumber[8] = '\0';

	//   :)))))
	if(status) return TRUE;
	//   DeviceIoControl()
	else { LastErrorNumber = 5; return FALSE; }
}

//------------------------------------------------------------------------
//      
//  RTUSB2185 ( AVR)
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::GetAvrVersion(PCHAR const AvrVersion)
{
	BOOL status;
	char String[15];
	WORD InBuf[4];
	DWORD cbRet=0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }

	//   
	EnterCriticalSection(&cs);

	//     
	InBuf[0] = 1; InBuf[1] = RTUSB2185::V_GET_MODULE_NAME; InBuf[2] = 0x0; InBuf[3] = 0x0;
	//   
	status = DeviceIoControl( hDevice, DIOC_SEND_COMMAND,
				            		&InBuf, sizeof(InBuf),
										String, 15/*bytes*/,
                       			&cbRet, NULL);

	//   
	LeaveCriticalSection(&cs);

	//  
	strncpy(AvrVersion, String+10, 5);
	//     0 (  )
	AvrVersion[4] = '\0';

	//   :)))))
	if(status) return TRUE;
	//   DeviceIoControl()
	else { LastErrorNumber = 5; return FALSE; }
}

//------------------------------------------------------------------------------
//    
//------------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::ReleaseInstance(void)
{
	BOOL status = TRUE;

	//    
	DeleteCriticalSection(&cs);
	//    
	if(!CloseDevice()) status = FALSE;
	//    
	delete this;

	return status;
}


//------------------------------------------------------------------------
//    DSP
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::RESET_DSP(void)
{
	BOOL status;
	WORD InBuf[4];
	DWORD cbRet=0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }

	//   
	EnterCriticalSection(&cs);

	//    DSP 
	InBuf[0] = 0; InBuf[1] = RTUSB2185::V_RESET_DSP; InBuf[2] = 0x0; InBuf[3] = 0x0;
	//   
	status = DeviceIoControl( hDevice, DIOC_SEND_COMMAND,
	                       		&InBuf, sizeof(InBuf),
                       			NULL, 0/*bytes*/,
                       			&cbRet, NULL);

	//   
	LeaveCriticalSection(&cs);

	//   :)))))
	if(status) return TRUE;
	//   DeviceIoControl()
	else { LastErrorNumber = 5; return FALSE; }
}

//------------------------------------------------------------------------------
//    DSP   RTUSB2185
//------------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::LOAD_DSP(const PCHAR FileName)
{
	int	FileHandle;
	DWORD	NBytes;
	char  *CodeByte;
	WORD	*CodeWord;
	WORD 	PmBase, PmWords, DmBase, DmWords;
	char 	PatternHeadStr[]="crrtd";
	char	HeadStr[6];

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }
 	//   DSP 
	else if(!RESET_DSP()) { LastErrorNumber = 6; return FALSE; }

	if(FileName == NULL)
	{
		//      DSP
		HRSRC RsRes = FindResource(hInstance, "USB2185DSP", RT_RCDATA);
		if(RsRes == NULL) { LastErrorNumber = 7; return FALSE; }
		//  
		HGLOBAL RcResHandle = LoadResource(hInstance, RsRes);
		if(RcResHandle == NULL) { LastErrorNumber = 8; return FALSE; }
		// 
		char  *pRcData = (char *)LockResource(RcResHandle);
		if(pRcData == NULL) { LastErrorNumber = 9; return FALSE; }
		//   
		NBytes = SizeofResource(hInstance, RsRes);
		if(NBytes == NULL) { LastErrorNumber = 10; return FALSE; }

		//        DSP
		CodeByte = new char[NBytes+2];
		if(CodeByte == NULL)  { LastErrorNumber = 11; return FALSE; }

		//   
		for(DWORD i=0; i < NBytes; i++) CodeByte[i] = pRcData[i];
	}
	else
	{
		//      DSP
		FileHandle=open(FileName, O_BINARY | O_RDONLY);
		if(FileHandle == -1) { LastErrorNumber = 12; return FALSE; }

		//  -       DSP
		NBytes = filelength(FileHandle);
		if((LONG)NBytes == -1) { LastErrorNumber = 13; return FALSE; }

		//     DSP
		CodeByte = new char[NBytes+2];
		if(CodeByte == NULL)  { LastErrorNumber = 11; return FALSE; }

		//    
		if(read(FileHandle, CodeByte, NBytes) == -1) { LastErrorNumber = 14; return FALSE; }

		//  
		close(FileHandle);
	}

	memcpy(HeadStr, CodeByte, 5); HeadStr[5] = '\0';
	if(strcmp(PatternHeadStr, HeadStr)) { LastErrorNumber = 32; return FALSE; }

	//   WORD
	CodeWord = (WORD *)CodeByte;

	//    
	PmBase = CodeWord[6];
	// -    
	PmWords = CodeWord[7];
	//    
	DmBase = CodeWord[8];
	// -    
	DmWords = CodeWord[9];

	//    DSP
	if(!PUT_DM_ARRAY((WORD)DmBase, DmWords, (SHORT *)(CodeWord + 2*PmWords + 10))) { delete[] CodeByte;  LastErrorNumber = 15; return FALSE; }

	//    DSP,    01
	if(!PUT_PM_ARRAY((WORD)(PmBase+1), MAKE_PM_BUFFER_RTUSBAPI(PmWords-1, (CodeWord + 12)))) { delete[] CodeByte;  LastErrorNumber = 16; return FALSE; }

	//      DSP, ..   DSP
	if(!PUT_PM_ARRAY((WORD)PmBase, MAKE_PM_BUFFER_RTUSBAPI(1, CodeWord + 10))) { delete[] CodeByte;  LastErrorNumber = 16; return FALSE; }

	//  
	delete[] CodeByte;

	//          DSP
	LONG PBA; if(!GET_PM_WORD(RTUSB2185::D_PROGRAM_BASE_ADDRESS, &PBA)) { LastErrorNumber = 17; return FALSE; }
	ProgramBaseAddress = (WORD)(PBA >> 8);

	return TRUE;
}

//------------------------------------------------------------------------
//    
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::MODULE_TEST(void)
{
	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }

	//        DSP
	WORD TMode1; if(!GET_VAR_WORD(RTUSB2185::D_TEST_VAR1, (SHORT *)&TMode1)) { LastErrorNumber = 18; return FALSE; }
	WORD TMode2; if(!GET_VAR_WORD(RTUSB2185::D_TEST_VAR2, (SHORT *)&TMode2)) { LastErrorNumber = 18; return FALSE; }
	if((TMode1 != 0x5555) || (TMode2 != 0xAAAA)) { LastErrorNumber = 19;  return FALSE; }
	else
	{
		WORD Ready;
		WORD TimeOut = 40;

		//   D_TEST_INTR   DSP
		if(!PUT_VAR_WORD(RTUSB2185::D_TEST_INTR_VAR, 0x77BB)) { LastErrorNumber = 20; return FALSE; }

		//     DSP    D_READY  '1'
		do
		{
			Sleep(25);
			if(!GET_VAR_WORD(RTUSB2185::D_MODULE_READY, (SHORT *)&Ready)) { LastErrorNumber = 18; return FALSE; }
		} while((!Ready) && (TimeOut--));
		//   
		if(TimeOut == 0xFFFF)  { LastErrorNumber = 21; return FALSE; }

		//   DSP   
		if(!SEND_COMMAND(RTUSB2185::C_TEST)) { LastErrorNumber = 22; return FALSE; }

		Sleep(100);

		//   ,    D_TEST_INTR   0xAA55
		WORD TestLoadVar; if(!GET_VAR_WORD(RTUSB2185::D_TEST_INTR_VAR, (SHORT *)&TestLoadVar)) { LastErrorNumber = 18; return FALSE; }
		if(TestLoadVar != 0xAA55) { LastErrorNumber = 23; return FALSE; }
	}

	return TRUE;
}

//------------------------------------------------------------------------
//     DSP
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::GET_DSP_INFO(RTUSB2185::DSP_INFO * const DspInfo)
{
	WORD i;
	WORD dv;

	//   ,    
	//  DSP (9  + '\0')
	//   USB-2185    "USB2185"
	for(i = 0x0; i < sizeof(DspInfo->Target)/2; i++)
		if(!GET_VAR_WORD((WORD)(RTUSB2185::D_TARGET + i), (SHORT *)&DspInfo->Target[2*i])) { LastErrorNumber = 18; return FALSE; }

	//     DSP (5  + '\0')
	//   DSP   "rtech"
	for(i = 0x0; i < sizeof(DspInfo->Label)/2; i++)
		if(!GET_VAR_WORD((WORD)(RTUSB2185::D_LABEL + i), (SHORT *)&DspInfo->Label[2*i])) { LastErrorNumber = 18; return FALSE; }

	//    DSP
	if(!GET_VAR_WORD(RTUSB2185::D_VERSION, (SHORT *)&dv)) { LastErrorNumber = 18; return FALSE; }
	DspInfo->DspMajor = (BYTE)(dv >> 8);
	DspInfo->DspMinor = (BYTE)(dv & 0xFF);

	return TRUE;
}

//------------------------------------------------------------------------
//    DSP   
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::SEND_COMMAND(const WORD Command)
{
	WORD InBuf[4];
	DWORD cbRet=0;
	WORD TimeOut = 500;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }
	//   
	else if(Command >= RTUSB2185::C_LAST_COMMAND) { LastErrorNumber = 24; return FALSE; }

	//      DSP
	InBuf[0] = 0; InBuf[1] = RTUSB2185::V_COMMAND_IRQ; InBuf[2] = 0x0; InBuf[3] = 0x0;
	//    DSP   
	if(!PUT_VAR_WORD(RTUSB2185::D_COMMAND, Command)) { LastErrorNumber = 20; return FALSE; }

	//   
	EnterCriticalSection(&cs);

	//      DSP 
	if(!DeviceIoControl(hDevice, DIOC_SEND_COMMAND, &InBuf, sizeof(InBuf), NULL, 0, &cbRet, NULL)) { LastErrorNumber = 5; LeaveCriticalSection(&cs); return FALSE; }

	//   
	LeaveCriticalSection(&cs);

	// ,      DSP,
	// .   D_COMMAND   
	do
	{
	   if(!GET_VAR_WORD(RTUSB2185::D_COMMAND, (SHORT *)&Command)) { LastErrorNumber = 18; return FALSE; }
	} while(Command && (TimeOut--));

	//      
	if(TimeOut == 0xFFFF) { LastErrorNumber = 25; return FALSE; }
	else return TRUE;
}

//------------------------------------------------------------------------------
//         
//------------------------------------------------------------------------------
int WINAPI CRTUSB2185::GetLastErrorString(LPTSTR const lpBuffer, DWORD nSize)
{
	return LoadString(hInstance, BASE_ERROR_ID + LastErrorNumber, lpBuffer, nSize);
}



//========================================================================
//        
//========================================================================

//------------------------------------------------------------------------
//       
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::START_READ(void)
{
	WORD InBuf[4];
	DWORD cbRet=0;

	//        ( AVR)
	InBuf[0] = 0; InBuf[1] = RTUSB2185::V_START_READ; InBuf[2] = (WORD)(0x0 | DSP_DM); InBuf[3] = (WORD)(0x1800);
	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }

	//   
	EnterCriticalSection(&cs);

	//      ( AVR)
	if(!DeviceIoControl(hDevice, DIOC_SEND_COMMAND, &InBuf, sizeof(InBuf), NULL, 0, &cbRet, NULL)) { LastErrorNumber = 5; LeaveCriticalSection(&cs); return FALSE; }

	//   
	LeaveCriticalSection(&cs);

	//       DSP 
	if(!SEND_COMMAND(RTUSB2185::C_START_READ)) { LastErrorNumber = 22; return FALSE; }
	else return TRUE;
}

//------------------------------------------------------------------------
//     
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::STOP_READ(void)
{
	DWORD cbRet=0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }
	//    DSP    
	else if(!SEND_COMMAND(RTUSB2185::C_STOP_READ)) { LastErrorNumber = 22; return FALSE; }

	//   
	EnterCriticalSection(&cs);

	//     bulk'
	if(!DeviceIoControl(hDevice, DIOC_RESET_PIPE3/*reset Read Pipe*/, NULL, NULL, NULL, NULL, &cbRet, NULL)) { LastErrorNumber = 5; LeaveCriticalSection(&cs); return FALSE; }

	//   
	LeaveCriticalSection(&cs);

	return TRUE;
}

//------------------------------------------------------------------------
//        Bulk
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::ReadData(SHORT * const lpBuffer, DWORD * const nNumberOfWordsToRead, LPDWORD lpNumberOfBytesRead, LPOVERLAPPED lpOverlapped)
{
	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }
	//        0x200(512)
	else if(*nNumberOfWordsToRead < 0x200) *nNumberOfWordsToRead = 0x200;
	//    0x100000(1024*1024)
	else if(*nNumberOfWordsToRead > (1024*1024)) *nNumberOfWordsToRead = 1024*1024;
	//       0x100(512)
	*nNumberOfWordsToRead -= (*nNumberOfWordsToRead)%512;
	//        - 
	return ReadFile(hDevice, (LPVOID)lpBuffer, 2*(*nNumberOfWordsToRead), lpNumberOfBytesRead, lpOverlapped);
}




//========================================================================
//       
//========================================================================

//------------------------------------------------------------------------
//        
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::START_WRITE(void)
{
	WORD InBuf[4];
	DWORD cbRet=0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }

	//   
	EnterCriticalSection(&cs);

	//       ( AVR)
	InBuf[0] = 0; InBuf[1] = RTUSB2185::V_START_WRITE; InBuf[2] = (WORD)(0x3000 | DSP_DM); InBuf[3] = (WORD)(0x7C0);
	if(!DeviceIoControl(hDevice, DIOC_SEND_COMMAND, &InBuf, sizeof(InBuf), NULL, 0, &cbRet, NULL)) { LastErrorNumber = 5; LeaveCriticalSection(&cs); return FALSE; }

	//   
	LeaveCriticalSection(&cs);

	//       DSP 
	if(!SEND_COMMAND(RTUSB2185::C_START_WRITE)) { LastErrorNumber = 22; return FALSE; }
	else return TRUE;
}

//------------------------------------------------------------------------
//        
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::STOP_WRITE(void)
{
	DWORD cbRet=0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }
	//    DSP    
	else if(!SEND_COMMAND(RTUSB2185::C_STOP_WRITE)) { LastErrorNumber = 22; return FALSE; }

	//   
	EnterCriticalSection(&cs);

	//     bulk'
	if(!DeviceIoControl(hDevice, DIOC_RESET_PIPE1/*reset Write Pipe*/, NULL, NULL, NULL, NULL, &cbRet, NULL)) { LastErrorNumber = 5; LeaveCriticalSection(&cs); return FALSE; }

	//   
	LeaveCriticalSection(&cs);

	return TRUE;
}

//------------------------------------------------------------------------
///        Bulk
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::WriteData(SHORT * const lpBuffer, DWORD * const nNumberOfWordsToWrite, LPDWORD lpNumberOfBytesWritten, LPOVERLAPPED lpOverlapped)
{
	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }
	//        0x20(32)
	else if(*nNumberOfWordsToWrite < 0x20) *nNumberOfWordsToWrite = 0x20;
	//    0x100000(1024*1024)
	else if(*nNumberOfWordsToWrite > (1024*1024)) *nNumberOfWordsToWrite = 1024*1024;
	//       0x20(32)
	*nNumberOfWordsToWrite -= (*nNumberOfWordsToWrite)%32;

	return WriteFile(hDevice, (LPVOID)lpBuffer, 2*(*nNumberOfWordsToWrite), lpNumberOfBytesWritten, lpOverlapped);
}



//========================================================================
//       
//========================================================================

//------------------------------------------------------------------------
//    
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::GET_FLASH(RTUSB2185::FLASH * const fi)
{
	WORD InBuf[4];
	DWORD cbRet=0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }

	//   
	EnterCriticalSection(&cs);

	//     
	InBuf[0] = 1; InBuf[1] = RTUSB2185::V_GET_FLASH; InBuf[2] = (WORD)(0x1E00); InBuf[3] = 0x0;
	//     
  	if(!DeviceIoControl(hDevice,DIOC_SEND_COMMAND, &InBuf, sizeof(InBuf), fi, 256/*bytes*/, &cbRet, NULL)) { LastErrorNumber = 5; LeaveCriticalSection(&cs); return FALSE; }

	//   
	LeaveCriticalSection(&cs);

	return TRUE;
}

//------------------------------------------------------------------------
//    
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::PUT_FLASH(RTUSB2185::FLASH * const fi)
{
	WORD InBuf[4];
	DWORD cbRet=0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }

	//   
	EnterCriticalSection(&cs);

	//     
	InBuf[0] = 0; InBuf[1] = RTUSB2185::V_PUT_FLASH; InBuf[2] = (WORD)(0x1E00); InBuf[3] = 0x0;
	//     
  	if(!DeviceIoControl(hDevice,DIOC_SEND_COMMAND, &InBuf, sizeof(InBuf), fi, 256/*bytes*/, &cbRet, NULL)) { LastErrorNumber = 5; LeaveCriticalSection(&cs); return FALSE; }

	//   
	LeaveCriticalSection(&cs);

	return TRUE;
}




//========================================================================
//       DSP 
//========================================================================

//------------------------------------------------------------------------
//          DSP
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::PUT_VAR_WORD(WORD Address, SHORT Data)
{
	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }
	else if((Address < VarsBaseAddress) || (Address > ProgramBaseAddress)) { LastErrorNumber = 29; return FALSE; }
	else if(!PUT_PM_WORD(Address, (LONG)Data<<8)) { LastErrorNumber = 30; return FALSE; }
	return TRUE;
}

//------------------------------------------------------------------------
//          DSP
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::GET_VAR_WORD(WORD Address, SHORT * const Data)
{
	LONG PmData;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }
	else if((Address < VarsBaseAddress) || (Address > ProgramBaseAddress)) { LastErrorNumber = 29; return FALSE; }
	else if(!GET_PM_WORD(Address, &PmData)) { LastErrorNumber = 31; return FALSE; }
	*Data = (SHORT)(PmData >> 8);

	return TRUE;
}

//------------------------------------------------------------------------
//        DSP
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::PUT_DM_WORD(const WORD Address, SHORT Data)
{
	BOOL status;
	WORD InBuf[4];
	DWORD cbRet=0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }

	//   
	EnterCriticalSection(&cs);

	//        DSP
	InBuf[0] = 0; InBuf[1] = RTUSB2185::V_PUT_ARRAY; InBuf[2] = (WORD)(Address | DSP_DM); InBuf[3] = 0x0;
	//   
	status = DeviceIoControl( hDevice,DIOC_SEND_COMMAND,
                             &InBuf,sizeof(InBuf),
                             &Data, 2/*bytes*/,
                             &cbRet,NULL);

	//   
	LeaveCriticalSection(&cs);

	//   :)))))
	if(status) return TRUE;
	//   DeviceIoControl()
	else { LastErrorNumber = 5; return FALSE; }
}

//------------------------------------------------------------------------
//        DSP
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::GET_DM_WORD(WORD Address, SHORT * const Data)
{
	BOOL status;
	WORD InBuf[4];
	DWORD cbRet=0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }

	//   
	EnterCriticalSection(&cs);

	//        DSP
	InBuf[0] = 1; InBuf[1] = RTUSB2185::V_GET_ARRAY; InBuf[2] = (WORD)(Address | DSP_DM); InBuf[3] = 0x0;
	//   
	status = DeviceIoControl( hDevice,DIOC_SEND_COMMAND,
									&InBuf,sizeof(InBuf),
									 Data, 2/*bytes*/,
									&cbRet,NULL);

	//   
	LeaveCriticalSection(&cs);

	//   :)))))
	if(status) return TRUE;
	//   DeviceIoControl()
	else { LastErrorNumber = 5; return FALSE; }
}

//------------------------------------------------------------------------
//        DSP
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::PUT_PM_WORD(const WORD Address, LONG Data)
{
	BOOL status;
	WORD InBuf[4];
	DWORD cbRet=0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }

	//   
	EnterCriticalSection(&cs);

	//        DSP
	InBuf[0] = 0; InBuf[1] = RTUSB2185::V_PUT_ARRAY; InBuf[2] = (WORD)(Address | DSP_PM); InBuf[3] = 0x0;
	//   
	status = DeviceIoControl( hDevice,DIOC_SEND_COMMAND,
                             &InBuf, sizeof(InBuf),
                             &Data, 4/*bytes*/,
                             &cbRet,NULL);

	//   
	LeaveCriticalSection(&cs);

	//   :)))))
	if(status) return TRUE;
	//   DeviceIoControl()
	else { LastErrorNumber = 5; return FALSE; }
}

//------------------------------------------------------------------------
//        DSP
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::GET_PM_WORD(WORD Address, LONG * const Data)
{
	BOOL status;
	WORD InBuf[4];
	DWORD cbRet=0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }

	//   
	EnterCriticalSection(&cs);

	//        DSP
	InBuf[0] = 1; InBuf[1] = RTUSB2185::V_GET_ARRAY; InBuf[2] = (WORD)(Address | DSP_PM); InBuf[3] = 0x0;
	//   
	status = DeviceIoControl( hDevice,DIOC_SEND_COMMAND,
                             &InBuf,sizeof(InBuf),
                             Data, 4/*bytes*/,
                             &cbRet,NULL);

	//   
	LeaveCriticalSection(&cs);

	//   :)))))
	if(status) return TRUE;
	//   DeviceIoControl()
	else { LastErrorNumber = 5; return FALSE; }
}

//------------------------------------------------------------------------
//         DSP
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::PUT_DM_ARRAY(WORD BaseAddress, WORD NPoints, SHORT * const Data)
{
	BOOL error = FALSE;
	WORD InBuf[4];
	WORD BlockQuantity, RestDataPoints;
	DWORD cbRet = 0x0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }

	BlockQuantity = (WORD)((sizeof(SHORT)*NPoints)/MAX_USB_BLOCK);
	RestDataPoints = (WORD)((sizeof(SHORT)*NPoints)%MAX_USB_BLOCK); //  

	InBuf[0] = 0; InBuf[1] = RTUSB2185::V_PUT_ARRAY; InBuf[3] = 0x0;
	for(WORD i=0; i < BlockQuantity; i++)
	{
		InBuf[2] = (WORD)((BaseAddress + i*MAX_USB_BLOCK/sizeof(SHORT)) | DSP_DM);
		EnterCriticalSection(&cs);
		if(!DeviceIoControl(hDevice,DIOC_SEND_COMMAND, &InBuf, sizeof(InBuf), Data + i*MAX_USB_BLOCK/sizeof(SHORT), MAX_USB_BLOCK/*bytes*/, &cbRet, NULL)) error = TRUE;
		LeaveCriticalSection(&cs);
		if(error) break;
	}

	if(!error && RestDataPoints)
	{
		InBuf[2] = (WORD)((BaseAddress + BlockQuantity*MAX_USB_BLOCK/sizeof(SHORT)) | DSP_DM);
		EnterCriticalSection(&cs);
		if(!DeviceIoControl(hDevice,DIOC_SEND_COMMAND, &InBuf, sizeof(InBuf), Data + BlockQuantity*MAX_USB_BLOCK/sizeof(SHORT), RestDataPoints/*bytes*/, &cbRet, NULL)) error = TRUE;
		LeaveCriticalSection(&cs);
	}

	if(error) { LastErrorNumber = 5; return FALSE; }
	return TRUE;
}

//------------------------------------------------------------------------
//         DSP
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::GET_DM_ARRAY(WORD BaseAddress, WORD NPoints, SHORT * const Data)
{
	BOOL error = FALSE;
	WORD InBuf[4];
	WORD BlockQuantity, RestDataPoints;
	DWORD cbRet = 0x0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }

	BlockQuantity = (WORD)((sizeof(SHORT)*NPoints)/MAX_USB_BLOCK);
	RestDataPoints = (WORD)((sizeof(SHORT)*NPoints)%MAX_USB_BLOCK); //  

	InBuf[0] = 1; InBuf[1] = RTUSB2185::V_GET_ARRAY; InBuf[3] = 0x0;
	for(WORD i=0; i < BlockQuantity; i++)
	{
		InBuf[2] = (WORD)((BaseAddress + i*MAX_USB_BLOCK/sizeof(SHORT)) | DSP_DM);
		EnterCriticalSection(&cs);
		if(!DeviceIoControl( hDevice, DIOC_SEND_COMMAND, &InBuf,sizeof(InBuf), Data + i*MAX_USB_BLOCK/sizeof(SHORT), MAX_USB_BLOCK/*bytes*/, &cbRet, NULL)) error = TRUE;
		LeaveCriticalSection(&cs);
		if(error) break;
	}

	if(!error && RestDataPoints)
	{
		InBuf[2] = (WORD)((BaseAddress + BlockQuantity*MAX_USB_BLOCK/sizeof(SHORT)) | DSP_DM);
		EnterCriticalSection(&cs);
		if(!DeviceIoControl(hDevice, DIOC_SEND_COMMAND, &InBuf, sizeof(InBuf), Data + BlockQuantity*MAX_USB_BLOCK/sizeof(SHORT), RestDataPoints/*bytes*/, &cbRet, NULL)) error = TRUE;
		LeaveCriticalSection(&cs);
	}

	if(error) { LastErrorNumber = 5; return FALSE; }
	return TRUE;
}

//------------------------------------------------------------------------
//         DSP
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::PUT_PM_ARRAY(WORD BaseAddress, WORD NPoints, LONG * const Data)
{
	BOOL error = FALSE;
	WORD InBuf[4];
	WORD BlockQuantity, RestDataPoints;
	DWORD cbRet=0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }

	BlockQuantity = (WORD)((sizeof(LONG)*NPoints)/MAX_USB_BLOCK);
	RestDataPoints = (WORD)((sizeof(LONG)*NPoints)%MAX_USB_BLOCK); //  

	InBuf[0] = 0; InBuf[1] = RTUSB2185::V_PUT_ARRAY; InBuf[3] = 0x0;
	for(WORD i=0; i < BlockQuantity; i++)
	{
		InBuf[2] = (WORD)((BaseAddress + i*MAX_USB_BLOCK/sizeof(LONG)) | DSP_PM);
		EnterCriticalSection(&cs);
		if(!DeviceIoControl(hDevice, DIOC_SEND_COMMAND, &InBuf, sizeof(InBuf), Data + i*MAX_USB_BLOCK/sizeof(LONG), MAX_USB_BLOCK/*bytes*/, &cbRet, NULL)) error = TRUE;
		LeaveCriticalSection(&cs);
		if(error) break;
	}

	if(!error && RestDataPoints)
	{
		InBuf[2] = (WORD)((BaseAddress + BlockQuantity*MAX_USB_BLOCK/sizeof(LONG)) | DSP_PM);
		EnterCriticalSection(&cs);
		if(!DeviceIoControl(hDevice, DIOC_SEND_COMMAND, &InBuf, sizeof(InBuf), Data + BlockQuantity*MAX_USB_BLOCK/sizeof(LONG), RestDataPoints/*bytes*/, &cbRet, NULL)) error = TRUE;
		LeaveCriticalSection(&cs);
	}

	if(error) { LastErrorNumber = 5; return FALSE; }
	return TRUE;
}

//------------------------------------------------------------------------
//         DSP
//------------------------------------------------------------------------
BOOL WINAPI CRTUSB2185::GET_PM_ARRAY(WORD BaseAddress, WORD NPoints, LONG * const Data)
{
	BOOL error = FALSE;
	WORD InBuf[4];
	WORD BlockQuantity, RestDataPoints;
	DWORD cbRet=0;

	//   ?
	if(hDevice == INVALID_HANDLE_VALUE) { LastErrorNumber = 4; return FALSE; }

	BlockQuantity = (WORD)((sizeof(LONG)*NPoints)/MAX_USB_BLOCK);
	RestDataPoints = (WORD)((sizeof(LONG)*NPoints)%MAX_USB_BLOCK); //  

	InBuf[0] = 1; InBuf[1] = RTUSB2185::V_GET_ARRAY; InBuf[3] = 0x0;
	for(WORD i=0; i < BlockQuantity; i++)
	{
		InBuf[2] = (WORD)((BaseAddress + i*MAX_USB_BLOCK/sizeof(LONG)) | DSP_PM);
		EnterCriticalSection(&cs);
		if(!DeviceIoControl(hDevice, DIOC_SEND_COMMAND, &InBuf, sizeof(InBuf), Data + i*MAX_USB_BLOCK/sizeof(LONG), MAX_USB_BLOCK/*bytes*/, &cbRet, NULL)) error = TRUE;
		LeaveCriticalSection(&cs);
		if(error) break;
	}

	if(!error && RestDataPoints)
	{
		InBuf[2] = (WORD)((BaseAddress + BlockQuantity*MAX_USB_BLOCK/sizeof(LONG)) | DSP_PM);
		EnterCriticalSection(&cs);
		if(!DeviceIoControl(hDevice, DIOC_SEND_COMMAND, &InBuf, sizeof(InBuf), Data + BlockQuantity*MAX_USB_BLOCK/sizeof(LONG), RestDataPoints/*bytes*/, &cbRet, NULL)) error = TRUE;
		LeaveCriticalSection(&cs);
	}

	if(error) { LastErrorNumber = 5; return FALSE; }
	return TRUE;
}



//------------------------------------------------------------------------------
//     Windows
//------------------------------------------------------------------------------
DWORD CRTUSB2185::GetWindowsVersion(void)
{
	OSVERSIONINFO osvi;

	ZeroMemory(&osvi, sizeof(OSVERSIONINFO));
	osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);

	if(!GetVersionEx(&osvi))
	{
		osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
		if(!GetVersionEx((OSVERSIONINFO *)&osvi)) return UNKNOWN_WINDOWS_VERSION;
	}

	switch (osvi.dwPlatformId)
	{
		case VER_PLATFORM_WIN32_NT:
			if(osvi.dwMajorVersion <= 4 ) return WINDOWS_NT; 		// WinNT
			else if((osvi.dwMajorVersion == 5) && (osvi.dwMinorVersion == 0)) return WINDOWS_2000; 			// Win2000
			else if((osvi.dwMajorVersion == 5) && (osvi.dwMinorVersion == 1)) return WINDOWS_XP; 				// WinXP
			else if((osvi.dwMajorVersion == 5) && (osvi.dwMinorVersion == 2)) return WINDOWS_2003_SERVER; 	// Win2003 Server
			else if(osvi.dwMajorVersion == 6) return WINDOWS_VISTA; 	// Vista
			else return UNKNOWN_WINDOWS_VERSION;

		case VER_PLATFORM_WIN32_WINDOWS:
			if((osvi.dwMajorVersion > 0x4) || ((osvi.dwMajorVersion == 0x4)&&(osvi.dwMinorVersion > 0x0))) return WINDOWS_98_OR_LATER; // Win98 or later
			else return WINDOWS_95; 											// Win95

		case VER_PLATFORM_WIN32s: return WINDOWS_32S; 					// Win32s
	}

	return UNKNOWN_WINDOWS_VERSION;
}

//------------------------------------------------------------------------
//  
//------------------------------------------------------------------------
LONG *CRTUSB2185::Transform_Buffer(WORD PmPoints, LONG * const Buffer)
{
	for(WORD i=0; i < PmPoints; i++) Buffer[i] = ((Buffer[i] & 0x0000FFFF) << 8) | ((Buffer[i] & 0x00FF0000) >> 16);
	return Buffer;
}
