/* CIN source file */

#include "extcode.h"
#include <windows.h>
#include <stdio.h>
#include "..\..\..\Include\wrRtusbapi.h"

/* Typedefs */

typedef struct {
	int32 dimSize;
	int16 BufferEl[1];
	} TD4;
typedef TD4 **TD4Hdl;

typedef struct {
	TD4Hdl Buffer;
	uInt32 ReadOv;
	uInt32 ReadEvent;
	} TD3;

typedef struct {
	int32 dimSize;
	TD3 ReadBufferPars[1];
	} TD2;
typedef TD2 **TD2Hdl;

typedef struct {
	TD4Hdl Buffer;
	uInt32 WriteOv;
	uInt32 WriteEvent;
	} TD6;

typedef struct {
	int32 dimSize;
	TD6 WriteBufferPars[1];
	} TD5;
typedef TD5 **TD5Hdl;

typedef struct {
	uInt32 DllVersion;
	uInt32 InterfaceType;
	uInt32 InterfaceInstance;
	uInt32 ModuleHandle;
	TD2Hdl ReadBuffersParsArray;
	TD5Hdl WriteBuffersParsArray;
	} TD1;

typedef struct {
	LVBoolean Status;
	uInt32 ViErrorNumber;
	LStrHandle ViName;
	LStrHandle ViErrorString;
	LStrHandle CinName;
	LStrHandle CinErrorString;
	} TD7;

enum {UNKNOWN_MODULE, USB2185_MODULE, USB3000_MODULE};

//  㭪権
CIN MgErr CINRun(TD1 *InterfaceInfo, TD7 *ViStatus);
CIN MgErr CINProperties(int32 prop, void *data);

// ---------------------------------------------------------------
// 
// ---------------------------------------------------------------
MgErr CINRun(TD1 *InterfaceInfo, TD7 *ViStatus)
{
	// 㪠⥫  䥩 
	LPVOID pModule;
	// 訡 ணࠬ LabVIEW
//	MgErr Error;

	// ᬮਬ 뫠  訡  । CIN		
	if(ViStatus->Status == LVFALSE) return noErr;

	// 㪠⥫  䥩 
	pModule = (LPVOID)InterfaceInfo->InterfaceInstance;

	//   㫥 ࠡ⠥?
	if(InterfaceInfo->InterfaceType == USB3000_MODULE)
	{
		//   ⮢ 䥩  㫥 USB3000?
		if(pModule != NULL)
		{
			// ⥯ ⠭  
			if(!STOP_READ_Usb3000(pModule))
			{
				ViStatus->Status= LVFALSE; return noErr;
			}
		}       
		else
		{
			ViStatus->Status= LVFALSE;
		}
	}
	else 
	{ 
		ViStatus->Status= LVFALSE; 
	}

	return noErr;
}

// ---------------------------------------------------------------
// 塞,   CIN - ⮪
// ---------------------------------------------------------------
CIN MgErr CINProperties(int32 prop, void *data)
{
	switch (prop) 
	{
		case kCINIsReentrant:
		*(Bool32 *)data = TRUE;
		return noErr;
	}
	return mgNotSupported;
}
