/* CIN source file */

#include "extcode.h"
#include <windows.h>
#include <stdio.h>
#include "..\..\..\Include\wrRtusbapi.h"

/* Typedefs */

typedef struct {
	int32 dimSize;
	int16 BufferEl[1];
	} TD4;
typedef TD4 **TD4Hdl;

typedef struct {
	TD4Hdl Buffer;
	uInt32 ReadOv;
	uInt32 ReadEvent;
	} TD3;

typedef struct {
	int32 dimSize;
	TD3 ReadBufferPars[1];
	} TD2;
typedef TD2 **TD2Hdl;

typedef struct {
	TD4Hdl Buffer;
	uInt32 WriteOv;
	uInt32 WriteEvent;
	} TD6;

typedef struct {
	int32 dimSize;
	TD6 WriteBufferPars[1];
	} TD5;
typedef TD5 **TD5Hdl;

typedef struct {
	uInt32 DllVersion;
	uInt32 InterfaceType;
	uInt32 InterfaceInstance;
	uInt32 ModuleHandle;
	TD2Hdl ReadBuffersParsArray;
	TD5Hdl WriteBuffersParsArray;
	} TD1;

typedef struct {
	int32 dimSize;
	uInt16 LogicalChannel[1];
	} TD8;
typedef TD8 **TD8Hdl;

typedef struct {
	int32 dimSize;
	float64 AdcOffsetCoef[1];
	} TD9;
typedef TD9 **TD9Hdl;

typedef struct {
	int32 dimSize;
	float64 AdcScaleCoef[1];
	} TD10;
typedef TD10 **TD10Hdl;

typedef struct {
	int32 dimSize;
	uInt32 BufferLength[1];
	} TD11;
typedef TD11 **TD11Hdl;

typedef struct {
	uInt16 size;
	LVBoolean InputEnabled;
	LVBoolean CorrectionEnabled;
	uInt16 InputClockSource;
	uInt16 InputType;
	uInt16 SynchroType;
	uInt16 SynchroAdType;
	uInt16 SynchroAdMode;
	uInt16 SynchroAdChannel;
	int16 SynchroAdPorog;
	uInt16 ChannelsQuantity;
	TD8Hdl ControlTable;
	uInt16 InputFifoBaseAddress;
	uInt16 InputFifoLength;
	float64 InputRate;
	float64 InterKadrDelay;
	float64 ChannelRate;
	TD9Hdl AdcOffsetCoefArray;
	TD10Hdl AdcScaleCoefArray;
	TD11Hdl BuffersLengthArray;
	} TD7;

typedef struct {
	LVBoolean Status;
	uInt32 ViErrorNumber;
	LStrHandle ViName;
	LStrHandle ViErrorString;
	LStrHandle CinName;
	LStrHandle CinErrorString;
	} TD12;

#define CONTROL_TABLE_LENGTH			(128)
#define ADC_OFFSET_COEF_QUANTITY		(0x8)
#define ADC_SCALE_COEF_QUANTITY			(0x8)

enum {UNKNOWN_MODULE, USB2185_MODULE, USB3000_MODULE};

//  
CIN MgErr CINRun(TD1 *InterfaceInfo, TD7 *InputPars, TD12 *ViStatus);
CIN MgErr CINProperties(int32 prop, void *data);

// ---------------------------------------------------------------
// 
// ---------------------------------------------------------------
MgErr CINRun(TD1 *InterfaceInfo, TD7 *InputPars, TD12 *ViStatus)
{
	uInt16 i;
	//    
	INPUT_PARS_USB3000 ip;
	//    
	LPVOID pModule;
	//   LabVIEW
	MgErr Error;
	//   		
	TD4Hdl NewArrayHandle;

	//       CIN		
	if(ViStatus->Status == LVFALSE) return noErr;

	//    
	pModule = (LPVOID)InterfaceInfo->InterfaceInstance;

	//    ?
	if(InterfaceInfo->InterfaceType == USB3000_MODULE)
	{
		//       USB3000?
		if(pModule != NULL)
		{
			//    size  INPUT_PARS_USB3000
			ip.size = sizeof(INPUT_PARS_USB3000);
			//  /   (  )
			ip.InputEnabled = InputPars->InputEnabled;
			//     ( )
			ip.CorrectionEnabled = InputPars->CorrectionEnabled;
			//        
			ip.InputClockSource = InputPars->InputClockSource;
			//      (  )
			ip.InputType = InputPars->InputType;								
			//      
			ip.SynchroType = InputPars->SynchroType;							
			//   
			ip.SynchroAdType = InputPars->SynchroAdType;
			//   
			ip.SynchroAdMode = InputPars->SynchroAdMode;
			//     
			ip.SynchroAdChannel = InputPars->SynchroAdChannel;
			//      
			ip.SynchroAdPorog = InputPars->SynchroAdPorog;
			//    
			ip.ChannelsQuantity = InputPars->ChannelsQuantity;
			//      
			for(i = 0x0; i < CONTROL_TABLE_LENGTH; i++) 
				ip.ControlTable[i] = (*InputPars->ControlTable)->LogicalChannel[i];	
			//   FIFO    DSP 
			ip.InputFifoBaseAddress = InputPars->InputFifoBaseAddress;
			//  FIFO    DSP 
			ip.InputFifoLength = InputPars->InputFifoLength;
			//      
			ip.InputRate = InputPars->InputRate;
			//    
			ip.InterKadrDelay = InputPars->InterKadrDelay;
			//     
			ip.ChannelRate = InputPars->ChannelRate;
			//    
			for(i = 0x0; i < ADC_OFFSET_COEF_QUANTITY; i++)
				if(ip.CorrectionEnabled) ip.AdcOffsetCoef[i] = (*InputPars->AdcOffsetCoefArray)->AdcOffsetCoef[i];
				else ip.AdcOffsetCoef[i] = 0.0; 
			//   
			for(i = 0x0; i < ADC_SCALE_COEF_QUANTITY; i++)
				if(ip.CorrectionEnabled) ip.AdcScaleCoef[i] = (*InputPars->AdcScaleCoefArray)->AdcScaleCoef[i];
				else ip.AdcScaleCoef[i] = 1.0; 

			//      
			if(!SET_INPUT_PARS_Usb3000(pModule, &ip))
			{
				ViStatus->Status= LVFALSE; return noErr;
			}

			//      
			InputPars->size = sizeof(TD2);
			//  /   (  )
			if(ip.InputEnabled) InputPars->InputEnabled = LVTRUE;
			else InputPars->InputEnabled = LVFALSE;
			//     ( )
			if(ip.CorrectionEnabled) InputPars->CorrectionEnabled = LVTRUE;
			else InputPars->CorrectionEnabled = LVFALSE;
			//       
			InputPars->InputClockSource = ip.InputClockSource;
			//      (  )
			InputPars->InputType = ip.InputType;
			//      
			InputPars->SynchroType = ip.SynchroType;
			//   
			InputPars->SynchroAdType = ip.SynchroAdType;
			//   
			InputPars->SynchroAdMode = ip.SynchroAdMode;
			//     
			InputPars->SynchroAdChannel = ip.SynchroAdChannel;
			//      
			InputPars->SynchroAdPorog = ip.SynchroAdPorog;
			//    
			InputPars->ChannelsQuantity = ip.ChannelsQuantity;
			//      
			for(i = 0x0; i < InputPars->ChannelsQuantity; i++)
				(*InputPars->ControlTable)->LogicalChannel[i] = ip.ControlTable[i];
			//   FIFO    DSP 
			InputPars->InputFifoBaseAddress = ip.InputFifoBaseAddress;
			//  FIFO    DSP 
			InputPars->InputFifoLength = ip.InputFifoLength;
			//      
			InputPars->InputRate = ip.InputRate;
			//    
			InputPars->InterKadrDelay = ip.InterKadrDelay;
			//     
			InputPars->ChannelRate = ip.ChannelRate;
			//  .    
			for(i = 0x0; i < ADC_OFFSET_COEF_QUANTITY; i++)
				(*InputPars->AdcOffsetCoefArray)->AdcOffsetCoef[i]= ip.AdcOffsetCoef[i];
			//  .   
			for(i = 0x0; i < ADC_SCALE_COEF_QUANTITY; i++)
				(*InputPars->AdcScaleCoefArray)->AdcScaleCoef[i]= ip.AdcScaleCoef[i];


			//         
			for(i = 0x0; i < (*InterfaceInfo->ReadBuffersParsArray)->dimSize; i++)
			{
				//     
				Error = NumericArrayResize(iW, 1L, (UHandle*)&(*InterfaceInfo->ReadBuffersParsArray)->ReadBufferPars[i].Buffer, 0x0);
				if(Error != noErr) { ViStatus->Status= LVFALSE; }
				else (*(*InterfaceInfo->ReadBuffersParsArray)->ReadBufferPars[i].Buffer)->dimSize = 0x0;
				//       
				Error = DSDisposeHandle((*InterfaceInfo->ReadBuffersParsArray)->ReadBufferPars[i].Buffer);
				if(Error != noErr) { ViStatus->Status= LVFALSE; }

				//   ReadEvent
				if(!CloseHandle((HANDLE)((*InterfaceInfo->ReadBuffersParsArray)->ReadBufferPars[i].ReadEvent)))
				{
					ViStatus->Status= LVFALSE;
				}
				(*InterfaceInfo->ReadBuffersParsArray)->ReadBufferPars[i].ReadEvent = (DWORD)INVALID_HANDLE_VALUE;

				//   OVERLAPPED
				free((void *)((*InterfaceInfo->ReadBuffersParsArray)->ReadBufferPars[i].ReadOv));
				(*InterfaceInfo->ReadBuffersParsArray)->ReadBufferPars[i].ReadOv = (DWORD)NULL;
			}
			//          
			Error = NumericArrayResize(uB, 1L, (UHandle*)&InterfaceInfo->ReadBuffersParsArray, 0x0);
			if(Error != noErr) { ViStatus->Status= LVFALSE; return Error; }
			(*InterfaceInfo->ReadBuffersParsArray)->dimSize = 0x0;


			//        
			Error = NumericArrayResize(uB, 1L, (UHandle*)&InterfaceInfo->ReadBuffersParsArray, (*InputPars->BuffersLengthArray)->dimSize * sizeof(TD3));
			if(Error == noErr) 
			{ 
				(*InterfaceInfo->ReadBuffersParsArray)->dimSize = (*InputPars->BuffersLengthArray)->dimSize;

				//        
				for(i = 0x0; i < (*InterfaceInfo->ReadBuffersParsArray)->dimSize; i++)
				{
					//  handle    
					NewArrayHandle = (TD4Hdl)DSNewHandle(sizeof(TD4));
					if(!NewArrayHandle) { ViStatus->Status= LVFALSE; }
					(*InterfaceInfo->ReadBuffersParsArray)->ReadBufferPars[i].Buffer = NewArrayHandle;

					//      
					Error = NumericArrayResize(iW, 1L, (UHandle*)&(*InterfaceInfo->ReadBuffersParsArray)->ReadBufferPars[i].Buffer, (*InputPars->BuffersLengthArray)->BufferLength[i]);
					if(Error != noErr) { ViStatus->Status= LVFALSE; }
					else (*(*InterfaceInfo->ReadBuffersParsArray)->ReadBufferPars[i].Buffer)->dimSize = (*InputPars->BuffersLengthArray)->BufferLength[i];

					//   ReadEvent
					(*InterfaceInfo->ReadBuffersParsArray)->ReadBufferPars[i].ReadEvent = (DWORD)CreateEvent(NULL, FALSE, FALSE, NULL);
					if((*InterfaceInfo->ReadBuffersParsArray)->ReadBufferPars[i].ReadEvent == (DWORD)NULL)
					{
						ViStatus->Status= LVFALSE;
					}

					//   OVERLAPPED
					(*InterfaceInfo->ReadBuffersParsArray)->ReadBufferPars[i].ReadOv = (DWORD)((LPOVERLAPPED)malloc(sizeof(OVERLAPPED)));
					//     OVERLAPPED
					memset((LPOVERLAPPED)((*InterfaceInfo->ReadBuffersParsArray)->ReadBufferPars[i].ReadOv), 0, sizeof(OVERLAPPED)); 
					//     OVERLAPPED
					((LPOVERLAPPED)((*InterfaceInfo->ReadBuffersParsArray)->ReadBufferPars[i].ReadOv))->hEvent = (HANDLE)((*InterfaceInfo->ReadBuffersParsArray)->ReadBufferPars[i].ReadEvent);
				}
			}
			else { ViStatus->Status= LVFALSE; }
		}
		else
		{
			ViStatus->Status= LVFALSE;
		}
	}
	else 
	{ 
		ViStatus->Status= LVFALSE; 
	}

	return noErr;
}

// ---------------------------------------------------------------
// ,   CIN - 
// ---------------------------------------------------------------
CIN MgErr CINProperties(int32 prop, void *data)
{
	switch (prop) 
	{
		case kCINIsReentrant:
		*(Bool32 *)data = TRUE;
		return noErr;
	}
	return mgNotSupported;
}
