/* CIN source file */

#include "extcode.h"
#include <windows.h>
#include <stdio.h>
#include "..\..\..\Include\wrRtusbapi.h"

/* Typedefs */

typedef struct {
	int32 dimSize;
	int16 BufferEl[1];
	} TD4;
typedef TD4 **TD4Hdl;

typedef struct {
	TD4Hdl Buffer;
	uInt32 ReadOv;
	uInt32 ReadEvent;
	} TD3;

typedef struct {
	int32 dimSize;
	TD3 ReadBufferPars[1];
	} TD2;
typedef TD2 **TD2Hdl;

typedef struct {
	TD4Hdl Buffer;
	uInt32 WriteOv;
	uInt32 WriteEvent;
	} TD6;

typedef struct {
	int32 dimSize;
	TD6 WriteBufferPars[1];
	} TD5;
typedef TD5 **TD5Hdl;

typedef struct {
	uInt32 DllVersion;
	uInt32 InterfaceType;
	uInt32 InterfaceInstance;
	uInt32 ModuleHandle;
	TD2Hdl ReadBuffersParsArray;
	TD5Hdl WriteBuffersParsArray;
	} TD1;

typedef struct {
	uInt32 ReadBufferIndex;
	uInt32 NumberOfWordsToRead;
	LVBoolean RequestStatus;
	} TD7;

typedef struct {
	LVBoolean Status;
	uInt32 ViErrorNumber;
	LStrHandle ViName;
	LStrHandle ViErrorString;
	LStrHandle CinName;
	LStrHandle CinErrorString;
	} TD8;


enum {UNKNOWN_MODULE, USB2185_MODULE, USB3000_MODULE};

//  㭪権
CIN MgErr CINRun(TD1 *InterfaceInfo, TD7 *ReadPars, TD8 *ViStatus);
CIN MgErr CINProperties(int32 prop, void *data);

// ---------------------------------------------------------------
// 
// ---------------------------------------------------------------
CIN MgErr CINRun(TD1 *InterfaceInfo, TD7 *ReadPars, TD8 *ViStatus)
{
	// 쭠 ६   ᯮ㥬 
	uInt32 rbi;
	// 㪠⥫  䥩 
	LPVOID pModule;
	// 訡 ணࠬ LabVIEW
//	MgErr Error;
	// 쭠 ६  . ReadData()
	DWORD NumberOfBytesRead;

	// ᬮਬ 뫠  訡  । CIN		
	if(ViStatus->Status == LVFALSE) return noErr;

	// 㪠⥫  䥩 
	pModule = (LPVOID)InterfaceInfo->InterfaceInstance;

	//   㫥 ࠡ⠥?
	if(InterfaceInfo->InterfaceType == USB3000_MODULE)
	{
		//   ⮢ 䥩  㫥 USB3000?
		if(pModule != NULL)
		{
			// ஢ਬ 뤥      
			if((*InterfaceInfo->ReadBuffersParsArray)->dimSize == 0x0)
			{
				ViStatus->Status= LVFALSE; return noErr;
			}

			// ࠤ ⪮ ᠭ
			rbi = ReadPars->ReadBufferIndex;

			//  ᯮ㥬    ॢ 
			if(rbi > (uInt32)((*InterfaceInfo->ReadBuffersParsArray)->dimSize))
			{
				ViStatus->Status= LVFALSE; return noErr;
			}

			// ᫮ 襭 ⮢   ॢ 稭 뤥 
			if(ReadPars->NumberOfWordsToRead > (uInt32)((*(*InterfaceInfo->ReadBuffersParsArray)->ReadBufferPars[rbi].Buffer)->dimSize))
			{
				ViStatus->Status= LVFALSE; return noErr;
			}

			// ᨬ  襭 믮 ⥪饣   ᡮ 
			ReadPars->RequestStatus = LVFALSE;

			// ᫮ ⮢  室    0x200(512)
			if(ReadPars->NumberOfWordsToRead < 0x200) ReadPars->NumberOfWordsToRead = 0x200;
			//    0x100000(1024*1024)
			else if(ReadPars->NumberOfWordsToRead > (1024*1024)) ReadPars->NumberOfWordsToRead = 1024*1024;
			// ⠪ ᫮ ⮢   ⭮ 0x200(512)
			ReadPars->NumberOfWordsToRead -= (ReadPars->NumberOfWordsToRead)%512;

			//  ᨭ஭   ᡮ 			
			if(!ReadData_Usb3000(pModule, 
				(*(*InterfaceInfo->ReadBuffersParsArray)->ReadBufferPars[rbi].Buffer)->BufferEl, 
				&ReadPars->NumberOfWordsToRead,
				&NumberOfBytesRead,
				((LPOVERLAPPED)((*InterfaceInfo->ReadBuffersParsArray)->ReadBufferPars[rbi].ReadOv))))
					if(GetLastError() != ERROR_IO_PENDING)
					{
						ViStatus->Status= LVFALSE;
					}
		}       
		else
		{
			ViStatus->Status= LVFALSE;
		}
	}
	else 
	{ 
		ViStatus->Status= LVFALSE; 
	}

	return noErr;
}

// ---------------------------------------------------------------
// 塞,   CIN - ⮪
// ---------------------------------------------------------------
CIN MgErr CINProperties(int32 prop, void *data)
{
	switch (prop) 
	{
		case kCINIsReentrant:
		*(Bool32 *)data = TRUE;
		return noErr;
	}
	return mgNotSupported;
}
