/* CIN source file */

#include "extcode.h"
#include <windows.h>
#include "..\..\..\Include\wrRtusbapi.h"

/* Typedefs */

typedef struct {
	int32 dimSize;
	int16 BufferEl[1];
	} TD4;
typedef TD4 **TD4Hdl;

typedef struct {
	TD4Hdl Buffer;
	uInt32 ReadOv;
	uInt32 ReadEvent;
	} TD3;

typedef struct {
	int32 dimSize;
	TD3 ReadBufferPars[1];
	} TD2;
typedef TD2 **TD2Hdl;

typedef struct {
	TD4Hdl Buffer;
	uInt32 WriteOv;
	uInt32 WriteEvent;
	} TD6;

typedef struct {
	int32 dimSize;
	TD6 WriteBufferPars[1];
	} TD5;
typedef TD5 **TD5Hdl;

typedef struct {
	uInt32 DllVersion;
	uInt32 InterfaceType;
	uInt32 InterfaceInstance;
	uInt32 ModuleHandle;
	TD2Hdl ReadBufferParsArray;
	TD5Hdl WriteBuffersParsArray;
	} TD1;

typedef struct {
	LVBoolean Status;
	uInt32 ViErrorNumber;
	LStrHandle ViName;
	LStrHandle ViErrorString;
	LStrHandle CinName;
	LStrHandle CinErrorString;
	} TD7;

#define	VI_NAME_STRING_LENGTH		(32)
#define	VI_ERROR_STRING_LENGTH		(128)
#define	CIN_NAME_STRING_LENGTH		(32)
#define	CIN_ERROR_STRING_LENGTH		(128)

enum {UNKNOWN_MODULE, USB2185_MODULE, USB3000_MODULE};

//  㭪権
CIN MgErr CINRun(TD1 *InterfaceInfo, TD7 *ViStatus);
CIN MgErr CINProperties(int32 prop, void *data);

// ---------------------------------------------------------------
// 
// ---------------------------------------------------------------
MgErr CINRun(TD1 *InterfaceInfo, TD7 *ViStatus)
{
	MgErr Error;

	// ⠭ 䫠,    浪
	ViStatus->Status= LVTRUE;

	//  㦥 뤥﫨      VI?
	if(LStrLen(*ViStatus->ViName) != VI_NAME_STRING_LENGTH)
	{
		// 뤥      VI
		Error = NumericArrayResize(uB, 1L, (UHandle*)&ViStatus->ViName, VI_NAME_STRING_LENGTH);
		if(Error != noErr) { ViStatus->Status= LVFALSE; return Error; }
		LStrLen(*ViStatus->ViName) = VI_NAME_STRING_LENGTH;
	}

	//  㦥 뤥﫨     訡  VI?
	if(LStrLen(*ViStatus->ViErrorString) != VI_ERROR_STRING_LENGTH)
	{
		// 뤥      訡  VI
		Error = NumericArrayResize(uB, 1L, (UHandle*)&ViStatus->ViErrorString, VI_ERROR_STRING_LENGTH);
		if(Error != noErr) { ViStatus->Status= LVFALSE; return Error; }
		LStrLen(*ViStatus->ViErrorString) = VI_ERROR_STRING_LENGTH;
	}
	// 㥬    ⢨ 訡
	strcpy(LStrBuf(*ViStatus->ViErrorString), "No VIs with Errors \n");
	

	//  㦥 뤥﫨      CIN?
	if(LStrLen(*ViStatus->CinName) != CIN_NAME_STRING_LENGTH)
	{
		// 뤥       CIN
		Error = NumericArrayResize(uB, 1L, (UHandle*)&ViStatus->CinName, CIN_NAME_STRING_LENGTH);
		if(Error != noErr) { ViStatus->Status= LVFALSE; return Error; }
		LStrLen(*ViStatus->CinName) = CIN_NAME_STRING_LENGTH;
	}

	//  㦥 뤥﫨     訡  CIN?
	if(LStrLen(*ViStatus->CinErrorString) != CIN_ERROR_STRING_LENGTH)
	{
		// 뤥      訡  VI
		Error = NumericArrayResize(uB, 1L, (UHandle*)&ViStatus->CinErrorString, CIN_ERROR_STRING_LENGTH);
		if(Error != noErr) { ViStatus->Status= LVFALSE; return Error; }
		LStrLen(*ViStatus->CinErrorString) = CIN_ERROR_STRING_LENGTH;
	}
	// 㥬    ⢨ 訡
	strcpy(LStrBuf(*ViStatus->CinErrorString), "No CINs with Errors ");

	// 稬  ᯮ㥬 DLL
	InterfaceInfo->DllVersion = GetDllVersion_Rtusbapi();
	if(InterfaceInfo->DllVersion == CURRENT_VERSION_RTUSBAPI)
	{

		//   㫥 ࠡ⠥?
		if(InterfaceInfo->InterfaceType == USB3000_MODULE)
		{
			// ஢ਬ   㦥 䥩  㫥 USB3000
			if((LPVOID)InterfaceInfo->InterfaceInstance == NULL)
			{
				InterfaceInfo->InterfaceInstance = (DWORD)CreateInstance_Rtusbapi("usb3000");
				if((LPVOID)InterfaceInfo->InterfaceInstance == NULL)
				{
					ViStatus->Status= LVFALSE;
				}
			}       
			else
			{
				ViStatus->Status= LVFALSE;
			}
		}
		else 
		{ 
			ViStatus->Status= LVFALSE; 
		}

	}
	else 
	{ 
		// ନ㥬    CIN,  ந諠 訡
		strcpy(LStrBuf(*ViStatus->CinErrorString), "CreateInstance ");
		// ନ㥬  c 訡   ᨨ ⥪ Rtusbapi.dll
		// !!! ࠭,    ப 㦥 ஡, 
		// !!! ⮡  ଠ쭮 ⮡ࠦ  ப  
//		strcpy(LStrBuf(*ViStatus->CinErrorString), "Rtusbapi DLL rewg Version Error ");
			
		ViStatus->Status= LVFALSE; 
	}

	// 室
	return noErr;
}

// ---------------------------------------------------------------
// 塞,   CIN - ⮪
// ---------------------------------------------------------------
CIN MgErr CINProperties(int32 prop, void *data)
{
	switch (prop) 
	{
		case kCINIsReentrant:
			*(Bool32 *)data = TRUE;
			return noErr;
	}
	return mgNotSupported;
}
