Attribute VB_Name = "RtUsbModules"

' ==================== WINDOWS API  =======================
' ---   OVERLAPPED  Windows API
Public Type OVERLAPPED
    Internal As Long
    InternalHigh As Long
    offset As Long
    OffsetHigh As Long
    hEvent As Long
End Type

' ---  WinApi
Public Const ERROR_IO_PENDING = 997&   ' Overlapped I/O operation is in progress.
Public Const WAIT_TIMEOUT = &H102&     '   

' --- 
'  
Public Declare Function CreateEvent Lib "kernel32" Alias "CreateEventA" _
               ( _
                  ByVal lpEventAttributes As Long, _
                  ByVal bManualReset As Long, ByVal bInitialState As Long, _
                  ByVal lpName As String) As Long

'  
Public Declare Function CloseHandle Lib "kernel32" _
               ( _
                  ByVal hObject As Long) As Long

'  
Public Declare Function WaitForSingleObject Lib "kernel32" _
               ( _
                  ByVal hHandle As Long, _
                  ByVal dwMilliseconds As Long) As Long
' ================================================================




' ----------------------------------------------------------------
' ----------------- R-Technology Declarations --------------------
' -----------------   U S B   M O D U L E S   --------------------
' ----------------------------------------------------------------

'    Rtusbapi.dll
Public Const VERMAJOR_RTUSBAPI As Integer = &H1
Public Const VERMINOR_RTUSBAPI As Integer = &H5
Public Const CURRENT_VERSION_RTUSBAPI As Long = ((VERMAJOR_RTUSBAPI * (2 ^ 16)) Or VERMINOR_RTUSBAPI)

'  DWORD WINAPI GetDllVersion_Rtusbapi(void)
Public Declare Function GetDllVersion_Rtusbapi Lib "wrRtusbapi.dll" () As Long

'  LPVOID WINAPI RtCreateInstance_Rtusbapi(void)
Public Declare Function CreateInstance_Rtusbapi Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DeviceName As String) As Long



' ****************************************************************
' ************************  USB2185 ************************
' ****************************************************************
'                                 


' ****************************************************************
' ************************  USB3000 ************************
' ****************************************************************

' ===========================  ==========================
' --- ,       USB-3000
Public Type INPUT_PARS_USB3000
        Size As Integer
        InputEnabled As Long
        CorrectionEnabled As Long
        InputClockSource As Integer
        InputType As Integer
        SynchroType As Integer
        SynchroAdType As Integer
        SynchroAdMode As Integer
        SynchroAdChannel As Integer
        SynchroAdPorog As Integer
        ChannelsQuantity As Integer
        ControlTable(1 To 128) As Integer
        InputFifoBaseAddress As Integer
        InputFifoLength As Integer
        InputRate As Double
        InterKadrDelay As Double
        ChannelRate As Double
        AdcOffsetCoef(1 To 8) As Double
        AdcScaleCoef(1 To 8) As Double
End Type

' --- ,       USB-3000
Public Type OUTPUT_PARS_USB3000
        Size As Integer
        OutputEnabled As Boolean
        OutputRate As Double
        OutputFifoBaseAddress As Integer
        OutputFifoLength As Integer
End Type

' ---   
Public Type FLASH_USB3000
        CRC16 As Integer
        Size As Integer
        SerialNumber(1 To 9) As Byte
        ModuleName(1 To 11) As Byte
        Revision As Byte
        DspType(1 To 17) As Byte
        IsDacPresented As Byte
        DspClockout As Long
        AdcOffsetCoef(1 To 8) As Single
        AdcScaleCoef(1 To 8) As Single
        DacOffsetCoef(1 To 2) As Single
        DacScaleCoef(1 To 2) As Single
        ReservedByte(1 To 129) As Byte
End Type

' --- ,      DSP
Public Type DSP_INFO_USB3000
        Target(1 To 10) As Byte
        Label(1 To 6) As Byte
        DspMajor As Byte
        DspMinor As Byte
End Type

'       
Public Enum InputClockSource_USB3000
        INTERNAL_INPUT_CLOCK_USB3000
        EXTERNAL_INPUT_CLOCK_USB3000
        INVALID_INPUT_CLOCK_USB3000
End Enum


'     
Public Enum SynchroTypes_USB3000
   NO_SYNCHRO_USB3000
   TTL_START_SYNCHRO_USB3000
   TTL_KADR_USB3000
   ANALOG_SYNCHRO_USB3000
   INVALID_SYNC_USB3000
End Enum

'      
Public Enum DataTypes_USB3000
   EMPTY_DATA_USB3000
   ADC_DATA_USB3000
   TTL_DATA_USB3000
   MIXED_DATA_USB3000
   INVALID_INPUT_DATA_USB3000
End Enum

'      USB
Public Enum UsbSpeed_USB3000
   USB11_USB3000
   USB20_USB3000
   INVALID_USB_SPEED_USB3000
End Enum
' ================================================================


' ===========================  ==========================
'         DSP
Public Const VarsBaseAddress_USB3000 As Integer = &H30

'    DSP  USB3000 (    DSP)
Public Const D_PROGRAM_BASE_ADDRESS_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H0)
Public Const D_TARGET_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H1)
Public Const D_LABEL_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H6)
Public Const D_VERSION_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H9)
Public Const D_TEST_VAR1_USB3000 As Integer = (VarsBaseAddress_USB3000 + &HA)
Public Const D_TEST_VAR2_USB3000 As Integer = (VarsBaseAddress_USB3000 + &HB)
Public Const D_TEST_INTR_VAR_USB3000 As Integer = (VarsBaseAddress_USB3000 + &HC)
Public Const D_MODULE_READY_USB3000 As Integer = (VarsBaseAddress_USB3000 + &HD)
Public Const D_COMMAND_USB3000 As Integer = (VarsBaseAddress_USB3000 + &HE)
Public Const D_INPUT_CLOCK_SOURCE As Integer = (VarsBaseAddress_USB3000 + &H10)

Public Const D_CONTROL_TABLE_LENGHT_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H20)
Public Const D_INPUT_SAMPLE_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H21)
Public Const D_INPUT_CHANNEL_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H22)
Public Const D_INPUT_RATE_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H23)
Public Const D_INTER_KADR_DELAY_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H24)
Public Const D_FIRST_SAMPLE_DELAY_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H25)
Public Const D_INPUT_ENABLED_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H26)
Public Const D_INPUT_FIFO_BASE_ADDRESS_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H27)
Public Const D_INPUT_FIFO_LENGTH_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H28)
Public Const D_CUR_INPUT_FIFO_LENGTH_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H29)

Public Const D_CORRECTION_ENABLED_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H2B)

Public Const D_INPUT_TYPE_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H2C)
Public Const D_SYNCHRO_TYPE_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H2D)
Public Const D_SYNCHRO_AD_TYPE_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H2E)
Public Const D_SYNCHRO_AD_MODE_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H2F)
Public Const D_SYNCHRO_AD_CHANNEL_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H30)
Public Const D_SYNCHRO_AD_POROG_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H31)

Public Const D_OUTPUT_SAMPLE_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H40)
Public Const D_OUTPUT_SCLK_DIV_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H41)
Public Const D_OUTPUT_RATE_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H42)
Public Const D_OUTPUT_ENABLED_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H43)
Public Const D_OUTPUT_FIFO_BASE_ADDRESS_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H44)
Public Const D_OUTPUT_FIFO_LENGTH_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H45)
Public Const D_CUR_OUTPUT_FIFO_LENGTH_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H46)

Public Const D_ENABLE_TTL_OUT_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H4D)
Public Const D_TTL_OUT_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H4E)
Public Const D_TTL_IN_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H4F)

Public Const D_ADC_SCALE_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H50)
Public Const D_ADC_ZERO_USB3000 As Integer = (VarsBaseAddress_USB3000 + &H58)
Public Const D_CONTROL_TABLE_USB3000 As Integer = (&H100)

'    DSP  
Public Const DSP_CLOCK_OUT_USB3000 As Double = 72000#
' ================================================================

' ====================   USB3000 ====================

' BOOL WINAPI ReleaseDevice_Usb3000(LPVOID IDevPtr)
Public Declare Function ReleaseInstance_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long) As Long

'  BOOL WINAPI OpenDevice_Usb3000(LPVOID IDevPtr, WORD VirtualSlot)
Public Declare Function OpenDevice_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              ByVal VirtualSlot As Integer) As Long

'  BOOL WINAPI CloseDevice_Usb3000(LPVOID IDevPtr)
Public Declare Function CloseDevice_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long) As Long


'  HANDLE WINAPI GetModuleHandle_Usb3000(LPVOID IDevPtr)
Public Declare Function GetModuleHandle_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                               ByVal DevPtr As Long) As Long

'  BOOL WINAPI GetUsbSpeed_Usb3000(LPVOID IDevPtr, BYTE * const UsbSpeed)
Public Declare Function GetUsbSpeed_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                               ByVal DevPtr As Long, _
                               ByRef UsbSpeed As Byte) As Long

'  BOOL WINAPI GetModuleName_Usb3000(LPVOID IDevPtr, PC&HAR const ModuleName)
Public Declare Function GetModuleName_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              ByVal ModuleName As String) As Long

'  BOOL WINAPI GetModuleSerialNumber_Usb3000(LPVOID IDevPtr, PC&HAR const SerialNumber)
Public Declare Function GetModuleSerialNumber_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              ByVal SerialNumber As String) As Long

'  BOOL WINAPI GetAvrVersion_Usb3000(LPVOID IDevPtr, PC&HAR const AvrVersion)
Public Declare Function GetAvrVersion_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              ByVal AvrVersion As String) As Long

'  BOOL WINAPI RESET_DSP_Usb3000(LPVOID IDevPtr)
Public Declare Function RESET_DSP_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long) As Long

'   DSP    (*.rtd) 
' -    Rtusbapi.dll
Public Declare Function LOAD_DSP_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              Optional ByVal FileName As String = vbNullString) As Long

'  BOOL WINAPI MODULE_TEST_Usb3000(LPVOID IDevPtr)
Public Declare Function MODULE_TEST_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long) As Long

'  BOOL WINAPI GET_DSP_INFO_Usb3000(LPVOID IDevPtr, wrDSP_INFO_USB3000* const DspInfo)
Public Declare Function GET_DSP_INFO_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              ByRef DspInfo As DSP_INFO_USB3000) As Long

'  BOOL WINAPI SEND_COMMAND_Usb3000(LPVOID IDevPtr, WORD Command)
Public Declare Function SEND_COMMAND_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              ByVal Command As Integer) As Long

'  int WINAPI GetLastErrorString_Usb3000(LPVOID IDevPtr, LPTSTR const lpBuffer, DWORD nSize)
Public Declare Function GetLastErrorString_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              ByVal Buffer As String, _
                              ByVal nSize As Long) As Long

'  BOOL WINAPI GET_INPUT_PARS_Usb3000(LPVOID IDevPtr, INPUT_PARS_USB3000* const ap)
Public Declare Function GET_INPUT_PARS_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              ByRef ap As INPUT_PARS_USB3000) As Long

'  BOOL WINAPI SET_INPUT_PARS_Usb3000(LPVOID IDevPtr, INPUT_PARS_USB3000 * const ap)
Public Declare Function SET_INPUT_PARS_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              ByRef ap As INPUT_PARS_USB3000) As Long

'  BOOL WINAPI START_READ_Usb3000(LPVOID IDevPtr)
Public Declare Function START_READ_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long) As Long

'  BOOL WINAPI STOP_READ_Usb3000(LPVOID IDevPtr)
Public Declare Function STOP_READ_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long) As Long

'  BOOL WINAPI READ_KADR_Usb3000(LPVOID IDevPtr, SHORT * const Data)
Public Declare Function READ_KADR_PARS_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              ByRef Data As Integer) As Long

'  BOOL WINAPI READ_SAMPLE_Usb3000(LPVOID IDevPtr, WORD Channel, SHORT * const Sample)
Public Declare Function READ_SAMPLE_PARS_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              ByVal Channel As Integer, _
                              ByRef Sample As Integer) As Long

'  BOOL WINAPI ReadData_Usb3000(LPVOID IDevPtr, SHORT * const lpBuffer, DWORD * const nNumberOfWordsToRead, LPDWORD lpNumberOfBytesRead, LPOVERLAPPED lpOverlapped)
Public Declare Function ReadData_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              ByRef Buffer As Integer, _
                              ByRef NumberOfWordsToRead As Long, _
                              ByRef NumberOfBytesRead As Long, _
                              ByRef lpOverlapped As OVERLAPPED) As Long

'  BOOL WINAPI GET_OUTPUT_PARS_Usb3000(LPVOID IDevPtr, OUTPUT_PARS_USB3000* const dp)
Public Declare Function GET_OUTPUT_PARS_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                               ByVal DevPtr As Long, _
                               ByRef dp As OUTPUT_PARS_USB3000) As Long

'  BOOL WINAPI SET_OUTPUT_PARS_Usb3000(LPVOID IDevPtr, OUTPUT_PARS_USB3000* const dp)
Public Declare Function SET_OUTPUT_PARS_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              ByRef dp As OUTPUT_PARS_USB3000) As Long

'  BOOL WINAPI START_WRITE_Usb3000(LPVOID IDevPtr)
Public Declare Function START_WRITE_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long) As Long

'  BOOL WINAPI STOP_WRITE_Usb3000(LPVOID IDevPtr)
Public Declare Function STOP_WRITE_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long) As Long

'  BOOL WINAPI WriteData_Usb3000(LPVOID IDevPtr, SHORT * const lpBuffer, DWORD * const nNumberOfWordsToWrite, LPDWORD lpNumberOfBytesWritten, LPOVERLAPPED lpOverlapped)
Public Declare Function WriteData_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              ByRef Buffer As Integer, _
                              ByRef NumberOfWordsToWrite As Long, _
                              ByRef NumberOfBytesWritten As Long, _
                              ByRef lpOverlapped As OVERLAPPED) As Long

'  BOOL WINAPI WRITE_SAMPLE_Usb3000(LPVOID IDevPtr, WORD Channel, SHORT * const Sample)
Public Declare Function WRITE_SAMPLE_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              ByVal Channel As Integer, _
                              ByRef Sample As Integer) As Long

'  BOOL WINAPI ENABLE_TTL_OUT_Usb3000(LPVOID IDevPtr, BOOL EnableTtlOut)
Public Declare Function ENABLE_TTL_OUT_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              ByVal EnableTtlOut As Long) As Long

'  BOOL WINAPI TTL_IN_Usb3000(LPVOID IDevPtr, WORD * const TtlIn)
Public Declare Function TTL_IN_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              ByRef TtlIn As Integer) As Long

'  BOOL WINAPI TTL_OUT_Usb3000(LPVOID IDevPtr, WORD TtlOut)
Public Declare Function TTL_OUT_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              ByVal TtlOut As Integer) As Long

'  BOOL WINAPI ENABLE_FLASH_WRITE_Usb3000(LPVOID IDevPtr, BOOL EnableFlashWrite)
Public Declare Function ENABLE_FLASH_WRITE_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              ByVal EnableFlashWrite As Long) As Long

'  BOOL WINAPI PUT_FLASH_Usb3000(LPVOID IDevPtr, FLASH_USB3000* const fi)
Public Declare Function PUT_FLASH_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              ByRef fi As FLASH_USB3000) As Long

'  BOOL WINAPI GET_FLASH_Usb3000(LPVOID IDevPtr, FLASH_USB3000* const fi)
Public Declare Function GET_FLASH_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal DevPtr As Long, _
                              ByRef fi As FLASH_USB3000) As Long

'  BOOL WINAPI PUT_VAR_WORD_Usb3000(LPVOID IDevPtr, WORD Address, SHORT Data)
Public Declare Function PUT_VAR_WORD_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal Address As Integer, _
                              ByVal Data As Integer) As Long

'  BOOL WINAPI GET_VAR_WORD_Usb3000(LPVOID IDevPtr, WORD Address, SHORT * const Data)
Public Declare Function GET_VAR_WORD_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal Address As Integer, _
                              ByRef Data As Integer) As Long

'  BOOL WINAPI PUT_DM_WORD_Usb3000(LPVOID IDevPtr, WORD Address, SHORT Data)
Public Declare Function PUT_DM_WORD_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal Address As Integer, _
                              ByVal Data As Integer) As Long

'  BOOL WINAPI GET_DM_WORD_Usb3000(LPVOID IDevPtr, WORD Address, SHORT * const Data)
Public Declare Function GET_DM_WORD_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal Address As Integer, _
                              ByRef Data As Integer) As Long

'  BOOL WINAPI PUT_PM_WORD_Usb3000(LPVOID IDevPtr, WORD Address, LONG Data)
Public Declare Function PUT_PM_WORD_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal Address As Integer, _
                              ByVal Data As Long) As Long

'  BOOL WINAPI GET_PM_WORD_Usb3000(LPVOID IDevPtr, WORD Address, LONG * const Data)
Public Declare Function GET_PM_WORD_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal Address As Integer, _
                              ByRef Data As Long) As Long

'  BOOL WINAPI PUT_DM_ARRAY_Usb3000(LPVOID IDevPtr, WORD BaseAddress, WORD NPoints, SHORT * const Data)
Public Declare Function PUT_DM_ARRAY_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal BaseAddress As Integer, _
                              ByVal NPoints As Integer, _
                              ByRef Data As Integer) As Long

'  BOOL WINAPI GET_DM_ARRAY_Usb3000(LPVOID IDevPtr, WORD BaseAddress, WORD NPoints, SHORT * const Data)
Public Declare Function GET_DM_ARRAY_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal BaseAddress As Integer, _
                              ByVal NPoints As Integer, _
                              ByRef Data As Integer) As Long

'  BOOL WINAPI PUT_PM_ARRAY_Usb3000(LPVOID IDevPtr, WORD BaseAddress, WORD NPoints, LONG * const Data)
Public Declare Function PUT_PM_ARRAY_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal BaseAddress As Integer, _
                              ByVal NPoints As Integer, _
                              ByRef Data As Long) As Long

'  BOOL WINAPI GET_PM_ARRAY_Usb3000(LPVOID IDevPtr, WORD BaseAddress, WORD NPoints, LONG * const Data)
Public Declare Function GET_PM_ARRAY_Usb3000 Lib "wrRtusbapi.dll" _
                           ( _
                              ByVal BaseAddress As Integer, _
                              ByVal NPoints As Integer, _
                              ByRef Data As Long) As Long
' ================================================================

' ****************************************************************

