//  ,     QMS85, 
//   
//     .


#include "../../dll/qmx.h"
#include <shellapi.h>
#include <stdio.h>
#include <conio.h> 
#include <math.h>

#define QMS85SLOT	0
#define QMS20SLOT	1

#define SETBIT(ADDRESS,BIT) (ADDRESS |= (1<<BIT))
#define CLEARBIT(ADDRESS,BIT) (ADDRESS &= ~(1<<BIT))


HANDLE SD;                              //  
WORD ErrorData[16], QMS85Table[16], QMS20Table[8];
QMX_CC_F CC_Adc_85[16];
QMX_CC_F CC_Adc_20[16];
QMX_CONFIG CFG;                         //  

static unsigned int DataPtr, DataPtrOld, CurrentPtr, LengthDataBuf;
static unsigned short int *Data;
static unsigned int QMS_data[8][32], QMS_iter[8][32], time;


void CheckErr(void);
void quit(void);
void DisplayData(void);


void main(int argc, char* argv[])
{
	char s_wrk[64];
	int mod, ch; 
	WORD AsyncData, BalanceCodes[16];
	int i, k, l;
	double CRate;

	printf("Please wait....\r");
	
	//  
	ShellExecuteW(NULL, TEXT("open"), TEXT("qmbox_ds.exe"), TEXT("-p3"), NULL, SW_SHOWNORMAL);
	Sleep(500);

	//   
	SD = 0;
	SD=QMX_CircBufAttach(0);
	if (SD == NULL) {
		printf("ERROR: No QMBox found.");
		quit(); 
	}

	//  
	QMX_InitModules(SD, QMX_LOG_NONE, NULL);
	CheckErr();


	//   QMX_Prepare -   
	// ..     
	QMX_MOD_SetActive(SD, 0, QMX_ON);
	QMX_Prepare(SD, 100, &CFG);
	CheckErr();
	QMX_MOD_SetActive(SD, 0, QMX_OFF);
	
	// ,      -  QMS85
	strncpy_s (s_wrk, CFG.ModName[QMS85SLOT], 5); s_wrk[5] = 0;
	if (!_stricmp(s_wrk, "QMS85"))	printf("Module name OK\n");
	else{ printf("Module Name error\n");	quit();	}

	//      qms85 - 2    35 .
	for (i = 0; i < 2; i ++) QMS85Table[i] = (QMX_QMS85_GAIN_35mV << 4)|(i);
	//     
	QMX_QMS85_SetTable(SD, QMS85SLOT, QMS85Table, 2, CC_Adc_85);
	//  
	QMX_QMS85_AutoBalance(SD, QMS85SLOT, QMS85Table, 2, CC_Adc_85, BalanceCodes); 
	//     - 20  (4   )
	QMX_QMS85_SetAdcRate(SD, QMS85SLOT, 20000.0, NULL);
	//   qms85 
	QMX_MOD_SetActive(SD, QMS85SLOT, QMX_ON);


	//     qms20
	QMX_QMS20_SetAdcRate(SD, QMS20SLOT, 3000000, &CRate); 
	printf("QMS20 ADC  Rate = %8.2f Hz \n", CRate);	
	//     QMS20  
	//       +-5 .
	//       QMS20:
	for (i = 0; i < 3; i ++){
		QMX_QMS20_ReadCC(SD, QMS20SLOT, i, QMX_QMS20_GAIN_1, &CC_Adc_20[i]);
		QMX_QMS20_BuildTableItem(SD, i, QMX_QMS20_MODE_D, QMX_QMS20_GAIN_1,  &QMS20Table[i]);
	}
	//     
	QMX_QMS20_SetTable(SD, QMS20SLOT, QMS20Table, 3);
	//   
	QMX_MOD_SetActive(SD, QMS20SLOT, QMX_ON);




	//    
	QMX_Prepare(SD, 100, &CFG);
	CheckErr();
	
	LengthDataBuf = *CFG.CBInput.buf_size;						//    ,  
	Data = (unsigned short int*)CFG.CBInput.buf_start;			//      ,
																//  
	DataPtrOld = 0;
	time = 0;

	//   
	QMX_Start(SD);
	CheckErr();

	while (!_kbhit()){											//    
																// (   )

		DataPtr = *CFG.CBInput.buf_ptr;							//     
																//   						
		for (CurrentPtr = DataPtrOld; CurrentPtr != DataPtr; CurrentPtr += 2) { //      
			
			if(CurrentPtr >= *CFG.CBInput.buf_size)				// , 
				CurrentPtr = 0;									//    
			if ((!CurrentPtr)&&(!DataPtr))break;				//     

			mod = (Data[CurrentPtr] >> 5) & 0x07;				//   () 16-      
			ch  = Data[CurrentPtr]  & 0x1f;						//     ( 5- )   (. 3- ).
			QMS_data[mod][ch] += Data[CurrentPtr+1];			//   () 16-     
																//   () 16-     
																//          
																// (  ).
																//        ([][])
																//   .      
																//      ,    
																//    .
			QMS_iter[mod][ch]++;								//      
	
		}

		DataPtrOld = DataPtr;						//      
													//  

		time++;										//   100  
		if (time >=5){								//     0.5 ,
			DisplayData();							//    
			time = 0;								//    100  
		}

		Sleep(30);									//       
													//        Sleep  
													//        

 }

	quit();											//   
}



//   
void quit(void){
	
	printf("\n\n Please wait....\r");
	QMX_Stop(SD, QMX_STOP_ALL);			//  
	QMX_MOD_SetStartMode(SD, 0xFF, QMX_START_MODE_MANUAL); 									

	QMX_CircBufDetach(SD);              //    USB
										//  
	ShellExecute(NULL, TEXT("open"), TEXT("qmbox_ds.exe"), TEXT("-s0"), NULL, SW_SHOWNORMAL);
	printf("\n\n");
	ExitProcess(0);
}


//   
void CheckErr(void) {
char tmp_str[1024];

if (QMX_GetLastError(SD, tmp_str, sizeof(tmp_str))==QMX_OK){ return;}
else  {	printf("%s\n", tmp_str);	quit();}
}



//  
void DisplayData(void){

	double d_wrk;

   	//     ,       
	//       :
	d_wrk = ((double)QMS_data[0][0]) / ((double)QMS_iter[0][0]) * CC_Adc_85[0].Scale + CC_Adc_85[0].Offset;
	printf("%8.4f mV ", d_wrk);
	d_wrk = ((double)QMS_data[0][1]) / ((double)QMS_iter[0][1]) * CC_Adc_85[1].Scale + CC_Adc_85[1].Offset;
	printf("%8.4f mV ", d_wrk);
	d_wrk = ((double)QMS_data[QMS20SLOT][0]) / ((double)QMS_iter[QMS20SLOT][0]) * CC_Adc_20[0].Scale + CC_Adc_20[0].Offset;
	printf("%8.3f V ", d_wrk);
	d_wrk = ((double)QMS_data[QMS20SLOT][1]) / ((double)QMS_iter[QMS20SLOT][1]) * CC_Adc_20[1].Scale + CC_Adc_20[1].Offset;
	printf("%8.3f V ", d_wrk);
	d_wrk = ((double)QMS_data[QMS20SLOT][2]) / ((double)QMS_iter[QMS20SLOT][2]) * CC_Adc_20[2].Scale + CC_Adc_20[2].Offset;
	printf("%8.3f V\r", d_wrk);

	//       :
	QMS_data[0][0] = 0; QMS_iter[0][0] = 0; 
	QMS_data[0][1] = 0; QMS_iter[0][1] = 0;
	QMS_data[QMS20SLOT][0] = 0; QMS_iter[QMS20SLOT][0] = 0;
	QMS_data[QMS20SLOT][1] = 0; QMS_iter[QMS20SLOT][1] = 0;
	QMS_data[QMS20SLOT][2] = 0; QMS_iter[QMS20SLOT][2] = 0;
}