#include "../../dll/qmx.h"
#include <shellapi.h>
#include <stdio.h>
#include <conio.h> 


#define QMS301_SLOT	0
#define QMS10_SLOT	1


HANDLE SD;                              //  
QMX_CONFIG CFG;                         //  
WORD QMS10Table[16];					//     QMS10
QMX_CC_F CC_Adc[3];						//   QMS10
QMX_CC_F CC_QMS301[16];					//   QMS30 


static unsigned int DataPtr, DataPtrOld, CurrentPtr, LengthDataBuf;
static unsigned short int *Data;

static unsigned int QMS_data[8][32], QMS_iter[8][32], time;

void CheckErr(void);
void quit(void);
void DisplayData(void);

//void main(void)
void main(int argc, char* argv[])
{
	char s_wrk[64];
	int i_wrk, mod, ch;


    ///////////////////////////////////////////////////////////////////////////////////////
	////////		    
	///////////////////////////////////////////////////////////////////////////////////////

	printf("Please wait....\r");
	
	//  
	ShellExecuteW(NULL, TEXT("open"), TEXT("qmbox_ds.exe"), TEXT("-p3"), NULL, SW_SHOWNORMAL);
	Sleep(500);

	//   
	SD = 0;
	SD=QMX_CircBufAttach(0);
	if (SD == NULL) {
		printf("ERROR: No QMBox found.");
		quit(); 
	}

	//  
	QMX_InitModules(SD, QMX_LOG_NONE, NULL);
	CheckErr();

	//   QMX_Prepare -   
	// ..     
	QMX_MOD_SetActive(SD, 0, QMX_ON);
	QMX_Prepare(SD, 100, &CFG);
	CheckErr();
	QMX_MOD_SetActive(SD, 0, QMX_OFF);
	
	// ,        
	//////////////////////////////////////////////////////////////
	strncpy_s (s_wrk, CFG.ModName[QMS301_SLOT], 5); s_wrk[5] = 0;
	if (!_stricmp(s_wrk, "QMS30"))	printf("1 Module name OK\n");
	else{ printf("Module Name error\n");	quit();	}

	strncpy_s (s_wrk, CFG.ModName[QMS10_SLOT], 5); s_wrk[5] = 0;
	if (!_stricmp(s_wrk, "QMS10"))	printf("2 Module name OK\n");
	else{ printf("Module Name error\n");	quit();	}
	////////////////////////////////////////////////////////////////


	//    QMS301
	//      
	for (i_wrk=0; i_wrk<16; i_wrk++) QMX_QMS301_ReadCC(SD, QMS301_SLOT, i_wrk, &CC_QMS301[i_wrk]);
	

	//    QMS10
	//      
	//     -   1, 4  16
	for (i_wrk=0; i_wrk<3; i_wrk++) QMX_QMS10_ReadCC(SD, QMS10_SLOT, i_wrk, &CC_Adc[i_wrk]);

	//     QMS10:
	//       3    -   
	//    1, 4, 16
	QMX_QMS10_BuildTableItem(SD, 0, QMX_QMS10_MODE_D, QMX_QMS10_GAIN_1,  &QMS10Table[0]);
	QMX_QMS10_BuildTableItem(SD, 1, QMX_QMS10_MODE_D, QMX_QMS10_GAIN_4,  &QMS10Table[1]);
	QMX_QMS10_BuildTableItem(SD, 2, QMX_QMS10_MODE_D, QMX_QMS10_GAIN_16, &QMS10Table[2]);

	//     
	QMX_QMS10_SetTable(SD, QMS10_SLOT, QMS10Table, 3);

	//     - 20  (4   )
	QMX_QMS10_SetAdcRate(SD, QMS10_SLOT, 20000.0, NULL);




	//    
	QMX_MOD_SetActive(SD, QMS301_SLOT, QMX_ON);
	QMX_MOD_SetActive(SD, QMS10_SLOT, QMX_ON);


	//    
	QMX_Prepare(SD, 100, &CFG);
	CheckErr();
	
	LengthDataBuf = *CFG.CBInput.buf_size;						//    ,  
	Data = (unsigned short int*)CFG.CBInput.buf_start;			//      ,
																//  
	DataPtrOld = 0;
	time = 0;

	//   
	QMX_Start(SD);
	CheckErr();


    ///////////////////////////////////////////////////////////////////////////////////////
	////////		  
	///////////////////////////////////////////////////////////////////////////////////////


	while (!_kbhit()){											//    
																// (   )

		DataPtr = *CFG.CBInput.buf_ptr;							//     
																//   						
		for (CurrentPtr = DataPtrOld; CurrentPtr != DataPtr; CurrentPtr += 2) { //      
			
			if(CurrentPtr >= *CFG.CBInput.buf_size)				// , 
				CurrentPtr = 0;									//    
			if ((!CurrentPtr)&&(!DataPtr))break;				//     

			mod = (Data[CurrentPtr] >> 5) & 0x07;				//   () 16-      
			ch  = Data[CurrentPtr]  & 0x1f;						//     ( 5- )   (. 3- ).
			QMS_data[mod][ch] += Data[CurrentPtr+1];			//   () 16-     
																//   () 16-     
																//          
																// (  ).
																//        ([][])
																//   .      
																//      ,    
																//    .
	


			QMS_iter[mod][ch]++;								//      
	
		}

		DataPtrOld = DataPtr;						//      
													//  

		time++;										//    
		if (time >=5){								//     5 ,
			DisplayData();							//    
			time = 0;								//     
		}

		Sleep(25);									//       
													//        Sleep  
													//        
													//      /      QMS70


 }

	quit();											//   
}


//   
void quit(void){
	
	printf("\n\n Please wait....\r");
	QMX_Stop(SD, QMX_STOP_ALL);			//  
	QMX_MOD_SetStartMode(SD, 0xFF, QMX_START_MODE_MANUAL); 									



	QMX_CircBufDetach(SD);              //    USB
										//  
	ShellExecute(NULL, TEXT("open"), TEXT("qmbox_ds.exe"), TEXT("-s0"), NULL, SW_SHOWNORMAL);
	printf("\n\n");
	ExitProcess(0);
}


//   
void CheckErr(void) {
char tmp_str[1024];

if (QMX_GetLastError(SD, tmp_str, sizeof(tmp_str))==QMX_OK){ return;}
else  {	printf("%s\n", tmp_str);	quit();}
}


//  
void DisplayData(void){

	double d_wrk[16];
	int i, k;

	//     ,       
	//  :
	
	//  14  QMS301 () 
	d_wrk[0] = ((double)QMS_data[QMS301_SLOT][14]) / ((double)QMS_iter[QMS301_SLOT][14]) * CC_QMS301[14].Scale + CC_QMS301[14].Offset;
	//  15  QMS301 () 
	d_wrk[1] = ((double)QMS_data[QMS301_SLOT][15]) / ((double)QMS_iter[QMS301_SLOT][15]) * CC_QMS301[14].Scale + CC_QMS301[15].Offset;

	//    QMS10  
	d_wrk[2] = ((double)QMS_data[QMS10_SLOT][0]) / ((double)QMS_iter[QMS10_SLOT][0]) * CC_Adc[0].Scale + CC_Adc[0].Offset;
	//    QMS10  
	d_wrk[3] = ((double)QMS_data[QMS10_SLOT][1]) / ((double)QMS_iter[QMS10_SLOT][1]) * CC_Adc[1].Scale + CC_Adc[1].Offset;
	//    QMS10  
	d_wrk[4] = ((double)QMS_data[QMS10_SLOT][2]) / ((double)QMS_iter[QMS10_SLOT][2]) * CC_Adc[2].Scale + CC_Adc[2].Offset;

	
	//   
	printf("                                                                            \r");
	printf(" %3.3f    ", d_wrk[0]);
	printf(" %3.3f    ", d_wrk[1]);
	printf(" %3.3f %s ", d_wrk[2], CC_Adc[0].Units);
	printf(" %3.3f %s ", d_wrk[3], CC_Adc[1].Units);
	printf(" %3.3f %s   \r ", d_wrk[4], CC_Adc[2].Units);

	//       :
	for (i = 0; i<8; i++)
		for (k = 0; k<16; k++)
		{QMS_data[i][k] = 0; QMS_iter[i][k] = 0;}


}





