// ,        QMS20
// (   4    300 /)
//     QMS45,      
// (      ).


#include "../../dll/qmx.h"
#include <shellapi.h>
#include <stdio.h>
#include <conio.h> 
#include <math.h>


HANDLE SD;                              //  
QMX_CONFIG CFG;                         //  
WORD QMS20Table[16];					//     QMS20
QMX_CC_F CC_Adc1[4];					//  
QMX_CC_F CC_Dac1[8];

static unsigned int DataPtr, DataPtrOld=0, CurrentPtr, LengthDataBuf, out_cntr=0;
static unsigned short int *Data, *out_buf[2];


static unsigned int QMS_data[8][32], QMS_iter[8][32];

void CheckErr(void);
void quit(void);
void DisplayData(void);
void FillBuf(WORD *buf, DWORD len);

//        
DWORD WINAPI ServiceWriteThread(PVOID /*Context*/);
//   
HANDLE hWriteThread;
DWORD WriteTid;
//     
bool IsThreadComplete = false;




//void main(void)
void main(int argc, char* argv[])
{
	char s_wrk[64];
	int i_wrk, mod, ch;
	double CRate;

	printf("Please wait....\r");
	
	//  
	ShellExecuteW(NULL, TEXT("open"), TEXT("qmbox_ds.exe"), TEXT("-p3"), NULL, SW_SHOWNORMAL);
	Sleep(500);

	//   
	SD = 0;
	SD=QMX_CircBufAttach(0);
	if (SD == NULL) {
		printf("ERROR: No QMBox found.");
		quit(); 
	}

	//  
	QMX_InitModules(SD, QMX_LOG_NONE, NULL);
	CheckErr();

	//   QMX_Prepare -   
	// ..     
	QMX_MOD_SetActive(SD, 0, QMX_ON);
	QMX_Prepare(SD, 100, &CFG);
	CheckErr();
	QMX_MOD_SetActive(SD, 0, QMX_OFF);
	
	// ,       - QMS20  QMS45
	strncpy_s (s_wrk, CFG.ModName[0], 5); s_wrk[5] = 0;
	if (!_stricmp(s_wrk, "QMS20"))	printf("1st Module name OK\n");
	else{ printf("1st Module Name error\n");	quit();	}
	strncpy_s (s_wrk, CFG.ModName[1], 5); s_wrk[5] = 0;
	if (!_stricmp(s_wrk, "QMS45"))	printf("2nd Module name OK\n");
	else{ printf("2nd Module Name error\n");	quit();	}

	//   
	out_buf[0]=(WORD *)CFG.CBOutput.buf_start;								//      
	out_buf[1]=(WORD *)(CFG.CBOutput.buf_start+(*CFG.CBOutput.buf_size>>1));	//      
	Data = (unsigned short int*)CFG.CBInput.buf_start;						//    
	LengthDataBuf = *CFG.CBInput.buf_size;									//    ,  	


	//    
	QMX_QMS20_SetAdcRate(SD, 0, 1200000, &CRate); 
	printf("ADC  Rate = %8.2f Hz \n", CRate);

	//    
	QMX_QMS45_SetDacRate(SD, 1, 1000000.0, &CRate);
	printf("DAC  Rate = %8.2f Hz \n", CRate);


	//      
	//       +-5 .
	for (i_wrk=0; i_wrk<4; i_wrk++) QMX_QMS20_ReadCC(SD, 0, i_wrk, QMX_QMS20_GAIN_1, &CC_Adc1[i_wrk]);

	//     QMS20:
	//       4    - 
	//    1
	QMX_QMS20_BuildTableItem(SD, 0, QMX_QMS20_MODE_D, QMX_QMS20_GAIN_1,  &QMS20Table[0]);
	QMX_QMS20_BuildTableItem(SD, 1, QMX_QMS20_MODE_D, QMX_QMS20_GAIN_1,  &QMS20Table[1]);
	QMX_QMS20_BuildTableItem(SD, 2, QMX_QMS20_MODE_D, QMX_QMS20_GAIN_1,  &QMS20Table[2]);
	QMX_QMS20_BuildTableItem(SD, 3, QMX_QMS20_MODE_D, QMX_QMS20_GAIN_1,  &QMS20Table[3]);

	//     
	QMX_QMS20_SetTable(SD, 0, QMS20Table, 4);
	//   
	QMX_MOD_SetActive(SD, 0, QMX_ON);


	//       
	//  ,    ""         
	QMX_MOD_SetActive(SD, 1, QMX_ON);	//     
	QMX_Prepare(SD, 0, &CFG);			//     QMX_Prepare
	CheckErr();
	FillBuf(out_buf[0], *CFG.CBOutput.buf_size);		//     ( )  
	QMX_MOD_OutputPrestage(SD, 1);						//     


	//      ,
	//        
	hWriteThread = CreateThread(0, 0x2000, ServiceWriteThread, 0x0, 0x0, &WriteTid);
	if(!hWriteThread) printf("Can't start output data thread!");


	//     -  ""
	QMX_Start(SD);
	CheckErr();


	while (!IsThreadComplete){									//     (     )
																//     
		
		DataPtr = *CFG.CBInput.buf_ptr;							//     
																//   						
		for (CurrentPtr = DataPtrOld; CurrentPtr != DataPtr; CurrentPtr += 2) { //      
			
			if(CurrentPtr >= *CFG.CBInput.buf_size)				// , 
				CurrentPtr = 0;									//    
			if ((!CurrentPtr)&&(!DataPtr))break;				//     

			mod = (Data[CurrentPtr] >> 5) & 0x07;				//   () 16-      
			ch  = Data[CurrentPtr]  & 0x1f;						//     ( 5- )   (. 3- ).
			QMS_data[mod][ch] += Data[CurrentPtr+1];			//   () 16-     
																//   () 16-     
																//          
																// (  ).
																//        ([][])
																//   .      
																//      ,    
																//    .
			QMS_iter[mod][ch]++;								//      
	
		}

		
		if(DataPtrOld != DataPtr){
				DisplayData();						//     
		}
		
		DataPtrOld = DataPtr;						//      
													//  

		printf("Write Counter: %3u\r", out_cntr);	//     
													// (    )


		Sleep(100);									//         100 
													//        Sleep  
													//        

 }

	quit();											//   
}


//------------------------------------------------------------------------
//         
//------------------------------------------------------------------------
DWORD WINAPI ServiceWriteThread(PVOID /*Context*/)
{
	while(!_kbhit()){				//   (  )				
	  if(out_cntr<*CFG.CBOutput.buf_ptr) {								//        						
		   FillBuf(out_buf[out_cntr++&1], (*CFG.CBOutput.buf_size)>>1); //     
		   QMX_CircBufOutputUpdate(SD);									//      

	  }
	  Sleep(20);
	}

	//      
	IsThreadComplete = true;

	return 0;							//   

}

//   
void quit(void){
	
	printf("\n\n Please wait....\r");
	QMX_Stop(SD, QMX_STOP_ALL);			//  
	QMX_MOD_SetStartMode(SD, 0xFF, QMX_START_MODE_MANUAL); 									

	QMX_CircBufDetach(SD);              //    USB
										//  
	ShellExecute(NULL, TEXT("open"), TEXT("qmbox_ds.exe"), TEXT("-s0"), NULL, SW_SHOWNORMAL);
	printf("\n\n");
	ExitProcess(0);
}


//   
void CheckErr(void) {
char tmp_str[1024];

if (QMX_GetLastError(SD, tmp_str, sizeof(tmp_str))==QMX_OK){ return;}
else  {	printf("%s\n", tmp_str);	quit();}
}


//  
void DisplayData(void){

	double d_wrk;

	//     ,       
	//       :
	d_wrk = ((double)QMS_data[0][0]) / ((double)QMS_iter[0][0]) * CC_Adc1[0].Scale + CC_Adc1[0].Offset;
	printf("                     Data from ADC: %6.3f V ", d_wrk);
	d_wrk = ((double)QMS_data[0][1]) / ((double)QMS_iter[0][1]) * CC_Adc1[1].Scale + CC_Adc1[1].Offset;
	printf("%6.3f V ", d_wrk);
	d_wrk = ((double)QMS_data[0][2]) / ((double)QMS_iter[0][2]) * CC_Adc1[2].Scale + CC_Adc1[2].Offset;
	printf("%6.3f V ", d_wrk);
	d_wrk = ((double)QMS_data[0][3]) / ((double)QMS_iter[0][3]) * CC_Adc1[0].Scale + CC_Adc1[0].Offset;
	printf("%6.3f V\r", d_wrk);
	
	//       :
	QMS_data[0][0] = 0; QMS_iter[0][0] = 0; 
	QMS_data[0][1] = 0; QMS_iter[0][1] = 0;
	QMS_data[0][2] = 0; QMS_iter[0][2] = 0;
	QMS_data[0][3] = 0; QMS_iter[0][3] = 0;

}


//       
void FillBuf(WORD *buf, DWORD len) {
#define _2PI	6.283185307179586476925286766559
DWORD i;
static double phase[8]={0.7, 1.5, 2.3, 2.9, 3.6, 4.3, 5.0, 5.7};
static double amp[8]={16000., 15000., 14000., 13000., 12000., 10000., 8000., 4000.}; 
static double freq[8]={0.2, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35};
static double j[8]={0};
 
  for(i=0; i<len; i++) *buf++=(WORD)(32767.-amp[i&0x7]*sin(phase[i&0x7]+(j[i&0x7]+=freq[i&0x7])>_2PI?j[i&0x7]-=_2PI:j[i&0x7]));
}
