// ,     QMS20
// (   4    300 /)
//      
//     .

#include "../../dll/qmx.h"
#include <shellapi.h>
#include <stdio.h>
#include <conio.h> 


HANDLE SD;                              //  
QMX_CONFIG CFG;                         //  
WORD QMS20Table[16];					//     QMS20
QMX_CC_F CC_Adc1[4];					//  

static unsigned int DataPtr, DataPtrOld, CurrentPtr, LengthDataBuf;
static unsigned short int *Data;



static unsigned int QMS_data[8][32], QMS_iter[8][32], time;

void CheckErr(void);
void quit(void);
void DisplayData(void);

//void main(void)
void main(int argc, char* argv[])
{
	char s_wrk[64];
	int i_wrk, mod, ch;
	double CRate;

	printf("Please wait....\r");
	
	//  
	ShellExecuteW(NULL, TEXT("open"), TEXT("qmbox_ds.exe"), TEXT("-p3"), NULL, SW_SHOWNORMAL);
	Sleep(500);

	//   
	SD = 0;
	SD=QMX_CircBufAttach(0);
	if (SD == NULL) {
		printf("ERROR: No QMBox found.");
		quit(); 
	}

	//  
	QMX_InitModules(SD, QMX_LOG_NONE, NULL);
	CheckErr();

	//   QMX_Prepare -   
	// ..     
	QMX_MOD_SetActive(SD, 0, QMX_ON);
	QMX_Prepare(SD, 100, &CFG);
	CheckErr();
	QMX_MOD_SetActive(SD, 0, QMX_OFF);
	
	// ,      -  QMS20
	strncpy_s (s_wrk, CFG.ModName[0], 5); s_wrk[5] = 0;
	if (!_stricmp(s_wrk, "QMS20"))	printf("Module name OK\n");
	else{ printf("Module Name error\n");	quit();	}
	

	//    
	QMX_QMS20_SetAdcRate(SD, 0, 3000000, &CRate); 
	printf("ADC  Rate = %8.2f Hz \n", CRate);	

	//      
	//       +-5 .
	for (i_wrk=0; i_wrk<4; i_wrk++) QMX_QMS20_ReadCC(SD, 0, i_wrk, QMX_QMS20_GAIN_1, &CC_Adc1[i_wrk]);

	//     QMS20:
	//       4    - 
	//    1
	QMX_QMS20_BuildTableItem(SD, 0, QMX_QMS20_MODE_D, QMX_QMS20_GAIN_1,  &QMS20Table[0]);
	QMX_QMS20_BuildTableItem(SD, 1, QMX_QMS20_MODE_D, QMX_QMS20_GAIN_1,  &QMS20Table[1]);
	QMX_QMS20_BuildTableItem(SD, 2, QMX_QMS20_MODE_D, QMX_QMS20_GAIN_1,  &QMS20Table[2]);
	QMX_QMS20_BuildTableItem(SD, 3, QMX_QMS20_MODE_D, QMX_QMS20_GAIN_1,  &QMS20Table[3]);

	//     
	QMX_QMS20_SetTable(SD, 0, QMS20Table, 4);
	//   
	QMX_MOD_SetActive(SD, 0, QMX_ON);

	//    
	QMX_Prepare(SD, 100, &CFG);
	CheckErr();
	
	LengthDataBuf = *CFG.CBInput.buf_size;						//    ,  
	Data = (unsigned short int*)CFG.CBInput.buf_start;			//      ,
																//  
	DataPtrOld = 0;
	time = 0;

	//   
	QMX_Start(SD);
	CheckErr();

	while (!_kbhit()){											//    
																// (   )

		DataPtr = *CFG.CBInput.buf_ptr;							//     
																//   						
		for (CurrentPtr = DataPtrOld; CurrentPtr != DataPtr; CurrentPtr += 2) { //      
			
			if(CurrentPtr >= *CFG.CBInput.buf_size)				// , 
				CurrentPtr = 0;									//    
			if ((!CurrentPtr)&&(!DataPtr))break;				//     

			mod = (Data[CurrentPtr] >> 5) & 0x07;				//   () 16-      
			ch  = Data[CurrentPtr]  & 0x1f;						//     ( 5- )   (. 3- ).
			QMS_data[mod][ch] += Data[CurrentPtr+1];			//   () 16-     
																//   () 16-     
																//          
																// (  ).
																//        ([][])
																//   .      
																//      ,    
																//    .
			QMS_iter[mod][ch]++;								//      
	
		}

		DataPtrOld = DataPtr;						//      
													//  

		time++;										//   100  
		if (time >=5){								//     0.5 ,
			DisplayData();							//    
			time = 0;								//    100  
		}

		Sleep(50);									//       
													//        Sleep  
													//        

 }

	quit();											//   
}


//   
void quit(void){
	
	printf("\n\n Please wait....\r");
	QMX_Stop(SD, QMX_STOP_ALL);			//  
	QMX_MOD_SetStartMode(SD, 0xFF, QMX_START_MODE_MANUAL); 									

	QMX_CircBufDetach(SD);              //    USB
										//  
	ShellExecute(NULL, TEXT("open"), TEXT("qmbox_ds.exe"), TEXT("-s0"), NULL, SW_SHOWNORMAL);
	printf("\n\n");
	ExitProcess(0);
}


//   
void CheckErr(void) {
char tmp_str[1024];

if (QMX_GetLastError(SD, tmp_str, sizeof(tmp_str))==QMX_OK){ return;}
else  {	printf("%s\n", tmp_str);	quit();}
}


//  
void DisplayData(void){

	double d_wrk;

	//     ,       
	//       :
	d_wrk = ((double)QMS_data[0][0]) / ((double)QMS_iter[0][0]) * CC_Adc1[0].Scale + CC_Adc1[0].Offset;
	printf("Data from ADC: %6.3f V ", d_wrk);
	d_wrk = ((double)QMS_data[0][1]) / ((double)QMS_iter[0][1]) * CC_Adc1[1].Scale + CC_Adc1[1].Offset;
	printf("%6.3f V ", d_wrk);
	d_wrk = ((double)QMS_data[0][2]) / ((double)QMS_iter[0][2]) * CC_Adc1[2].Scale + CC_Adc1[2].Offset;
	printf("%6.3f V ", d_wrk);
	d_wrk = ((double)QMS_data[0][3]) / ((double)QMS_iter[0][3]) * CC_Adc1[0].Scale + CC_Adc1[0].Offset;
	printf("%6.3f V\r", d_wrk);
	
	//       :
	QMS_data[0][0] = 0; QMS_iter[0][0] = 0; 
	QMS_data[0][1] = 0; QMS_iter[0][1] = 0;
	QMS_data[0][2] = 0; QMS_iter[0][2] = 0;
	QMS_data[0][3] = 0; QMS_iter[0][3] = 0;
}



