#ifndef __qmx_core_h__
#define __qmx_core_h__

#include "qmx.h"

extern WORD GLastErrorNumber[128];
extern char *error_helper[128][4];
extern char *error_function[128];

static char slot_err_helper[]="Parameter \"Slot\" valid range is [0..7].\n";
#define QMX_CHECK_SD(SD) if(SD==INVALID_HANDLE_VALUE || SD==NULL) {return(QMXE_INVALID_DESCRIPTOR);};
#define QMX_CHECK_SLOT(SD, SLOT) if(SLOT>8) {QMX_ClearErrorHelpers((QMX_SYSTEM *)SD); error_function[((QMX_SYSTEM *)SD)->Controller.VirtualSlot]=current_function_name; GLastErrorNumber[((QMX_SYSTEM *)SD)->Controller.VirtualSlot]=QMXE_BAD_PARAMETER; error_helper[((QMX_SYSTEM *)SD)->Controller.VirtualSlot][0]=slot_err_helper; return(QMX_ERR);}

// ਯ
typedef struct QMX_SYSTEM QMX_SYSTEM;		// ਯ ⥬
typedef struct QMX_CCTL QMX_CCTL;		// ਯ ३-஫
typedef struct QMX_MODULE QMX_MODULE;		// ਯ 
// 
typedef struct QMX_MOD_FLASH QMX_MOD_FLASH;	// ⥬   
typedef struct QMX_AVR_FLASH QMX_AVR_FLASH;
// ᯮ⥫ 
typedef struct QMX_PARSER_PARAMS QMX_PARSER_PARAMS;

int QMX_Init(void);
int QMX_Exit(void);

// ஢ 㭪樨 ======================================================
void QMX_ClearErrorHelpers(QMX_SYSTEM *SD);
QMX_EXT QMX_API int __stdcall QMX_MOD_Start(QMX_SYSTEM *SD, BYTE Slot);
QMX_EXT QMX_API int __stdcall QMX_MOD_Stop(QMX_SYSTEM *SD, BYTE Slot);
QMX_EXT QMX_API int __stdcall QMX_OpenOnly(WORD VirtualSlot, QMX_SYSTEM **QSD); // open without loading any fpga
QMX_EXT QMX_API int __stdcall QMX_GetControllerInfo(QMX_SYSTEM *SD);
QMX_EXT QMX_API int __stdcall QMX_SendCommand(QMX_SYSTEM *SD, WORD Command, WORD Param); // old name is RtSendCommandToModule
QMX_EXT QMX_API int __stdcall QMX_PutArray(QMX_SYSTEM *SD, WORD Target, WORD LocalAddress, WORD N, BYTE *Data);
QMX_EXT QMX_API int __stdcall QMX_GetArray(QMX_SYSTEM *SD, WORD Target, WORD LocalAddress, WORD N, BYTE *Data);
QMX_EXT QMX_API int __stdcall QMX_PutQMbus(QMX_SYSTEM *SD, WORD BusAddress, WORD N, WORD *Data);
QMX_EXT QMX_API int __stdcall QMX_GetQMbus(QMX_SYSTEM *SD, WORD BusAddress, WORD N, WORD *Data);
QMX_EXT QMX_API int __stdcall QMX_PutFlash(QMX_SYSTEM *SD, QMX_AVR_FLASH *fi);  // internal flash of controller's AVR
QMX_EXT QMX_API int __stdcall QMX_GetFlash(QMX_SYSTEM *SD, QMX_AVR_FLASH *fi);  // internal flash of controller's AVR

// address in bytes offset
QMX_EXT QMX_API int __stdcall QMX_PutI2C(QMX_SYSTEM *SD, BYTE Slot, WORD Address, WORD N, BYTE *Buffer, BOOL WriteEnable); // modules EEPROM; ON LOADED fpga ONLY
QMX_EXT QMX_API int __stdcall QMX_GetI2C(QMX_SYSTEM *SD, BYTE Slot, WORD Address, WORD N, BYTE *Buffer); // modules EEPROM;  ON LOADED fpga ONLY

QMX_EXT QMX_API int __stdcall QMX_LoadMasterFPGA(QMX_SYSTEM *SD, char *FileName);
QMX_EXT QMX_API int __stdcall QMX_LoadFPGA(QMX_SYSTEM *SD, char *FileName);
QMX_EXT QMX_API int __stdcall QMX_ResetReadPipe(QMX_SYSTEM *SD);
QMX_EXT QMX_API int __stdcall QMX_ResetWritePipe(QMX_SYSTEM *SD);
QMX_EXT QMX_API int __stdcall QMX_GetOsVer(void);
QMX_EXT QMX_API int QMX_ServerSync(QMX_SYSTEM *SD, HANDLE Event);
QMX_EXT QMX_API int __stdcall QMX_Units2StrF(QMX_CC_F *cc);
QMX_EXT QMX_API int __stdcall QMX_Units2StrD(QMX_CC_D *cc);
QMX_EXT QMX_API int __stdcall QMX_TtfPathFromRegistry(QMX_SYSTEM *SD, char *path, DWORD path_len);

// ᠭ  ===========================================================
//  ⥬  짮⥫᪮ 
#pragma pack(push)
#pragma pack(1)
//     
struct QMX_MOD_FLASH {
 BYTE Name[9];			//  
 BYTE Revision;			//  
 BYTE SerialNumber[9];          // ਩  
 BYTE FPGA;			// ToDo:  ᫨ DSP?
 BYTE RAMSize;	 		//     (⥫ ⥯ 2) ToDo: ᫮  ?
 BYTE Direction;		// ࠢ ᪮⭮ ।  (    ). MOD_TYPE_INPUT || MOD_TYPE_OUTPUT

 WORD Type;
 BYTE FlashSize; 		// 2^n
 WORD ExtentionLen;
 BYTE Reserved[3];
 WORD CRC;			// include mod extention
};				// len: 32 bytes

// ਯ 
struct QMX_MODULE {
 QMX_MOD_FLASH 	  FlashHdr;	   // ⥬  FLASH
 WORD		  Address;	   //  
 WORD		  AddressRange;	   // 殮 ᭮ ࠭⢠ ToDo: ᫮  ?
 WORD		  InterruptVector; //  뢠

 double		  InputOutputRate; //  ᡮ/뤠  ( )
 DWORD		  LocalBufferSize; //   쭮  ( ᫮ c ⮬ ⪨ )
 BYTE		  DMAnumber;	   // 浪    

 BYTE		  On_Off;	   //  ࠡ . QMX_ON || QMX_OFF
 BYTE		  ChannelsN;	   // -  ,   ⮪ 
};

// ਯ ३ ஫
struct QMX_CCTL {
 HANDLE		  DevHandle;	   //  ࠩ (⢨⥫ ⮫쪮  , 襬 ࠩ.  ⠫ . GDevHandle[QMX_CCTL->VirtualSlot]
 WORD		  VirtualSlot;	   // 㠫 ᫮ ⮩ ⥬
 CHAR		  Name[10];        //  ஫
 CHAR		  BIOSversion[5];  //   ஫
 CHAR		  SerialNumber[9]; // ਩  ஫
};

// ਯ 横᪮ 
struct QMX_CIRC_BUF {
 volatile HANDLE Reserved;			//  ꥪ filemapping ( ᭮ ࠭⢥ ࢥ)
 volatile DWORD Length;				// ᨬ ࠧ   ᫮ (=ࠧ filemapping / 2)
 volatile SHORT *Data_first;			// 㪠⥫  ࢮ ᫮  ( ࢥ)
 volatile SHORT *Data_last;			// 㪠⥫  ᫥ 䠪᪮ ᫮  ( ࢥ)
 volatile DWORD T_length;			// ࠧ   
 volatile DWORD S_length;			// ࠧ   ᫮
 volatile DWORD Writed;				//  稪 ᠭ ᫮ ( ࢥ )
 volatile DWORD Readed;				//  稪 ⠭ ᫮ ( ࢥ 뢮)
 volatile DWORD WritePtr;			// 稪 [0..S_length-1] ᠭ ᫮ ( ࢥ )
 volatile DWORD ReadPtr;			// 稪 [0..S_length-1] ⠭ ᫮ ( ࢥ 뢮)
 volatile SHORT *Writed_ptr;			// 㪠⥫  ᫥ ᠭ ᫮ ( ᭮ ࠭⢥ ࢥ)
 volatile SHORT *Readed_ptr;			// 㪠⥫  ᫥ ⠭ ᫮ ( ᭮ ࠭⢥ ࢥ)
 volatile HANDLE SyncEvent;			// ᨣ   । 樨 
};


//    ࠧ  
#define QMX_PARSER_MODE_SLOT_TAG	0
#define QMX_PARSER_MODE_SLOT_DATA	1
#define QMX_PARSER_MODE_FLOW_ERROR	2

struct QMX_PARSER_PARAMS {
 BYTE CurSlot;
 BYTE CurMode;
 SHORT *ParsePtr;
 DWORD DataToParse;
 DWORD SlotDataToParse;
};

// ਯ ⥬ ( 楫  ࠧ塞 )
struct QMX_SYSTEM {
 BYTE 		  UsbSpeed;	   //  ᪮ USB
 BYTE 		  ModulesQuantity; // ⢮ 㫥  ⥬
 QMX_CCTL 	  Controller;	   // , 뢠 ३-஫
 QMX_MODULE	  QM_Module[8];    // , 뢠騥 㫨
 DWORD  	  ReadFileSize;	   //  ਤ䠩  
 DWORD  	  WriteFileSize;   //  ࠩ䠩  
 DWORD  	  DMAinputSize;	   //   DMA  ਥ  ToDo: ᫮  ?
 DWORD  	  DMAoutputSize;   //   DMA  뤠  ToDo: ᫮  ?
 WORD   	  RespTime;	   // ⭮ ६ ॠ樨  
 WORD   	  InOutState;	   // 饥 ﭨ (⨢ /뢮);
 HANDLE		  SdFileMapping;   // ꥪ FileMapping ᮧ  ࠭ ਯ QMX_SYSTEM
 BYTE		  IsRun;	   // QMX_ON -  ; QMX_OFF -  ⮯
 HANDLE		  SyncMutex;	   // ꥪ ᨭ஭樨
//  ࠡ  ࢥࠬ:
 BYTE		  ServerStatus;    //  ࢥ ( 訡)
 DWORD		  HostProcessId;   // PID  襣 ⥬
 DWORD		  ServerProcessId; // PID  ࢥ
 HANDLE		  PrepareEvent;	   //    QMX_Prepare  砥  ᯥ譮 襭
 HANDLE		  StartEvent;	   //   砫 QMX_Start  砥  ᯥ譮 襭
 HANDLE		  StopEvent;	   //    QMX_Stop  砥  ᯥ譮 襭
 HANDLE		  CloseEvent;	   //    QMX_Close  砥  ᯥ譮 襭
 HANDLE		  ReadyEvent;	   //  ࢥ஬  ⢥ত Prepare, Start, Stop
 HANDLE 	  StoreFile;	   //  䠩  ஬ ࢥ  뢠  ( . ࢥ)

 QMX_CIRC_BUF 	  InBuf[8];	   // ᪨ 室    ᫮
 QMX_CIRC_BUF 	  OutBuf[8];	   // ᪨ 室    ᫮ (8  饥)

 int (* QMX_PrepareCB)(HANDLE SD, QMX_CONFIG *Config);
 int (* QMX_CloseCB)(HANDLE SD);
 int (* QMX_StartCB)(HANDLE SD);
 int (* QMX_StopCB)(HANDLE SD);

 QMX_PARSER_PARAMS ParserParams;
};

//
struct QMX_AVR_FLASH {
 BYTE FlashBytes[256];
};
#pragma pack(pop)

// ࠢ騥   DeviceIoControl ========================================
#define IOCTL_GET_CONFIG        CTL_CODE (FILE_DEVICE_UNKNOWN,0x800,METHOD_BUFFERED,FILE_ANY_ACCESS)
#define DIOC_START              CTL_CODE (FILE_DEVICE_UNKNOWN,0x1,METHOD_OUT_DIRECT,FILE_ANY_ACCESS)
#define DIOC_STOP               CTL_CODE (FILE_DEVICE_UNKNOWN,0x2,METHOD_OUT_DIRECT,FILE_ANY_ACCESS)
#define DIOC_LOAD_BIOS_USB      CTL_CODE (FILE_DEVICE_UNKNOWN,0x3,METHOD_OUT_DIRECT,FILE_ANY_ACCESS)
#define DIOC_SEND_COMMAND       CTL_CODE (FILE_DEVICE_UNKNOWN,0x4,METHOD_OUT_DIRECT,FILE_ANY_ACCESS)
#define DIOC_RESET_PIPE1        CTL_CODE (FILE_DEVICE_UNKNOWN,0x5,METHOD_OUT_DIRECT,FILE_ANY_ACCESS)
#define DIOC_RESET_PIPE3        CTL_CODE (FILE_DEVICE_UNKNOWN,0x6,METHOD_OUT_DIRECT,FILE_ANY_ACCESS)

//  㯭 짮⥫᪨ ᮢ  USB (vendor request) =========
enum {  V_RESET_DSP,
        V_PUT_ARRAY,
        V_GET_ARRAY,
        V_START_READ,
        V_START_WRITE,
        V_COMMAND_IRQ,
        V_GET_USB_SPEED,
	V_GET_MODULE_NAME = 11,
	V_GET_MODULE_SERIAL_NUMBER = 13
};


// ,      V_COMMAND_IRQ ===========================
#define CMD_START_LOAD_MASTER_FPGA	0x0000
#define CMD_STOP_LOAD_FPGA	     	0x0002
#define CMD_RESET_WHOLE_SYSTEM		0x0004
#define CMD_SET_IAO			0x0005
#define CMD_START_STOP      		0x0006
#define CMD_SYNC_TYPE      		0x0007 // (0 manual, 1 external)

//==============================================================================
#define MAX_USB_BLOCK           4096            // ᨬ쭮 -   ।  ContolPipe
#define I2C_BASE                0xA400          //    饭  I2C 誨  樠樨
#define I2C_BASE_USER           0xA600          //    饭  I2C 誨 ᫥ 樠樨

#define	MCLK			36000000.0
#define	MAX_MODULES	        8
#define	MAX_FILE_SIZE		(1024*1024)
#define	MAX_SYSTEM_SPEED_2_0	10000.0		// kSamples for usb 2.0
#define	MAX_SYSTEM_SPEED_1_1	500.0		// kSamples for usb 1.1
#define	MAX_DMA_SIZE		0x20000

#define SETBIT(ADDRESS,BIT) (ADDRESS |= (1<<BIT))
#define CLEARBIT(ADDRESS,BIT) (ADDRESS &= ~(1<<BIT))

#define MOD_TYPE_INPUT	        0
#define MOD_TYPE_OUTPUT         1


// ࠭⢠  饭   ============================================
#define FLASH_TARGET		0x0000		// 饭  
#define FPGA_TARGET		0x0001		//   
#define BUS_TARGET		0x0002		// 饭  設 QMbus
#define CNTR_REGS_TARGET	0x0003		// ⥭  ॣ஢
#define IR_STATUS_TARGET	0x0004		// ⥭ ﭨ IR ( 樠樨)
#define I2C_TARGET	        0x0005		// 饭  I2C
#define DMA_ORDER_TARGET        0x0006		//   ॣ ⮬ DMA
#define START_STOP_TARGET       0x0007		// /⠭ 㫥
#define DMA_SIZE_TARGET		0x0008		// ய뢠 ࠧ஢ DMA

//  ॣ஢,    㫥 ਨ QM
#define DMA_STROBE_ADDR		0x0000		// 饭  쭮   
#define LOC_BUF_LEN_LSB_ADDR	0x0001		// 襥 ᫮  쭮 
#define LOC_BUF_LEN_MSB_ADDR	0x0002		// 襥 ᫮  쭮 
#define START_ADDR		0x0003		//  ᪠/⠭  / write 1 - start; 0 -stop
#define MARKER_ADDR		0x0004		//  થ 쭮 
#define FLASH_ENA_ADDR		0x0005		// 饭  
#define START_LOAD_ADDR		0x0006		//  ࢮ砫쭮   뢮
#define IO_RATE_ADDR		0x0007		// mod rate = 36MHz/(IO_RATE+1) (min speed is 600Hz)
#define START_MODE_ADDR		0x0008		//  ० ᪠  (ToDo:    ???)

//  ॣ஢ QM14
#define	QM14_TEST_TYPE_ADDR	0x1e		// 롮  ⮢ ᫥⥫쭮

//  ॣ஢ QMS10
#define	QMS10_ADC_MODE_ADDR	0x10		//     ᨭ஭ ⥭
#define	QMS10_ADC_DATA_ADDR	0x11		//  - ᨭ஭  . ⥭ - ⥭  .
#define	QMS10_DAC_DATA_ADDR	0x12		//  ᫮ 
#define	QMS10_TABLE_LEN_ADDR	0x13		//   ⠡ 
#define	QMS10_TABLE_DATA_ADDR	0x14		//  ᮤন ⠡ .


//  ॣ஢ QMS15
#define	QMS15_ADC_MODE_ADDR	0x10		//     ᨭ஭ ⥭
#define	QMS15_ADC_DATA_ADDR	0x11		//  - ᨭ஭  . ⥭ - ⥭  .
#define	QMS15_TABLE_LEN_ADDR	0x13		//   ⠡ 
#define	QMS15_TABLE_DATA_ADDR	0x14		//  ᮤন ⠡ .



//  ॣ஢ QMS17
#define	QMS17_ADC_MODE_ADDR	0x10		//     ᨭ஭ ⥭
#define	QMS17_ADC_DATA_ADDR	0x11		//  - ᨭ஭  . ⥭ - ⥭  .
#define	QMS17_TABLE_LEN_ADDR	0x13		//   ⠡ 
#define	QMS17_TABLE_DATA_ADDR	0x14		//  ᮤন ⠡ .
#define	QMS17_DIAP_RELEY_ADDR	0x15		// ४祭    ५



//  ॣ஢ QMS45
#define QMS45_DAC_DATA_ADDR	0x10		//   
#define QMS45_DAC_CHANNEL_ADDR	0x11		//   
#define QMS45_DAC_MODE_ADDR	0x12		//  ᨭ/ᨭ
#define QMS45_DAC_ENABLE_ADDR	0x13		// /몫 ⠭


//  ॣ஢ QMS50
#define	QMS50_STROBE_SEL_ADDR	0x15		// 롮 筨 ஡ (0 - 譨 ஡)
#define	QMS50_IO_DIR		0x16		// ࠢ  (1 -  室)
#define	QMS50_IO_STATE		0x17		// ﭨ  (1 -   1)


//  ॣ஢ QMS75
#define	QMS75_SET_RELAYS_ADDR	0x17		// ⠭ ५


//  ॣ஢ QMS80
#define	QMS80_DAC_DATA_ADDR	0x0A		//   
#define	QMS80_DAC_ADDR_ADDR	0x0B		//  
#define	QMS80_WIRE_CH_ADDR	0x0C		//    ஢
#define	QMS80_ADC_MODE_ADDR	0x10		//     ᨭ஭ ⥭
#define	QMS80_ADC_DATA_ADDR	0x11		//  - ᨭ஭  . ⥭ - ⥭  .
#define	QMS80_TABLE_LEN_ADDR	0x13		//   ⠡ 
#define	QMS80_TABLE_DATA_ADDR	0x14		//  ᮤন ⠡ .


//  ॣ஢ QMS85
#define	QMS85_DAC_ADDR_ADDR	0x0A		//  
#define	QMS85_DAC_DATA_ADDR	0x0B		//   
#define	QMS85_AD8556_ADDR	0x0C		//  ᨫ⥫ AD8556
#define	QMS85_CHANNEL_MASK_ADDR	0x0D		//  ᪨ 
#define	QMS85_FILTR_LENGTH_ADDR	0x0E		//  ᪨ 
#define	QMS85_ADC_MODE_ADDR	0x10		//     ᨭ஭ ⥭
#define	QMS85_ADC_DATA_ADDR	0x11		//  - ᨭ஭  . ⥭ - ⥭  .
#define	QMS85_TABLE_LEN_ADDR	0x13		//   ⠡ 
#define	QMS85_TABLE_DATA_ADDR	0x14		//  ᮤন ⠡ .


//  ॣ஢ QMS90
#define	QMS90_OUTPUT_EN_ADDR		0x10		// 롮 筨 ஡ (0 - 譨 ஡)
#define	QMS90_IO_READ_LATCH_ADDR	0x11		// ࠢ  (1 -  室)
#define	QMS90_IO_STATE_ADDR		0x12		// ﭨ  (1 -   1)


//  ஫ ॣ஢   ==========================================
#define INTERRUPT_VECTOR	0		//
#define FPGA_STATUS_BYTE	1		//
#define DMA_STATUS_BYTE	        2		//

// ⥬ 訡 ============================================================
#define QMXE_INTERNAL_ERR			0x8000		// ਧ ⥬ 訡
#define QMXE_VENDOR_GET_USB_SPEED       	(QMXE_INTERNAL_ERR|1L)
#define QMXE_VENDOR_GET_CRATE_NAME      	(QMXE_INTERNAL_ERR|2L)
#define QMXE_VENDOR_GET_CRATE_SN       		(QMXE_INTERNAL_ERR|3L)
#define QMXE_INVALID_HANDLE_VALUE       	(QMXE_INTERNAL_ERR|4L)
#define QMXE_VENDOR_SEND_CMD            	(QMXE_INTERNAL_ERR|5L)
#define QMXE_RESET_MASTER_FPGA          	(QMXE_INTERNAL_ERR|6L)
#define QMXE_VENDOR_PUT_ARRAY           	(QMXE_INTERNAL_ERR|7L)
#define QMXE_VENDOR_GET_ARRAY           	(QMXE_INTERNAL_ERR|8L)
#define QMXE_PUT_FLASH                  	(QMXE_INTERNAL_ERR|9L)
#define QMXE_GET_FLASH                  	(QMXE_INTERNAL_ERR|10L)
#define QMXE_SYSTEM_RESET               	(QMXE_INTERNAL_ERR|11L)
#define QMXE_GET_IR                     	(QMXE_INTERNAL_ERR|12L)
#define QMXE_SET_IAO                    	(QMXE_INTERNAL_ERR|13L)
#define QMXE_MAX_MODULES_REACHED        	(QMXE_INTERNAL_ERR|14L)
#define QMXE_FPGA_STATUS_BYTE_READ      	(QMXE_INTERNAL_ERR|15L)
#define QMXE_FPGA_CONFIGURATION         	(QMXE_INTERNAL_ERR|16L)
#define QMXE_READ_I2C_FLASH             	(QMXE_INTERNAL_ERR|17L)
#define QMXE_WRITE_BASE_ADDRESS         	(QMXE_INTERNAL_ERR|18L)
#define QMXE_GET_ADDRESS_SPACE_CODE     	(QMXE_INTERNAL_ERR|19L)
#define QMXE_SET_BASE_ADDRESS           	(QMXE_INTERNAL_ERR|20L)
#define QMXE_PUT_QM_BUS                 	(QMXE_INTERNAL_ERR|21L)
#define QMXE_GET_QM_BUS                 	(QMXE_INTERNAL_ERR|22L)
#define QMXE_INSUFFICIENT_ADDRESS_SPACE 	(QMXE_INTERNAL_ERR|23L)
#define QMXE_VENDOR_RESET_RD_PIPE       	(QMXE_INTERNAL_ERR|24L)
#define QMXE_VENDOR_RESET_WR_PIPE       	(QMXE_INTERNAL_ERR|25L)
#define QMXE_WRITE_INT_VECTOR           	(QMXE_INTERNAL_ERR|26L)

//  ࠡ  ஢묨 樥⠬ ==================================
#define QMX_BUILD_UNIT_CODE(ORDER, UNITS)	((ORDER<<5)|(UNITS&0x1F))
#define QMX_ORDER_PICO				0
#define QMX_ORDER_NANO				1
#define QMX_ORDER_MICRO				2
#define QMX_ORDER_MILLI				3
#define QMX_ORDER_NO				4
#define QMX_ORDER_KILO				5
#define QMX_ORDER_MEGA				6
#define QMX_ORDER_GIGA				7

#define QMX_UNITS_V				0
#define QMX_UNITS_A				1
#define QMX_UNITS_OHM				2
#define QMX_UNITS_UNKMOWN			15

// ⮢  ନ஢ ப  . ७   砥  QMX_BUILD_UNIT_CODE
static char *QMX_ORDERS[8]={"p","n","u","m","","k","M","G"};
static char *QMX_UNITS[32]={"V", "A", "Ohm","","","","","","","","","","","","","","","","","","","","","","","","","","","","",""};
#endif
