#ifndef __qms80_h__
#define __qms80_h__
#include "qmx.h"


#define QMX_QMS80_GAIN_25mV		0
#define QMX_QMS80_GAIN_50mV		1
#define QMX_QMS80_GAIN_100mV	2
#define QMX_QMS80_GAIN_12_5mV	3


QMX_EXT QMX_API int __stdcall QMX_QMS80_SetTable(HANDLE SD, BYTE Slot, BYTE GetWires, WORD *Table, WORD TableLen);
QMX_EXT QMX_API int __stdcall QMX_QMS80_ReadCurrentDacCC(HANDLE SD, BYTE Slot, QMX_CC_F *CC);
QMX_EXT QMX_API int __stdcall QMX_QMS80_ReadCC(HANDLE SD, BYTE Slot, WORD Gain, QMX_CC_F *CC);
QMX_EXT QMX_API int __stdcall QMX_QMS80_SetCurrent(HANDLE SD, BYTE Slot, QMX_CC_F *CC, double Current, double *RealCurrent);	// Set current through the sensors 
QMX_EXT QMX_API int __stdcall QMX_QMS80_RoughBalance(HANDLE SD, BYTE Slot, WORD Voltage);	// rough balance
QMX_EXT QMX_API int __stdcall QMX_QMS80_ChannelTuning(HANDLE SD, BYTE Slot, WORD Voltage, BYTE Channel);	// thin balance
QMX_EXT QMX_API int __stdcall QMX_QMS80_GetAdc(HANDLE SD, BYTE Slot, WORD Mode, WORD *Data);	// Async
QMX_EXT QMX_API int __stdcall QMX_QMS80_GetWireResistance(HANDLE SD, BYTE Slot, WORD Channel, WORD Gain, WORD *Data);	// Async
QMX_EXT QMX_API int __stdcall QMX_QMS80_AutoBalance(HANDLE SD, BYTE Slot, WORD Gain, QMX_CC_F *CC);	// AutoBalance
QMX_EXT QMX_API int __stdcall QMX_QMS80_AutoBalance_Ext(HANDLE SD, BYTE Slot, WORD Gain, QMX_CC_F *CC, WORD *RoughDACdata, WORD *ChannelDACdata);	// AutoBalance
QMX_EXT QMX_API int __stdcall QMX_QMS80_SetAdcRate(HANDLE SD, BYTE Slot, double DRate, double *CRate);

#endif