//  ,     QMS10, 
//   
//     .

//     :

//1.  .
//2.   -  
//	   QMS10    4 /.
//3.   
//4.     100      
//	 ,    .
//5.   Esc   ,   .


#include "../../dll/qmx.h"
#include <shellapi.h>
#include <stdio.h>
#include <conio.h> 


HANDLE SD;                              //  
QMX_CONFIG CFG;                         //  
WORD QMS10Table[16];					//     QMS10
QMX_CC_F CC_Adc[3];						//  

static unsigned int DataPtr, DataPtrOld, CurrentPtr, LengthDataBuf;
static unsigned short int *Data;



static unsigned int QMS_data[8][32], QMS_iter[8][32], time;

void CheckErr(void);
void quit(void);
void DisplayData(void);

//void main(void)
void main(int argc, char* argv[])
{
	char s_wrk[64];
	int i_wrk, mod, ch;

	printf("Please wait....\r");
	
	//  
	ShellExecuteW(NULL, TEXT("open"), TEXT("qmbox_ds.exe"), TEXT("-p3"), NULL, SW_SHOWNORMAL);
	Sleep(500);

	//   
	SD = 0;
	SD=QMX_CircBufAttach(0);
	if (SD == NULL) {
		printf("ERROR: No QMBox found.");
		quit(); 
	}

	//  
	QMX_InitModules(SD, QMX_LOG_NONE, NULL);
	CheckErr();

	//   QMX_Prepare -   
	// ..     
	QMX_MOD_SetActive(SD, 0, QMX_ON);
	QMX_Prepare(SD, 100, &CFG);
	CheckErr();
	QMX_MOD_SetActive(SD, 0, QMX_OFF);
	
	// ,      -  QMS10
	strncpy_s (s_wrk, CFG.ModName[0], 10);
	s_wrk[10] = 0;
	if (!_stricmp(s_wrk, "QMS10v1")){
		printf("Module name OK\n");
	}
	else{
		printf("Name error\n");
		quit();
	}
	
	
	//      
	//     -   1, 4  16
	for (i_wrk=0; i_wrk<3; i_wrk++) QMX_QMS10_ReadCC(SD, 0, i_wrk, &CC_Adc[i_wrk]);

	//     QMS10:
	//       5    -   
	//    1, 4, 16, 1  4
	QMX_QMS10_BuildTableItem(SD, 0, QMX_QMS10_MODE_D, QMX_QMS10_GAIN_1,  &QMS10Table[0]);
	QMX_QMS10_BuildTableItem(SD, 1, QMX_QMS10_MODE_D, QMX_QMS10_GAIN_4,  &QMS10Table[1]);
	QMX_QMS10_BuildTableItem(SD, 2, QMX_QMS10_MODE_D, QMX_QMS10_GAIN_16, &QMS10Table[2]);
	QMX_QMS10_BuildTableItem(SD, 3, QMX_QMS10_MODE_D, QMX_QMS10_GAIN_1,  &QMS10Table[3]);
	QMX_QMS10_BuildTableItem(SD, 4, QMX_QMS10_MODE_D, QMX_QMS10_GAIN_4,  &QMS10Table[4]);

	//     
	QMX_QMS10_SetTable(SD, 0, QMS10Table, 5);

	//     - 20  (4   )
	QMX_QMS10_SetAdcRate(SD, 0, 20000.0, NULL);

	//    
	QMX_MOD_SetActive(SD, 0, QMX_ON);
	QMX_Prepare(SD, 100, &CFG);
	CheckErr();
	
	LengthDataBuf = *CFG.CBInput.buf_size;						//    ,  
	Data = (unsigned short int*)CFG.CBInput.buf_start;			//      ,
																//  
	DataPtrOld = 0;
	time = 0;

	//   
	QMX_Start(SD);
	CheckErr();

	while (!_kbhit()){											//    
																// (   )

		DataPtr = *CFG.CBInput.buf_ptr;							//     
																//   						
		for (CurrentPtr = DataPtrOld; CurrentPtr != DataPtr; CurrentPtr += 2) { //      
			
			if(CurrentPtr >= *CFG.CBInput.buf_size)				// , 
				CurrentPtr = 0;									//    
			if ((!CurrentPtr)&&(!DataPtr))break;				//     

			mod = (Data[CurrentPtr] >> 5) & 0x07;				//   () 16-      
			ch  = Data[CurrentPtr]  & 0x1f;						//     ( 5- )   (. 3- ).
			QMS_data[mod][ch] += Data[CurrentPtr+1];			//   () 16-     
																//   () 16-     
																//          
																// (  ).
																//        ([][])
																//   .      
																//      ,    
																//    .
			QMS_iter[mod][ch]++;								//      
	
		}

		DataPtrOld = DataPtr;						//      
													//  

		time++;										//   100  
		if (time >=5){								//     0.5 ,
			DisplayData();							//    
			time = 0;								//    100  
		}

		Sleep(100);									//         100 
													//        Sleep  
													//        

 }

	quit();											//   
}


//   
void quit(void){
	
	printf("\n\n Please wait....\r");
	QMX_Stop(SD, QMX_STOP_ALL);			//  
	QMX_MOD_SetStartMode(SD, 0xFF, QMX_START_MODE_MANUAL); 									

	QMX_CircBufDetach(SD);              //    USB
										//  
	ShellExecute(NULL, TEXT("open"), TEXT("qmbox_ds.exe"), TEXT("-s0"), NULL, SW_SHOWNORMAL);
	printf("\n\n");
	ExitProcess(0);
}


//   
void CheckErr(void) {
char tmp_str[1024];

if (QMX_GetLastError(SD, tmp_str, sizeof(tmp_str))==QMX_OK){ return;}
else  {	printf("%s\n", tmp_str);	quit();}
}


//  
void DisplayData(void){

	double d_wrk;

	//     ,       
	//       :
	d_wrk = ((double)QMS_data[0][0]) / ((double)QMS_iter[0][0]) * CC_Adc[0].Scale + CC_Adc[0].Offset;
	printf("%8.4f V ", d_wrk);
	d_wrk = ((double)QMS_data[0][1]) / ((double)QMS_iter[0][1]) * CC_Adc[1].Scale + CC_Adc[1].Offset;
	printf("%8.4f V ", d_wrk);
	d_wrk = ((double)QMS_data[0][2]) / ((double)QMS_iter[0][2]) * CC_Adc[2].Scale + CC_Adc[2].Offset;
	printf("%8.4f V ", d_wrk);
	d_wrk = ((double)QMS_data[0][3]) / ((double)QMS_iter[0][3]) * CC_Adc[0].Scale + CC_Adc[0].Offset;
	printf("%8.4f V ", d_wrk);
	d_wrk = ((double)QMS_data[0][4]) / ((double)QMS_iter[0][4]) * CC_Adc[1].Scale + CC_Adc[1].Offset;
	printf("%8.4f V\r", d_wrk);

	
	//       :
	QMS_data[0][0] = 0; QMS_iter[0][0] = 0; 
	QMS_data[0][1] = 0; QMS_iter[0][1] = 0;
	QMS_data[0][2] = 0; QMS_iter[0][2] = 0;
	QMS_data[0][3] = 0; QMS_iter[0][3] = 0;
	QMS_data[0][4] = 0; QMS_iter[0][4] = 0;
}



